/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.network;

import mcjty.lib.network.AbstractServerCommandTyped;
import mcjty.lib.network.ICommandHandler;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.Logging;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketServerCommandTyped
extends AbstractServerCommandTyped {
    public PacketServerCommandTyped() {
    }

    public PacketServerCommandTyped(BlockPos pos, String command, TypedMap params) {
        super(pos, command, params);
        this.dimensionId = null;
    }

    public PacketServerCommandTyped(BlockPos pos, Integer dimensionId, String command, TypedMap params) {
        super(pos, command, params);
        this.dimensionId = dimensionId;
    }

    public static class Handler
    implements IMessageHandler<PacketServerCommandTyped, IMessage> {
        public IMessage onMessage(PacketServerCommandTyped message, MessageContext ctx) {
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> this.handle(message, ctx));
            return null;
        }

        private void handle(PacketServerCommandTyped message, MessageContext ctx) {
            EntityPlayerMP playerEntity = ctx.getServerHandler().field_147369_b;
            Object world = message.dimensionId == null ? playerEntity.func_130014_f_() : DimensionManager.getWorld((int)message.dimensionId);
            if (world == null) {
                return;
            }
            TileEntity te = world.func_175625_s(message.pos);
            if (!(te instanceof ICommandHandler)) {
                Logging.log("createStartScanPacket: TileEntity is not a CommandHandler!");
                return;
            }
            ICommandHandler commandHandler = (ICommandHandler)te;
            if (!commandHandler.execute(playerEntity, message.command, message.params)) {
                Logging.log("Command " + message.command + " was not handled!");
            }
        }
    }
}

