/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.block;

import com.google.common.collect.ImmutableList;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.mantle.block.BlockInventory;
import slimeknights.mantle.block.EnumBlock;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.smeltery.IFaucetDepth;
import slimeknights.tconstruct.shared.block.BlockTable;
import slimeknights.tconstruct.smeltery.tileentity.TileCasting;
import slimeknights.tconstruct.smeltery.tileentity.TileCastingBasin;
import slimeknights.tconstruct.smeltery.tileentity.TileCastingTable;

public class BlockCasting
extends BlockInventory
implements IFaucetDepth {
    public static final PropertyEnum<CastingType> TYPE = PropertyEnum.func_177709_a((String)"type", CastingType.class);
    private static ImmutableList<AxisAlignedBB> BOUNDS_Table = ImmutableList.of((Object)new AxisAlignedBB(0.0, 0.625, 0.0, 1.0, 1.0, 1.0), (Object)new AxisAlignedBB(0.0, 0.0, 0.0, 0.25, 0.625, 0.25), (Object)new AxisAlignedBB(0.75, 0.0, 0.0, 1.0, 0.625, 0.25), (Object)new AxisAlignedBB(0.75, 0.0, 0.75, 1.0, 0.625, 1.0), (Object)new AxisAlignedBB(0.0, 0.0, 0.75, 0.25, 0.625, 1.0));
    private static ImmutableList<AxisAlignedBB> BOUNDS_Basin = ImmutableList.of((Object)new AxisAlignedBB(0.0, 0.25, 0.0, 1.0, 1.0, 1.0), (Object)new AxisAlignedBB(0.0, 0.0, 0.0, 0.3125, 0.25, 0.3125), (Object)new AxisAlignedBB(0.6875, 0.0, 0.0, 1.0, 0.25, 0.3125), (Object)new AxisAlignedBB(0.6875, 0.0, 0.6875, 1.0, 0.25, 1.0), (Object)new AxisAlignedBB(0.0, 0.0, 0.6875, 0.3125, 0.25, 1.0));

    public BlockCasting() {
        super(Material.field_151576_e);
        this.func_149711_c(3.0f);
        this.func_149752_b(20.0f);
        this.func_149647_a((CreativeTabs)TinkerRegistry.tabSmeltery);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        for (CastingType type : CastingType.values()) {
            list.add((Object)new ItemStack((Block)this, 1, type.getMeta()));
        }
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new ExtendedBlockState((Block)this, new IProperty[]{TYPE}, new IUnlistedProperty[]{BlockTable.INVENTORY, BlockTable.FACING});
    }

    public int func_176201_c(IBlockState state) {
        return ((CastingType)((Object)state.func_177229_b(TYPE))).getMeta();
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        if (meta < 0 || meta >= CastingType.values().length) {
            meta = 0;
        }
        return this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)CastingType.values()[meta]));
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    @Nonnull
    public TileEntity func_149915_a(@Nonnull World worldIn, int meta) {
        switch ((CastingType)((Object)this.func_176203_a(meta).func_177229_b(TYPE))) {
            case TABLE: {
                return new TileCastingTable();
            }
            case BASIN: {
                return new TileCastingBasin();
            }
        }
        return null;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (playerIn.func_70093_af()) {
            return false;
        }
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof TileCasting) {
            ((TileCasting)te).interact(playerIn);
            return true;
        }
        return super.func_180639_a(worldIn, pos, state, playerIn, hand, facing, hitX, hitY, hitZ);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(world, pos, state, placer, stack);
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof TileCasting) {
            ((TileCasting)te).setFacing(placer.func_174811_aO().func_176734_d());
        }
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public IBlockState getExtendedState(@Nonnull IBlockState state, IBlockAccess world, BlockPos pos) {
        IExtendedBlockState extendedState = (IExtendedBlockState)state;
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof TileCasting) {
            TileCasting tile = (TileCasting)te;
            return tile.writeExtendedBlockState(extendedState);
        }
        return super.getExtendedState(state, world, pos);
    }

    public boolean isSideSolid(@Nonnull IBlockState base_state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull EnumFacing side) {
        if (base_state.func_177229_b(TYPE) == CastingType.BASIN) {
            return side != EnumFacing.DOWN;
        }
        return super.isSideSolid(base_state, world, pos, side);
    }

    public RayTraceResult func_180636_a(IBlockState blockState, @Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull Vec3d start, @Nonnull Vec3d end) {
        if (blockState.func_177229_b(TYPE) == CastingType.BASIN) {
            return BlockTable.raytraceMultiAABB(BOUNDS_Basin, pos, start, end);
        }
        return BlockTable.raytraceMultiAABB(BOUNDS_Table, pos, start, end);
    }

    protected boolean openGui(EntityPlayer player, World world, BlockPos pos) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState blockState, World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof TileCasting)) {
            return 0;
        }
        return ((TileCasting)te).comparatorStrength();
    }

    public boolean func_176225_a(IBlockState blockState, @Nonnull IBlockAccess blockAccess, @Nonnull BlockPos pos, EnumFacing side) {
        return true;
    }

    @Override
    public float getFlowDepth(World world, BlockPos pos, IBlockState state) {
        if (state.func_177229_b(TYPE) == CastingType.TABLE) {
            return 0.125f;
        }
        return 0.725f;
    }

    public static enum CastingType implements IStringSerializable,
    EnumBlock.IEnumMeta
    {
        TABLE,
        BASIN;

        public final int meta = this.ordinal();

        public String func_176610_l() {
            return this.toString().toLowerCase(Locale.US);
        }

        public int getMeta() {
            return this.meta;
        }
    }
}

