/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs4.plugins.vanilla;

import com.google.common.base.Preconditions;
import cubex2.cs4.CustomStuff4;
import cubex2.cs4.api.BlockTint;
import cubex2.cs4.api.Color;
import cubex2.cs4.api.Content;
import cubex2.cs4.api.ContentHelper;
import cubex2.cs4.api.InitPhase;
import cubex2.cs4.compat.waila.WailaData;
import cubex2.cs4.plugins.vanilla.Attribute;
import cubex2.cs4.plugins.vanilla.BlockDrop;
import cubex2.cs4.plugins.vanilla.ColorImpl;
import cubex2.cs4.plugins.vanilla.block.BlockMixin;
import cubex2.cs4.plugins.vanilla.block.BlockRegistry;
import cubex2.cs4.util.IntRange;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.item.Item;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.GameData;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryManager;

public abstract class ContentBlockBase
implements Content {
    public String id;
    public Material material = Material.field_151578_c;
    public Attribute<Float> slipperiness = Attribute.constant(Float.valueOf(0.6f));
    public Attribute<String> creativeTab = Attribute.constant("anonexistingtabtoreturnnull");
    public Attribute<Float> hardness = Attribute.constant(Float.valueOf(1.0f));
    public Attribute<Float> resistance = Attribute.constant(Float.valueOf(0.0f));
    public Attribute<SoundType> soundType = Attribute.constant(SoundType.field_185851_d);
    public Attribute<Integer> maxStack = Attribute.constant(64);
    public Attribute<Integer> opacity = Attribute.constant(255);
    public Attribute<Integer> light = Attribute.constant(0);
    public Attribute<Integer> flammability = Attribute.constant(0);
    public Attribute<Integer> fireSpreadSpeed = Attribute.constant(0);
    public Attribute<Boolean> isFireSource = Attribute.constant(false);
    public Attribute<Boolean> isWood = Attribute.constant(false);
    public Attribute<Boolean> canSustainLeaves = Attribute.constant(false);
    public Attribute<Boolean> isBeaconBase = Attribute.constant(false);
    public Attribute<Float> enchantPowerBonus = Attribute.constant(Float.valueOf(0.0f));
    public Attribute<IntRange> expDrop = Attribute.constant(IntRange.create(0, 0));
    public Attribute<String[]> information = Attribute.constant(new String[0]);
    public Attribute<MapColor> mapColor = Attribute.constant(null);
    public Attribute<ResourceLocation> tileEntity = Attribute.constant(null);
    public Attribute<ResourceLocation> gui = Attribute.constant(null);
    public Attribute<BlockDrop[]> drop = Attribute.constant(null);
    public Attribute<Boolean> isFullCube = Attribute.constant(true);
    public Attribute<Boolean> isOpaqueCube = Attribute.constant(true);
    public Attribute<Boolean> canInteractWithFluidItem = Attribute.constant(true);
    public Attribute<Boolean> isBurning = Attribute.constant(false);
    public Attribute<AxisAlignedBB> bounds = Attribute.constant(BlockMixin.DEFAULT_AABB_MARKER);
    public Attribute<AxisAlignedBB> selectionBounds = Attribute.constant(BlockMixin.DEFAULT_AABB_MARKER);
    public Attribute<AxisAlignedBB> collisionBounds = Attribute.constant(BlockMixin.DEFAULT_AABB_MARKER);
    public Attribute<BlockTint> tint = null;
    public Attribute<Color> itemTint = null;
    public BlockRenderLayer renderLayer = null;
    public Attribute<Boolean> canSilkHarvest = Attribute.constant(true);
    public Attribute<String> harvestTool = Attribute.constant(null);
    public Attribute<Integer> harvestLevel = Attribute.constant(-1);
    public boolean canPlaceOnFloor = true;
    public boolean canPlaceOnCeiling = true;
    public boolean canPlaceOnSides = true;
    public Attribute<EnumPlantType[]> sustainedPlants = Attribute.constant(null);
    public Attribute<Integer> burnTime = Attribute.constant(-1);
    public Attribute<PathNodeType> pathNodeType = Attribute.constant(null);
    public Attribute<Boolean> isWeb = Attribute.constant(false);
    Attribute<ResourceLocation> itemModel = Attribute.constant(null);
    protected transient Block block;
    @Nullable
    protected transient Item item;

    @Override
    public final void init(InitPhase phase, ContentHelper helper) {
        if (phase == InitPhase.PRE_INIT) {
            if (this.isReady()) {
                this.doBlockInit(helper);
            }
        } else if (phase == InitPhase.REGISTER_MODELS) {
            this.registerModels();
            this.createStateMapper().ifPresent(mapper -> ModelLoader.setCustomStateMapper((Block)this.block, (IStateMapper)mapper));
        } else if (phase == InitPhase.REGISTER_BLOCKS) {
            Preconditions.checkState((boolean)this.isReady());
            if (this.block == null) {
                this.doBlockInit(helper);
            }
            ForgeRegistry registry = RegistryManager.ACTIVE.getRegistry(GameData.BLOCKS);
            registry.register((IForgeRegistryEntry)this.block);
        } else if (phase == InitPhase.REGISTER_ITEMS) {
            if (this.item != null) {
                ForgeRegistry registry = RegistryManager.ACTIVE.getRegistry(GameData.ITEMS);
                registry.register((IForgeRegistryEntry)this.item);
            }
        } else if (phase == InitPhase.INIT) {
            if (this.tint != null) {
                CustomStuff4.proxy.setBlockBiomeTint(this.block, subtype -> this.tint.get(subtype).orElse(BlockTint.WHITE));
            }
            if (this.item != null && this.itemTint != null) {
                CustomStuff4.proxy.setItemTint(this.item, subtype -> this.itemTint.get(subtype).orElse(new ColorImpl(-1)).getRGB());
            }
        }
    }

    private void doBlockInit(ContentHelper helper) {
        this.block = this.createBlock();
        this.block.func_149663_c(helper.getModId() + "." + this.id);
        this.block.setRegistryName(this.id);
        BlockRegistry.INSTANCE.register(this.block);
        this.initBlock();
        this.createItem().ifPresent(i -> this.initItem((Item)i, helper));
        WailaData.registerStackProviderBlock(this.block.getClass());
    }

    protected void initItem(Item item, ContentHelper helper) {
        this.item = item;
        item.func_77655_b(helper.getModId() + "." + this.id);
        item.setRegistryName(this.id);
    }

    protected void initBlock() {
    }

    protected void registerModels() {
    }

    public abstract Block createBlock();

    protected Optional<Item> createItem() {
        return Optional.empty();
    }

    protected Optional<IStateMapper> createStateMapper() {
        return Optional.empty();
    }

    protected boolean isReady() {
        return true;
    }
}

