/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.client.gui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.FMLCommonHandler;
import org.lwjgl.opengl.GL11;
import sonar.core.client.gui.IGuiOrigin;
import sonar.core.client.gui.SonarTextField;
import sonar.core.helpers.RenderHelper;

public abstract class GuiSonar
extends GuiContainer
implements IGuiOrigin {
    protected List<SonarTextField> fieldList = new ArrayList<SonarTextField>();
    private boolean shouldReset = false;
    public Object origin;

    public GuiSonar(Container container) {
        super(container);
    }

    public abstract ResourceLocation getBackground();

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        if (this.shouldReset) {
            this.doReset();
        }
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    protected void func_146979_b(int x, int y) {
        super.func_146979_b(x, y);
        this.fieldList.forEach(SonarTextField::func_146194_f);
    }

    protected void func_146976_a(float v, int i, int i1) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.getBackground());
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    protected void func_191948_b(int x, int y) {
        super.func_191948_b(x, y);
        for (GuiButton guibutton : this.field_146292_n) {
            if (!guibutton.func_146115_a()) continue;
            guibutton.func_146111_b(x, y);
            break;
        }
    }

    public void func_73864_a(int i, int j, int k) throws IOException {
        super.func_73864_a(i, j, k);
        for (SonarTextField field : this.fieldList) {
            boolean focused = field.func_146192_a(i - this.field_147003_i, j - this.field_147009_r, k);
            if (!focused) continue;
            this.onTextFieldFocused(field);
        }
    }

    protected void func_73869_a(char c, int i) throws IOException {
        for (SonarTextField field : this.fieldList) {
            if (!field.func_146206_l()) continue;
            if (c == '\r' || c == '\u001b') {
                field.func_146195_b(false);
            } else {
                field.func_146201_a(c, i);
                this.onTextFieldChanged(field);
            }
            return;
        }
        if (this.isCloseKey(i) && this.origin != null) {
            FMLCommonHandler.instance().showGuiScreen(this.origin);
            return;
        }
        super.func_73869_a(c, i);
    }

    public void onTextFieldChanged(SonarTextField field) {
    }

    public void onTextFieldFocused(SonarTextField field) {
    }

    public void reset() {
        this.shouldReset = true;
    }

    public void doReset() {
        this.field_146292_n.clear();
        this.fieldList.clear();
        this.func_73866_w_();
        this.shouldReset = false;
    }

    public void initButtons() {
        this.field_146292_n.clear();
    }

    public SonarTextField getFocusedField() {
        for (SonarTextField f : this.fieldList) {
            if (!f.func_146206_l()) continue;
            return f;
        }
        return null;
    }

    public void bindTexture(ResourceLocation resource) {
        this.field_146297_k.func_110434_K().func_110577_a(resource);
    }

    @Override
    public void setOrigin(Object origin) {
        this.origin = origin;
    }

    public void setZLevel(float zLevel) {
        this.field_73735_i = zLevel;
    }

    public boolean isCloseKey(int keyCode) {
        return keyCode == 1 || this.field_146297_k.field_71474_y.field_151445_Q.isActiveAndMatches(keyCode);
    }

    public int getGuiLeft() {
        return this.field_147003_i;
    }

    public int getGuiTop() {
        return this.field_147009_r;
    }

    public void drawSonarCreativeTabHoveringText(String tabName, int mouseX, int mouseY) {
        this.func_146279_a(tabName, mouseX, mouseY);
    }

    public void drawSonarCreativeTabHoveringText(List<String> text, int mouseX, int mouseY) {
        this.func_146283_a(text, mouseX, mouseY);
    }

    public void startNormalItemStackRender() {
        GlStateManager.func_179126_j();
        net.minecraft.client.renderer.RenderHelper.func_74520_c();
        RenderHelper.saveBlendState();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)32.0f);
        this.field_73735_i = 200.0f;
        this.field_146296_j.field_77023_b = 200.0f;
    }

    public void drawNormalItemStack(ItemStack stack, int x, int y) {
        this.startNormalItemStackRender();
        FontRenderer font = stack.func_77973_b().getFontRenderer(stack);
        if (font == null) {
            font = this.field_146289_q;
        }
        this.field_146296_j.func_180450_b(stack, x, y);
        this.field_146296_j.func_180453_a(font, stack, x, y, "");
        this.finishNormalItemStackRender();
    }

    public void finishNormalItemStackRender() {
        this.field_73735_i = 0.0f;
        this.field_146296_j.field_77023_b = 0.0f;
        RenderHelper.restoreBlendState();
        net.minecraft.client.renderer.RenderHelper.func_74518_a();
        GlStateManager.func_179097_i();
    }

    public void drawNormalToolTip(ItemStack stack, int x, int y) {
        GL11.glDisable((int)2929);
        GL11.glDisable((int)2896);
        this.func_146285_a(stack, x - this.field_147003_i, y - this.field_147009_r);
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2929);
        net.minecraft.client.renderer.RenderHelper.func_74520_c();
    }

    public void drawSpecialToolTip(List<String> list, int x, int y, FontRenderer font) {
        GL11.glDisable((int)2929);
        GL11.glDisable((int)2896);
        this.drawHoveringText(list, x - this.field_147003_i, y - this.field_147009_r, font == null ? this.field_146289_q : font);
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2929);
        net.minecraft.client.renderer.RenderHelper.func_74520_c();
    }

    public static void drawTransparentRect(int left, int top, int right, int bottom, int color) {
        if (left < right) {
            int i = left;
            left = right;
            right = i;
        }
        if (top < bottom) {
            int j = top;
            top = bottom;
            bottom = j;
        }
        float f3 = (float)(color >> 24 & 0xFF) / 255.0f;
        float f = (float)(color >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(color >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(color & 0xFF) / 255.0f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexbuffer = tessellator.func_178180_c();
        RenderHelper.saveBlendState();
        GlStateManager.func_179147_l();
        GlStateManager.func_179131_c((float)f, (float)f1, (float)f2, (float)f3);
        GlStateManager.func_179090_x();
        GlStateManager.func_179120_a((int)770, (int)1, (int)1, (int)0);
        GlStateManager.func_179131_c((float)f, (float)f1, (float)f2, (float)f3);
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        vertexbuffer.func_181662_b((double)left, (double)bottom, 0.0).func_181675_d();
        vertexbuffer.func_181662_b((double)right, (double)bottom, 0.0).func_181675_d();
        vertexbuffer.func_181662_b((double)right, (double)top, 0.0).func_181675_d();
        vertexbuffer.func_181662_b((double)left, (double)top, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderHelper.restoreBlendState();
    }
}

