/*
 * Decompiled with CFR 0.152.
 */
package cf.terminator.laggoggles.profiler;

import cf.terminator.laggoggles.Main;
import cf.terminator.laggoggles.api.event.LagGogglesEvent;
import cf.terminator.laggoggles.client.FPSCounter;
import cf.terminator.laggoggles.packet.ObjectData;
import cf.terminator.laggoggles.profiler.ProfileResult;
import cf.terminator.laggoggles.profiler.ScanType;
import cf.terminator.laggoggles.profiler.TickCounter;
import cf.terminator.laggoggles.profiler.TimingManager;
import cf.terminator.laggoggles.util.Graphical;
import cf.terminator.laggoggles.util.RunInClientThread;
import cf.terminator.laggoggles.util.RunInServerThread;
import cf.terminator.laggoggles.util.Side;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class ProfileManager {
    public static TimingManager timingManager = new TimingManager();
    public static final AtomicBoolean PROFILE_ENABLED = new AtomicBoolean(false);
    public static final AtomicReference<ProfileResult> LAST_PROFILE_RESULT = new AtomicReference();
    private static final Object LOCK = new Object();
    private static final FPSCounter FPS_COUNTER = new FPSCounter();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProfileResult runProfiler(int seconds, final ScanType type) throws IllegalStateException {
        try {
            if (PROFILE_ENABLED.get()) {
                throw new IllegalStateException("Can't start profiler when it's already running!");
            }
            final long start = System.nanoTime();
            TickCounter.ticks.set(0L);
            timingManager = new TimingManager();
            if (Side.getSide().isClient()) {
                FPS_COUNTER.start();
            }
            PROFILE_ENABLED.set(true);
            Thread.sleep(seconds * 1000);
            PROFILE_ENABLED.set(false);
            final long frames = FPS_COUNTER.stop();
            Runnable task = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        ArrayList<Entity> ignoredEntities = new ArrayList<Entity>();
                        ArrayList<Entity> ignoredTileEntities = new ArrayList<Entity>();
                        ArrayList<UUID> ignoredBlocks = new ArrayList<UUID>();
                        Main.LOGGER.info("Processing results synchronously...");
                        ProfileResult result = new ProfileResult(start, System.nanoTime(), TickCounter.ticks.get(), Side.getSide(), type);
                        if (Side.getSide().isClient()) {
                            result.setFrames(frames);
                        }
                        for (Map.Entry<Integer, TimingManager.WorldData> entry : timingManager.getTimings().entrySet()) {
                            Entity e;
                            int worldID = entry.getKey();
                            WorldServer world = DimensionManager.getWorld((int)worldID);
                            if (world == null) continue;
                            for (Map.Entry<UUID, Long> entry2 : entry.getValue().getEntityTimes().entrySet()) {
                                e = world.func_175733_a(entry2.getKey());
                                if (e == null) continue;
                                try {
                                    result.addData(new ObjectData(worldID, e.func_70005_c_(), Graphical.formatClassName(e.getClass().toString()), e.getPersistentID(), (long)entry2.getValue(), ObjectData.Type.ENTITY));
                                }
                                catch (Throwable t) {
                                    ignoredEntities.add(e);
                                }
                            }
                            for (Map.Entry<UUID, Long> entry3 : entry.getValue().getBlockTimes().entrySet()) {
                                e = world.func_175625_s((BlockPos)entry3.getKey());
                                if (e != null) {
                                    try {
                                        ITextComponent displayName = e.func_145748_c_();
                                        String name = displayName != null ? displayName.func_150254_d() : e.getClass().getSimpleName();
                                        result.addData(new ObjectData(worldID, name, Graphical.formatClassName(e.getClass().toString()), e.func_174877_v(), (long)entry3.getValue(), ObjectData.Type.TILE_ENTITY));
                                    }
                                    catch (Throwable t) {
                                        ignoredTileEntities.add(e);
                                    }
                                    continue;
                                }
                                try {
                                    IBlockState state = world.func_180495_p((BlockPos)entry3.getKey());
                                    String name = state.func_177230_c().func_149739_a();
                                    result.addData(new ObjectData(worldID, name, Graphical.formatClassName(state.func_177230_c().getClass().toString()), (BlockPos)entry3.getKey(), (long)entry3.getValue(), ObjectData.Type.BLOCK));
                                }
                                catch (Throwable t) {
                                    ignoredBlocks.add(entry3.getKey());
                                }
                            }
                        }
                        for (Map.Entry<Object, Object> entry : timingManager.getEventTimings().entrySet()) {
                            result.addData(new ObjectData((TimingManager.EventTimings)entry.getKey(), ((AtomicLong)entry.getValue()).get()));
                        }
                        if (result.getSide().isClient()) {
                            ProfileManager.insertGuiData(result, timingManager);
                        }
                        result.lock();
                        LAST_PROFILE_RESULT.set(result);
                        Object object = LOCK;
                        synchronized (object) {
                            LOCK.notifyAll();
                        }
                        if (ignoredBlocks.size() + ignoredEntities.size() + ignoredTileEntities.size() > 0) {
                            Main.LOGGER.info("Ignored some tracked elements:");
                            Main.LOGGER.info("Entities: " + ignoredEntities);
                            Main.LOGGER.info("Tile entities: " + ignoredTileEntities);
                            Main.LOGGER.info("Blocks in locations: " + ignoredBlocks);
                        }
                    }
                    catch (Throwable e) {
                        Main.LOGGER.error("Woa! Something went wrong while processing results! Please contact Terminator_NL and submit the following error in an issue at github!");
                        e.printStackTrace();
                    }
                }
            };
            Side side = Side.getSide();
            if (side.isServer()) {
                new RunInServerThread(task);
            } else if (side.isClient()) {
                new RunInClientThread(task);
            } else {
                Main.LOGGER.error("LagGoggles did something amazing. I have no clue how this works, but here's a stacktrace, please submit an issue at github with the stacktrace below!");
                Thread.dumpStack();
            }
            Object object = LOCK;
            synchronized (object) {
                LOCK.wait();
            }
            MinecraftForge.EVENT_BUS.post((Event)new LagGogglesEvent.LocalResult(LAST_PROFILE_RESULT.get()));
            return LAST_PROFILE_RESULT.get();
        }
        catch (Throwable e) {
            Main.LOGGER.error("Woa! Something went wrong while processing results! Please contact Terminator_NL and submit the following error in an issue at github!");
            e.printStackTrace();
            return null;
        }
    }

    public static void insertGuiData(ProfileResult result, TimingManager timings) {
        TreeMap<UUID, Long> entityTimes = timings.getGuiEntityTimings();
        for (Entity e : Minecraft.func_71410_x().field_71441_e.field_72996_f) {
            Long time = entityTimes.get(e.func_110124_au());
            if (time == null) continue;
            result.addData(new ObjectData(e.field_70170_p.field_73011_w.getDimension(), e.func_70005_c_(), Graphical.formatClassName(e.getClass().toString()), e.getPersistentID(), (long)time, ObjectData.Type.GUI_ENTITY));
        }
        TreeMap<BlockPos, Long> blockTimes = timings.getGuiBlockTimings();
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        for (Map.Entry<BlockPos, Long> e : blockTimes.entrySet()) {
            Long time = e.getValue();
            TileEntity entity = world.func_175625_s(e.getKey());
            if (entity != null) {
                ITextComponent displayName = entity.func_145748_c_();
                String name = displayName != null ? displayName.func_150254_d() : entity.getClass().getSimpleName();
                result.addData(new ObjectData(entity.func_145831_w().field_73011_w.getDimension(), name, Graphical.formatClassName(entity.getClass().toString()), entity.func_174877_v(), (long)time, ObjectData.Type.GUI_BLOCK));
                continue;
            }
            IBlockState state = world.func_180495_p(e.getKey());
            String name = state.func_177230_c().func_149732_F();
            result.addData(new ObjectData(world.field_73011_w.getDimension(), name, Graphical.formatClassName(state.func_177230_c().getClass().toString()), e.getKey(), (long)time, ObjectData.Type.GUI_BLOCK));
        }
    }
}

