/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.iconprovider;

import net.malisis.core.registry.MalisisRegistry;
import net.malisis.core.renderer.icon.Icon;
import net.malisis.core.renderer.icon.provider.IIconProvider;
import net.malisis.core.util.callback.CallbackResult;
import net.malisis.core.util.callback.ICallback;
import net.malisis.doors.DoorDescriptor;
import net.malisis.doors.descriptor.VanillaDoor;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.EnumFacing;

public class DoorIconProvider
implements IIconProvider {
    protected boolean iconBuilt = false;
    protected Icon itemIcon;
    protected Icon top;
    protected Icon bottom;
    protected Icon side;
    protected Icon[] iconTop;
    protected Icon[] iconBottom;

    public DoorIconProvider(DoorDescriptor descriptor) {
        String modid = descriptor.getModId();
        String name = descriptor.getTextureName();
        this.itemIcon = Icon.from((String)(modid + ":items/" + name));
        this.top = Icon.from((String)(modid + ":blocks/" + name + "_upper"));
        this.bottom = Icon.from((String)(modid + ":blocks/" + name + "_lower"));
        if (descriptor instanceof VanillaDoor) {
            modid = "malisisdoors";
        }
        this.side = Icon.from((String)(modid + ":blocks/" + name + "_side"));
        MalisisRegistry.onTextureStitched(this::textureStitched, (ICallback.CallbackOption)ICallback.CallbackOption.of());
    }

    private void buildIcons() {
        float w = 0.1875f;
        this.iconTop = new Icon[6];
        this.iconTop[0] = new Icon((TextureAtlasSprite)this.side).clip(0.0f, 0.0f, w, 1.0f);
        this.iconTop[0].setRotation(1);
        this.iconTop[1] = this.iconTop[0];
        this.iconTop[2] = this.top;
        this.iconTop[3] = this.top;
        this.iconTop[4] = new Icon((TextureAtlasSprite)this.side).clip(w, 0.0f, w, 1.0f);
        this.iconTop[5] = new Icon((TextureAtlasSprite)this.side).clip(2.0f * w, 0.0f, w, 1.0f);
        this.iconBottom = new Icon[6];
        this.iconBottom[0] = this.iconTop[0];
        this.iconBottom[1] = this.iconTop[0];
        this.iconBottom[2] = this.bottom;
        this.iconBottom[3] = this.bottom;
        this.iconBottom[4] = new Icon((TextureAtlasSprite)this.side).clip(3.0f * w, 0.0f, w, 1.0f);
        this.iconBottom[5] = new Icon((TextureAtlasSprite)this.side).clip(4.0f * w, 0.0f, w, 1.0f);
        this.iconBuilt = true;
    }

    public Icon getIcon() {
        return this.top;
    }

    public Icon getIcon(boolean isTop, boolean isHingeLeft, EnumFacing side) {
        if (!this.iconBuilt) {
            this.buildIcons();
        }
        boolean flipH = false;
        boolean flipV = false;
        switch (side) {
            case WEST: {
                side = isHingeLeft ? EnumFacing.WEST : EnumFacing.EAST;
                break;
            }
            case EAST: {
                side = isHingeLeft ? EnumFacing.EAST : EnumFacing.WEST;
                break;
            }
            case UP: 
            case DOWN: {
                flipV = isHingeLeft;
                break;
            }
            case NORTH: 
            case SOUTH: {
                flipH = isHingeLeft;
            }
        }
        Icon icon = isTop ? this.iconTop[side.func_176745_a()] : this.iconBottom[side.func_176745_a()];
        icon.flip(flipH, flipV);
        return icon;
    }

    private CallbackResult<Void> textureStitched(TextureMap map) {
        this.iconBuilt = false;
        return CallbackResult.noResult();
    }
}

