/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.tool;

import blusunrize.immersiveengineering.api.energy.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.wires.IWireCoil;
import blusunrize.immersiveengineering.api.tool.ITool;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.world.World;

public class ToolboxHandler {
    private static final List<Predicate<ItemStack>> tools = new ArrayList<Predicate<ItemStack>>();
    private static final List<Predicate<ItemStack>> foods = new ArrayList<Predicate<ItemStack>>();
    private static final List<BiPredicate<ItemStack, World>> wiring = new ArrayList<BiPredicate<ItemStack, World>>();

    public static boolean isTool(ItemStack s) {
        for (Predicate<ItemStack> p : tools) {
            if (!p.test(s)) continue;
            return true;
        }
        return false;
    }

    public static void addToolType(Predicate<ItemStack> in) {
        tools.add(in);
    }

    public static boolean isFood(ItemStack s) {
        for (Predicate<ItemStack> p : foods) {
            if (!p.test(s)) continue;
            return true;
        }
        return false;
    }

    public static void addFoodType(Predicate<ItemStack> in) {
        foods.add(in);
    }

    public static boolean isWiring(ItemStack s, World w) {
        for (BiPredicate<ItemStack, World> p : wiring) {
            if (!p.test(s, w)) continue;
            return true;
        }
        return false;
    }

    public static void addWiringType(BiPredicate<ItemStack, World> in) {
        wiring.add(in);
    }

    static {
        tools.add(s -> s.func_77973_b() instanceof ITool && ((ITool)s.func_77973_b()).isTool((ItemStack)s));
        tools.add(s -> s.func_77973_b() instanceof ItemTool);
        foods.add(s -> s.func_77973_b() instanceof ItemFood);
        wiring.add((s, w) -> s.func_77973_b() instanceof IWireCoil);
        wiring.add((s, w) -> {
            Block b = Block.func_149634_a((Item)s.func_77973_b());
            int meta = s.func_77952_i();
            IBlockState defaultState = b == null ? null : b.func_176203_a(meta);
            return b != null && b.hasTileEntity(defaultState) && b.createTileEntity(w, defaultState) instanceof IImmersiveConnectable;
        });
    }
}

