/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.models.smart;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.energy.wires.ImmersiveNetHandler;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.models.IOBJModelCallback;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class ConnModelReal
implements IBakedModel {
    TextureAtlasSprite textureAtlasSprite = Minecraft.func_71410_x().func_147117_R().func_110572_b("immersiveengineering".toLowerCase(Locale.ENGLISH) + ":blocks/wire");
    public static final Cache<Pair<Byte, ExtBlockstateAdapter>, IBakedModel> cache = CacheBuilder.newBuilder().expireAfterAccess(2L, TimeUnit.MINUTES).maximumSize(100L).build();
    private final IBakedModel base;
    private final ImmutableSet<BlockRenderLayer> layers;

    public ConnModelReal(IBakedModel basic, ImmutableSet<BlockRenderLayer> layers) {
        this.base = basic;
        this.layers = layers;
    }

    @Nonnull
    public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
        if (side == null && state instanceof IExtendedBlockState) {
            Set conns;
            TileEntity te;
            IExtendedBlockState ext = (IExtendedBlockState)state;
            Object[] additional = null;
            if (ext.getUnlistedProperties().containsKey(IEProperties.TILEENTITY_PASSTHROUGH) && (te = (TileEntity)ext.getValue(IEProperties.TILEENTITY_PASSTHROUGH)) instanceof IEBlockInterfaces.ICacheData) {
                additional = ((IEBlockInterfaces.ICacheData)te).getCacheData();
            }
            int x = 0;
            int z = 0;
            if (ext.getUnlistedProperties().containsKey((Object)IEProperties.CONNECTIONS) && (conns = (Set)ext.getValue((IUnlistedProperty)IEProperties.CONNECTIONS)) != null && conns.size() > 0) {
                BlockPos tmp = ((ImmersiveNetHandler.Connection)conns.iterator().next()).start;
                x = (tmp.func_177958_n() % 16 + 16) % 16;
                z = (tmp.func_177952_p() % 16 + 16) % 16;
            }
            ExtBlockstateAdapter ad = new ExtBlockstateAdapter(ext, null, ExtBlockstateAdapter.ONLY_OBJ_CALLBACK, additional);
            ImmutablePair key = new ImmutablePair((Object)((byte)(x << 4 | z)), (Object)ad);
            try {
                IBakedModel ret = (IBakedModel)cache.get((Object)key, () -> new AssembledBakedModel(ext, this.textureAtlasSprite, this.base, this.layers));
                return ret.func_188616_a(state, null, rand);
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
        }
        return this.getBaseQuads(MinecraftForgeClient.getRenderLayer(), state, side, rand);
    }

    public boolean func_177555_b() {
        return false;
    }

    public boolean func_177556_c() {
        return false;
    }

    public boolean func_188618_c() {
        return false;
    }

    @Nonnull
    public TextureAtlasSprite func_177554_e() {
        return this.base.func_177554_e();
    }

    @Nonnull
    public ItemOverrideList func_188617_f() {
        return ItemOverrideList.field_188022_a;
    }

    private List<BakedQuad> getBaseQuads(BlockRenderLayer currentLayer, IBlockState state, EnumFacing side, long rand) {
        if (this.layers.contains((Object)currentLayer) || currentLayer == null) {
            return this.base.func_188616_a(state, side, rand);
        }
        return ImmutableList.of();
    }

    public static class ExtBlockstateAdapter {
        public static final Set<Object> ONLY_OBJ_CALLBACK = ImmutableSet.of(IOBJModelCallback.PROPERTY, IEProperties.TILEENTITY_PASSTHROUGH);
        public static final Set<Object> CONNS_OBJ_CALLBACK = ImmutableSet.of(IOBJModelCallback.PROPERTY, IEProperties.TILEENTITY_PASSTHROUGH, (Object)IEProperties.CONNECTIONS);
        final IExtendedBlockState state;
        final BlockRenderLayer layer;
        final String extraCacheKey;
        final Set<Object> ignoredProperties;
        Object[] additionalProperties = null;

        public ExtBlockstateAdapter(IExtendedBlockState s, BlockRenderLayer l, Set<Object> ignored) {
            IOBJModelCallback callback;
            this.state = s;
            this.layer = l;
            this.ignoredProperties = ignored;
            this.extraCacheKey = s.getUnlistedNames().contains(IOBJModelCallback.PROPERTY) ? ((callback = (IOBJModelCallback)s.getValue(IOBJModelCallback.PROPERTY)) != null ? callback.getClass() + ";" + callback.getCacheKey(this.state) : null) : null;
            if (Config.IEConfig.enableDebug && (!this.equals(this) || this.hashCode() != this.hashCode())) {
                String debug = "Basic state:\n";
                debug = debug + this.toStringDebug(this.state);
                debug = debug + "Layer: " + this.layer + "\n";
                debug = debug + "Cache key: " + this.extraCacheKey + "\nAdditional:\n";
                debug = debug + "Ignored:\n";
                for (Object o : this.ignoredProperties) {
                    debug = debug + this.toStringDebug(o);
                }
                throw new IllegalStateException(debug);
            }
        }

        private String toStringProp(IProperty<?> o) {
            if (o == null) {
                return "PROPERTY WAS NULL";
            }
            return o.getClass() + ": listed, Type: " + o.func_177699_b() + ", Name: " + o.func_177701_a();
        }

        private String toStringProp(IUnlistedProperty<?> o) {
            if (o == null) {
                return "PROPERTY WAS NULL";
            }
            return o.getClass() + ": unlisted, Type: " + o.getType() + ", Name: " + o.getName();
        }

        private String toStringDebug(Object o) {
            if (o == null) {
                return "NULL";
            }
            if (o instanceof IBlockState) {
                String ret = "";
                for (Object p : ((IBlockState)o).func_177227_a()) {
                    ret = ret + this.toStringProp((IProperty<?>)p) + " has value " + this.toStringDebug(((IBlockState)o).func_177229_b((IProperty)p)) + "\n";
                }
                if (o instanceof IExtendedBlockState) {
                    for (Object p : ((IExtendedBlockState)o).getUnlistedProperties().entrySet()) {
                        ret = ret + this.toStringProp((IUnlistedProperty)p.getKey()) + " has value " + this.toStringDebug(((Optional)p.getValue()).orElse(null)) + "\n";
                    }
                }
                return ret;
            }
            if (o instanceof IUnlistedProperty) {
                return this.toStringProp((IUnlistedProperty)o);
            }
            if (o instanceof IProperty) {
                return this.toStringProp((IProperty)o);
            }
            return o.getClass() + ": " + o;
        }

        public ExtBlockstateAdapter(IExtendedBlockState s, BlockRenderLayer l, Set<Object> ignored, Object[] additional) {
            this(s, l, ignored);
            this.additionalProperties = additional;
            if (Config.IEConfig.enableDebug && (!this.equals(this) || this.hashCode() != this.hashCode())) {
                String debug = "Basic state:\n";
                debug = debug + this.toStringDebug(this.state);
                debug = debug + "Layer: " + this.layer + "\n";
                debug = debug + "Cache key: " + this.extraCacheKey + "\nAdditional:\n";
                if (this.additionalProperties != null) {
                    for (Object o : this.additionalProperties) {
                        debug = debug + this.toStringDebug(o);
                    }
                }
                debug = debug + "Ignored:\n";
                for (Object e : this.ignoredProperties) {
                    debug = debug + this.toStringDebug(e);
                }
                throw new IllegalStateException(debug);
            }
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof ExtBlockstateAdapter)) {
                return false;
            }
            ExtBlockstateAdapter o = (ExtBlockstateAdapter)obj;
            if (o.layer != this.layer) {
                return false;
            }
            if (this.extraCacheKey == null ^ o.extraCacheKey == null) {
                return false;
            }
            if (this.extraCacheKey != null && !this.extraCacheKey.equals(o.extraCacheKey)) {
                return false;
            }
            if (!Utils.areArraysEqualIncludingBlockstates(this.additionalProperties, o.additionalProperties)) {
                return false;
            }
            return Utils.areStatesEqual((IBlockState)this.state, (IBlockState)o.state, this.ignoredProperties, true);
        }

        public int hashCode() {
            int val = this.layer == null ? 0 : this.layer.ordinal();
            int prime = 31;
            if (this.extraCacheKey != null) {
                val = val * 31 + this.extraCacheKey.hashCode();
            }
            val = 31 * val + Utils.hashBlockstate((IBlockState)this.state, this.ignoredProperties, true);
            val = 31 * val + Arrays.hashCode(this.additionalProperties);
            return val;
        }
    }

    public class AssembledBakedModel
    implements IBakedModel {
        IBakedModel basic;
        IExtendedBlockState extendedState;
        List<BakedQuad>[] lists;
        TextureAtlasSprite texture;
        private final ImmutableSet<BlockRenderLayer> layers;

        public AssembledBakedModel(IExtendedBlockState iExtendedBlockState, TextureAtlasSprite tex, IBakedModel b, ImmutableSet<BlockRenderLayer> layers) {
            this.basic = b;
            this.extendedState = iExtendedBlockState;
            this.texture = tex;
            this.layers = layers;
        }

        @Nonnull
        public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
            BlockRenderLayer layer = MinecraftForgeClient.getRenderLayer();
            if (layer != BlockRenderLayer.SOLID && layer != BlockRenderLayer.TRANSLUCENT) {
                return ConnModelReal.this.getBaseQuads(layer, state, side, rand);
            }
            if (this.lists == null) {
                this.lists = ClientUtils.convertConnectionFromBlockstate(this.extendedState, this.texture);
            }
            ArrayList<BakedQuad> l = new ArrayList<BakedQuad>(this.lists[layer == BlockRenderLayer.SOLID ? 0 : 1]);
            l.addAll(ConnModelReal.this.getBaseQuads(layer, state, side, rand));
            return Collections.synchronizedList(l);
        }

        public boolean func_177555_b() {
            return false;
        }

        public boolean func_177556_c() {
            return false;
        }

        public boolean func_188618_c() {
            return false;
        }

        @Nonnull
        public TextureAtlasSprite func_177554_e() {
            return ConnModelReal.this.base.func_177554_e();
        }

        @Nonnull
        public ItemOverrideList func_188617_f() {
            return ItemOverrideList.field_188022_a;
        }
    }
}

