/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.compat.jei.arcfurnace;

import blusunrize.immersiveengineering.api.crafting.ArcFurnaceRecipe;
import blusunrize.immersiveengineering.common.util.IELogger;
import blusunrize.immersiveengineering.common.util.compat.jei.MultiblockRecipeWrapper;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class ArcFurnaceRecipeWrapper
extends MultiblockRecipeWrapper {
    public String specialRecipeType;
    int time;
    int energy;
    private static HashMap<String, Class<? extends ArcFurnaceRecipeWrapper>> dynamicSubclasses = new HashMap();

    public ArcFurnaceRecipeWrapper(ArcFurnaceRecipe recipe) {
        super(recipe);
        String name = this.getClass().getName();
        int idx = name.indexOf("ArcFurnaceRecipeWrapper");
        if (idx >= 0 && idx + "ArcFurnaceRecipeWrapper".length() < name.length()) {
            this.specialRecipeType = name.substring(idx + "ArcFurnaceRecipeWrapper".length());
        }
        this.time = recipe.getTotalProcessTime();
        this.energy = recipe.getTotalProcessEnergy() / this.time;
    }

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        String s = this.energy + " IF/t";
        minecraft.field_71466_p.func_78276_b(s, 54, 38, 0x777777);
        s = this.time + " ticks";
        minecraft.field_71466_p.func_78276_b(s, 54, 48, 0x777777);
    }

    public static ArcFurnaceRecipeWrapper getWrapper(ArcFurnaceRecipe recipe) {
        if (recipe.specialRecipeType == null) {
            return new ArcFurnaceRecipeWrapper(recipe);
        }
        try {
            return ArcFurnaceRecipeWrapper.getWrapperClass(recipe.specialRecipeType).getConstructor(ArcFurnaceRecipe.class).newInstance(recipe);
        }
        catch (Exception e) {
            IELogger.error("Adding an ArcFurnaceRecipe: " + recipe.specialRecipeType + ", threw an error! Report this!");
            e.printStackTrace();
            return new ArcFurnaceRecipeWrapper(recipe);
        }
    }

    public static Class<? extends ArcFurnaceRecipeWrapper> getWrapperClass(String subtype) {
        if (subtype == null) {
            return ArcFurnaceRecipeWrapper.class;
        }
        if (dynamicSubclasses.containsKey(subtype)) {
            return dynamicSubclasses.get(subtype);
        }
        try {
            Class<? extends ArcFurnaceRecipeWrapper> subWrapper = ArcFurnaceRecipeWrapper.createSubWrapper(subtype);
            if (subWrapper != null) {
                dynamicSubclasses.put(subtype, subWrapper);
                return subWrapper;
            }
        }
        catch (Exception e) {
            IELogger.error("The dynamic JEI recipe handler for the ArcFurnace - " + subtype + ", threw an error! Report this!");
            e.printStackTrace();
        }
        return ArcFurnaceRecipeWrapper.class;
    }

    private static Class<? extends ArcFurnaceRecipeWrapper> createSubWrapper(String subtype) throws Exception {
        String entitySuperClassName = Type.getInternalName(ArcFurnaceRecipeWrapper.class);
        String entityProxySubClassName = ArcFurnaceRecipeWrapper.class.getSimpleName().concat(subtype);
        ClassWriter cw = new ClassWriter(1);
        cw.visit(50, 33, entityProxySubClassName, null, entitySuperClassName, null);
        cw.visitSource(entityProxySubClassName.concat(".java"), null);
        String methodDescriptor = "(L" + Type.getInternalName(ArcFurnaceRecipe.class) + ";)V";
        MethodVisitor mv = cw.visitMethod(1, "<init>", methodDescriptor, null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(183, entitySuperClassName, "<init>", methodDescriptor, false);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        cw.visitEnd();
        return new ProxyClassLoader(Thread.currentThread().getContextClassLoader(), cw.toByteArray()).loadClass(entityProxySubClassName.replaceAll("/", "."));
    }

    public static class ProxyClassLoader
    extends ClassLoader {
        private byte[] rawClassBytes;

        public ProxyClassLoader(ClassLoader parentClassLoader, byte[] classBytes) {
            super(parentClassLoader);
            this.rawClassBytes = classBytes;
        }

        public Class findClass(String name) {
            return this.defineClass(name, this.rawClassBytes, 0, this.rawClassBytes.length);
        }
    }
}

