/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.entity;

import icbm.classic.api.caps.IEMPReceiver;
import icbm.classic.api.explosion.IExplosive;
import icbm.classic.api.explosion.IExplosiveContainer;
import icbm.classic.api.tile.IRotatable;
import icbm.classic.content.explosive.Explosives;
import icbm.classic.lib.emp.CapabilityEMP;
import icbm.classic.lib.emp.CapabilityEmpKill;
import icbm.classic.lib.transform.vector.Pos;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;

public class EntityExplosive
extends Entity
implements IRotatable,
IEntityAdditionalSpawnData,
IExplosiveContainer {
    public int fuse = 0;
    public Explosives explosiveID;
    private byte orientation = (byte)3;
    public NBTTagCompound nbtData = new NBTTagCompound();
    public IEMPReceiver capabilityEMP;

    public EntityExplosive(World par1World) {
        super(par1World);
        this.field_70156_m = true;
        this.func_70105_a(0.98f, 0.98f);
        this.capabilityEMP = new CapabilityEmpKill<EntityExplosive>(this);
    }

    public EntityExplosive(World par1World, Pos position, byte orientation, Explosives explosiveID) {
        this(par1World);
        this.func_70107_b(position.x(), position.y(), position.z());
        float var8 = (float)(Math.random() * Math.PI * 2.0);
        this.field_70159_w = -((float)Math.sin(var8)) * 0.02f;
        this.field_70181_x = 0.2f;
        this.field_70179_y = -((float)Math.cos(var8)) * 0.02f;
        this.field_70169_q = position.x();
        this.field_70167_r = position.y();
        this.field_70166_s = position.z();
        this.explosiveID = explosiveID;
        this.fuse = explosiveID.handler.getFuseTimer();
        this.orientation = orientation;
        explosiveID.handler.onEntityCreated(par1World, this);
    }

    public EntityExplosive(World par1World, Pos position, Explosives explosiveID, byte orientation, NBTTagCompound nbtData) {
        this(par1World, position, orientation, explosiveID);
        this.nbtData = nbtData;
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityEMP.EMP) {
            return (T)this.capabilityEMP;
        }
        return (T)super.getCapability(capability, facing);
    }

    public String func_70005_c_() {
        return "Explosives";
    }

    public void func_70071_h_() {
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        this.field_70159_w *= 0.95;
        this.field_70181_x -= 0.045;
        this.field_70179_y *= 0.95;
        this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        if (this.fuse < 1) {
            this.explode();
        } else {
            this.explosiveID.handler.onFuseTick(this.field_70170_p, new Pos(this.field_70165_t, this.field_70163_u, this.field_70161_v), this.fuse);
        }
        --this.fuse;
        super.func_70071_h_();
    }

    public void explode() {
        this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_HUGE, this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0, 0.0, 0.0, new int[0]);
        this.getExplosiveType().createExplosion(this.field_70170_p, new BlockPos(this.field_70165_t, this.field_70163_u, this.field_70161_v), this, 1.0f);
        this.func_70106_y();
    }

    protected void func_70037_a(NBTTagCompound nbt) {
        this.fuse = nbt.func_74771_c("Fuse");
        this.explosiveID = Explosives.get(nbt.func_74762_e("explosiveID"));
        this.nbtData = nbt.func_74775_l("data");
    }

    protected void func_70014_b(NBTTagCompound nbt) {
        nbt.func_74774_a("Fuse", (byte)this.fuse);
        nbt.func_74768_a("explosiveID", this.explosiveID.ordinal());
        nbt.func_74782_a("data", (NBTBase)this.nbtData);
    }

    protected void func_70088_a() {
    }

    protected boolean func_70041_e_() {
        return true;
    }

    public boolean func_70067_L() {
        return true;
    }

    public boolean func_70104_M() {
        return true;
    }

    @Override
    public EnumFacing getDirection() {
        return EnumFacing.func_82600_a((int)this.orientation);
    }

    @Override
    public void setDirection(EnumFacing facingDirection) {
        this.orientation = (byte)facingDirection.ordinal();
    }

    public void writeSpawnData(ByteBuf data) {
        data.writeInt(this.explosiveID.ordinal());
        data.writeInt(this.fuse);
        data.writeByte((int)this.orientation);
    }

    public void readSpawnData(ByteBuf data) {
        this.explosiveID = Explosives.get(data.readInt());
        this.fuse = data.readInt();
        this.orientation = data.readByte();
    }

    @Override
    public IExplosive getExplosiveType() {
        return this.explosiveID.handler;
    }

    @Override
    public NBTTagCompound getExplosiveData() {
        return this.nbtData;
    }
}

