/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs4.mixin;

import com.google.common.base.Preconditions;
import cubex2.cs4.util.AsmHelper;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class Mixin
implements Opcodes {
    public static Class<?> create(String name, Class<?> baseClass, Class<?> ... mixins) {
        return Mixin.create(name, (ClassNode n) -> {}, baseClass, mixins);
    }

    public static Class<?> create(String name, Consumer<ClassNode> modifier, Class<?> baseClass, Class<?> ... mixins) {
        Preconditions.checkArgument((boolean)Arrays.stream(mixins).noneMatch(Class::isInterface), (Object)"Interfaces can't be mixed in.");
        ClassNode baseNode = AsmHelper.createClassNode(baseClass);
        List<ClassNode> mixinNodes = Arrays.stream(mixins).map(AsmHelper::createClassNode).collect(Collectors.toList());
        baseNode.access &= 0xFFFFFBFF;
        String oldName = baseNode.name;
        baseNode.name = name;
        Mixin.removeStaticFieldsAndMethods(baseNode);
        baseNode.methods.forEach(m -> Mixin.fixMethodInstructions(oldName, name, baseNode.superName, m));
        mixinNodes.forEach(mixin -> Mixin.mixin(baseNode, mixin));
        modifier.accept(baseNode);
        return AsmHelper.createClass(baseNode);
    }

    private static void removeStaticFieldsAndMethods(ClassNode node) {
        node.methods.removeIf(m -> (m.access & 8) != 0);
        node.fields.removeIf(f -> (f.access & 8) != 0);
    }

    static void mixin(ClassNode baseNode, ClassNode mixin) {
        Mixin.mixinFields(baseNode, mixin);
        Mixin.mixinMethods(baseNode, mixin);
    }

    static void mixinFields(ClassNode base, ClassNode mixin) {
        for (FieldNode field : mixin.fields) {
            if (!Mixin.canMixinField(base, field)) continue;
            Mixin.mixinField(base, field);
        }
    }

    private static void mixinField(ClassNode base, FieldNode field) {
        base.fields.add(new FieldNode(field.access, field.name, field.desc, field.signature, field.value));
    }

    private static boolean canMixinField(ClassNode node, FieldNode field) {
        if (Mixin.hasField(node, field.name)) {
            return false;
        }
        return (field.access & 8) == 0;
    }

    static boolean hasField(ClassNode node, String name) {
        return node.fields.stream().anyMatch(f -> f.name.equals(name));
    }

    static void mixinMethods(ClassNode base, ClassNode mixin) {
        for (MethodNode method : mixin.methods) {
            if (!Mixin.canMixinMethod(base, method)) continue;
            Mixin.mixinMethod(base, mixin, method);
        }
    }

    private static void mixinMethod(ClassNode base, ClassNode mixin, MethodNode method) {
        MethodNode m = new MethodNode(method.access, method.name, method.desc, method.signature, (String[])method.exceptions.stream().toArray(String[]::new));
        m.instructions.add(method.instructions);
        Mixin.fixMethodInstructions(mixin.name, base.name, base.superName, m);
        base.methods.add(m);
    }

    private static void fixMethodInstructions(String oldName, String newName, String newSuperName, MethodNode method) {
        for (AbstractInsnNode next : method.instructions) {
            MethodInsnNode methodNode;
            if (next instanceof FieldInsnNode) {
                FieldInsnNode field = (FieldInsnNode)next;
                if (field.getOpcode() != 180 && field.getOpcode() != 181 || !field.owner.equals(oldName)) continue;
                field.owner = newName;
                continue;
            }
            if (!(next instanceof MethodInsnNode) || (methodNode = (MethodInsnNode)next).getOpcode() != 182 && methodNode.getOpcode() != 183) continue;
            if (methodNode.owner.equals(oldName)) {
                methodNode.owner = newName;
                continue;
            }
            if (methodNode.getOpcode() != 183 || methodNode.name.equals("<init>")) continue;
            methodNode.owner = newSuperName;
        }
    }

    private static boolean canMixinMethod(ClassNode node, MethodNode method) {
        if (Mixin.hasMethod(node, method.name)) {
            return false;
        }
        if ((method.access & 0x400) != 0) {
            return false;
        }
        if ((method.access & 8) != 0) {
            return false;
        }
        if (method.name.equals("<init>")) {
            return false;
        }
        return !method.name.equals("<clinit>");
    }

    static boolean hasMethod(ClassNode node, String name) {
        return node.methods.stream().anyMatch(m -> m.name.equals(name));
    }
}

