/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs4.plugins.vanilla;

import cubex2.cs4.CustomStuff4;
import cubex2.cs4.api.ContentHelper;
import cubex2.cs4.plugins.vanilla.ContentBlockBase;
import cubex2.cs4.util.BlockHelper;
import java.util.Collection;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;

public abstract class ContentBlockBaseWithSubtypes
extends ContentBlockBase {
    private static ContentBlockBaseWithSubtypes activeContent;
    public int[] subtypes = new int[0];
    private transient boolean hasSubtypes;

    @Override
    public final Block createBlock() {
        Block block;
        boolean bl = this.hasSubtypes = this.subtypes.length > 0;
        if (this.subtypes.length == 0) {
            this.subtypes = new int[]{0};
        }
        if (this.hasSubtypes) {
            activeContent = this;
            block = this.createBlockWithSubtypes();
            activeContent = null;
        } else {
            block = this.createBlockWithoutSubtypes();
        }
        return block;
    }

    protected abstract Block createBlockWithSubtypes();

    protected abstract Block createBlockWithoutSubtypes();

    @Override
    protected final Optional<Item> createItem() {
        return this.createItem(this.hasSubtypes);
    }

    @Override
    protected void initItem(Item item, ContentHelper helper) {
        super.initItem(item, helper);
        item.func_77627_a(this.hasSubtypes);
    }

    @Override
    protected void registerModels() {
        if (this.item != null) {
            for (int meta : this.subtypes) {
                ResourceLocation model = this.itemModel.get(meta).orElse(this.item.getRegistryName());
                CustomStuff4.proxy.registerItemModel(this.item, meta, model);
            }
        }
    }

    protected abstract Optional<Item> createItem(boolean var1);

    public static IProperty[] insertSubtype(Collection<IProperty<?>> properties) {
        if (activeContent != null) {
            IProperty[] newProperties = new IProperty[properties.size() + 1];
            newProperties[0] = BlockHelper.getSubtypeProperty(ContentBlockBaseWithSubtypes.activeContent.subtypes);
            int i = 1;
            for (IProperty<?> property : properties) {
                newProperties[i++] = property;
            }
            return newProperties;
        }
        return properties.toArray(new IProperty[0]);
    }
}

