/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs4.plugins.vanilla.gui;

import com.google.gson.JsonDeserializer;
import com.google.gson.JsonParseException;
import cubex2.cs4.plugins.vanilla.gui.ProgressBarSource;
import java.util.Arrays;
import net.minecraftforge.fml.client.config.GuiUtils;

public class ProgressBar {
    public int x;
    public int y;
    public int texX;
    public int texY;
    public int width;
    public int height;
    public String source;
    public Direction direction = Direction.RIGHT;

    public void draw(ProgressBarSource progressSource) {
        float progress = progressSource.getProgress(this.source);
        int w = this.direction.getWidth(this.width, progress);
        int h = this.direction.getHeight(this.height, progress);
        int offsetX = this.direction.getOffsetX(this.width, w);
        int offsetY = this.direction.getOffsetY(this.height, h);
        GuiUtils.drawTexturedModalRect((int)(this.x + offsetX), (int)(this.y + offsetY), (int)(this.texX + offsetX), (int)(this.texY + offsetY), (int)w, (int)h, (float)0.0f);
    }

    public static enum Direction {
        UP("up"),
        DOWN("down"),
        LEFT("left"),
        RIGHT("right");

        public final String name;
        public static final JsonDeserializer<Direction> DESERIALIZER;

        private Direction(String name) {
            this.name = name;
        }

        int getWidth(int maxWidth, float progress) {
            if (this == UP || this == DOWN) {
                return maxWidth;
            }
            return Math.round((float)maxWidth * progress);
        }

        int getOffsetX(int maxWidth, int width) {
            if (this != LEFT) {
                return 0;
            }
            return maxWidth - width;
        }

        int getHeight(int maxHeight, float progress) {
            if (this == LEFT || this == RIGHT) {
                return maxHeight;
            }
            return Math.round((float)maxHeight * progress);
        }

        int getOffsetY(int maxHeight, int height) {
            if (this != UP) {
                return 0;
            }
            return maxHeight - height;
        }

        static {
            DESERIALIZER = (json, typeOfT, context) -> Arrays.stream(Direction.values()).filter(d -> d.name.equals(json.getAsString())).findFirst().orElseThrow(() -> new JsonParseException("Invalid direction: " + json.toString()));
        }
    }
}

