/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs4.util;

import com.google.common.collect.Lists;
import cubex2.cs4.api.OreClass;
import cubex2.cs4.api.RecipeInput;
import cubex2.cs4.api.WrappedItemStack;
import cubex2.cs4.plugins.vanilla.Attribute;
import cubex2.cs4.plugins.vanilla.BlockDrop;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.oredict.OreDictionary;

public class ItemHelper {
    private static Field tabLabelField;

    public static Optional<CreativeTabs> findCreativeTab(String tabLabel) {
        return Arrays.stream(CreativeTabs.field_78032_a).filter(tab -> tab != null && Objects.equals(ItemHelper.getTabLabel(tab), tabLabel)).findFirst();
    }

    private static String getTabLabel(CreativeTabs tab) {
        if (tabLabelField == null) {
            tabLabelField = ReflectionHelper.findField(CreativeTabs.class, (String[])new String[]{"tabLabel", "field_78034_o", "o"});
            tabLabelField.setAccessible(true);
        }
        try {
            return (String)tabLabelField.get(tab);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static CreativeTabs[] createCreativeTabs(Attribute<String> tabLabels, int[] subtypes) {
        return (CreativeTabs[])Arrays.stream(subtypes).mapToObj(tabLabels::get).filter(Optional::isPresent).map(Optional::get).map(ItemHelper::findCreativeTab).filter(Optional::isPresent).map(Optional::get).distinct().toArray(CreativeTabs[]::new);
    }

    public static NonNullList<ItemStack> createSubItems(Item item, CreativeTabs creativeTab, Attribute<String> tabLabels, int[] subtypes) {
        NonNullList list = NonNullList.func_191196_a();
        if (item.func_77614_k()) {
            for (int meta : subtypes) {
                tabLabels.get(meta).ifPresent(tabLabel -> {
                    if (creativeTab == null || creativeTab == CreativeTabs.field_78027_g || Objects.equals(tabLabel, ItemHelper.getTabLabel(creativeTab))) {
                        list.add((Object)new ItemStack(item, 1, meta));
                    }
                });
            }
        } else {
            list.add((Object)new ItemStack(item, 1, 0));
        }
        return list;
    }

    public static boolean isSameRecipeInput(Ingredient target, Object input) {
        if (input instanceof String) {
            NonNullList ores = OreDictionary.getOres((String)input.toString());
            return ores.stream().allMatch(arg_0 -> ((Ingredient)target).apply(arg_0));
        }
        if (input instanceof ItemStack) {
            return target.apply((ItemStack)input);
        }
        if (input instanceof NonNullList) {
            NonNullList items = (NonNullList)input;
            return items.stream().anyMatch(arg_0 -> ((Ingredient)target).apply(arg_0));
        }
        throw new IllegalArgumentException("Invalid input: " + input);
    }

    public static boolean isSameStackForFuel(ItemStack fuel, ItemStack stack) {
        boolean itemEqual = stack.func_77960_j() == Short.MAX_VALUE ? fuel.func_185136_b(stack) : fuel.func_77969_a(stack);
        boolean nbtEqual = !stack.func_77942_o() || ItemStack.func_77970_a((ItemStack)stack, (ItemStack)fuel);
        return itemEqual && nbtEqual;
    }

    public static boolean stackMatchesStackOrOreClass(ItemStack target, Object input) {
        if (input instanceof ItemStack) {
            return ItemHelper.isSameStackForFuel(target, (ItemStack)input);
        }
        if (input instanceof String) {
            return OreDictionary.containsMatch((boolean)false, (NonNullList)OreDictionary.getOres((String)((String)input)), (ItemStack[])new ItemStack[]{target});
        }
        return false;
    }

    public static boolean stackMatchesRecipeInput(ItemStack stack, RecipeInput input, boolean checkCount) {
        OreClass oreClass;
        ItemStack inputStack;
        return input.isItemStack() ? OreDictionary.itemMatches((ItemStack)(inputStack = input.getStack().getItemStack()), (ItemStack)stack, (boolean)false) && (!checkCount || inputStack.func_190916_E() <= stack.func_190916_E()) : OreDictionary.containsMatch((boolean)false, (NonNullList)OreDictionary.getOres((String)(oreClass = input.getOreClass()).getOreName()), (ItemStack[])new ItemStack[]{stack}) && (!checkCount || oreClass.getAmount() <= stack.func_190916_E());
    }

    public static void removeInputsFromInventory(List<RecipeInput> inputs, IItemHandlerModifiable inv, int start, int numSlots) {
        LinkedList remaining = Lists.newLinkedList(inputs);
        block0: for (int i = start; i < start + numSlots; ++i) {
            ItemStack stack = inv.getStackInSlot(i);
            Iterator iterator = remaining.iterator();
            while (iterator.hasNext()) {
                RecipeInput input = (RecipeInput)iterator.next();
                if (!ItemHelper.stackMatchesRecipeInput(stack, input, true)) continue;
                ItemHelper.extractInput(input, inv, i);
                iterator.remove();
                continue block0;
            }
        }
    }

    static void extractInput(RecipeInput input, IItemHandlerModifiable from, int slot) {
        if (input.isOreClass()) {
            from.extractItem(slot, input.getOreClass().getAmount(), false);
        } else {
            ItemStack toExtract = input.getStack().getItemStack();
            from.extractItem(slot, toExtract.func_190916_E(), false);
        }
    }

    public static boolean fluidStackEqual(FluidStack stack, FluidStack input, boolean checkCount) {
        if (stack == null && input == null) {
            return true;
        }
        if (stack == null ^ input == null) {
            return false;
        }
        return stack.isFluidEqual(input) && (!checkCount || input.amount <= stack.amount);
    }

    public static boolean fluidStackEqual(FluidStack stack1, FluidStack stack2) {
        if (stack1 == null && stack2 == null) {
            return true;
        }
        if (stack1 == null ^ stack2 == null) {
            return false;
        }
        return stack1.isFluidEqual(stack2) && stack2.amount == stack1.amount;
    }

    public static void extractFluidsFromTanks(List<IFluidTank> tanks, List<FluidStack> fluids) {
        LinkedList remaining = Lists.newLinkedList(tanks);
        block0: for (FluidStack stack : fluids) {
            Iterator iterator = remaining.iterator();
            while (iterator.hasNext()) {
                FluidStack drained;
                IFluidTank tank = (IFluidTank)iterator.next();
                if (tank.getFluid() == null || !tank.getFluid().getFluid().getName().equals(stack.getFluid().getName()) || (drained = tank.drain(stack.amount, false)) == null || drained.amount != stack.amount) continue;
                tank.drain(stack.amount, true);
                iterator.remove();
                continue block0;
            }
        }
    }

    public static ItemStack copyStack(ItemStack stack, int newAmount) {
        ItemStack copy = stack.func_77946_l();
        copy.func_190920_e(newAmount);
        return copy;
    }

    public static List<ItemStack> getDroppedStacks(BlockDrop[] drops, int fortune) {
        ArrayList result = Lists.newArrayList();
        for (BlockDrop drop : drops) {
            int amount;
            WrappedItemStack wrappedItemStack = drop.getItem();
            ItemStack droppedStack = wrappedItemStack.getItemStack();
            if (droppedStack.func_190926_b() || (amount = drop.getAmount(fortune)) <= 0) continue;
            result.add(ItemHelper.copyStack(droppedStack, amount));
        }
        return result;
    }
}

