/*
 * Decompiled with CFR 0.152.
 */
package net.ellertonCMMShade.japng.argb8888;

import net.ellertonCMMShade.japng.PngScanlineBuffer;
import net.ellertonCMMShade.japng.argb8888.Argb8888Bitmap;
import net.ellertonCMMShade.japng.argb8888.Argb8888BitmapSequence;
import net.ellertonCMMShade.japng.argb8888.Argb8888Processors;
import net.ellertonCMMShade.japng.argb8888.Argb8888ScanlineProcessor;
import net.ellertonCMMShade.japng.argb8888.BasicArgb8888Director;
import net.ellertonCMMShade.japng.chunks.PngAnimationControl;
import net.ellertonCMMShade.japng.chunks.PngFrameControl;
import net.ellertonCMMShade.japng.chunks.PngHeader;
import net.ellertonCMMShade.japng.error.PngException;

public class Argb8888BitmapSequenceDirector
extends BasicArgb8888Director<Argb8888BitmapSequence> {
    Argb8888BitmapSequence bitmapSequence = null;
    PngFrameControl currentFrame = null;
    private PngHeader header;

    @Override
    public void receiveHeader(PngHeader header, PngScanlineBuffer buffer) throws PngException {
        this.header = header;
        this.bitmapSequence = new Argb8888BitmapSequence(header);
        this.scanlineProcessor = Argb8888Processors.from(header, buffer, this.bitmapSequence.defaultImage);
    }

    @Override
    public boolean wantDefaultImage() {
        return true;
    }

    @Override
    public boolean wantAnimationFrames() {
        return true;
    }

    @Override
    public Argb8888ScanlineProcessor beforeDefaultImage() {
        return this.scanlineProcessor;
    }

    @Override
    public void receiveDefaultImage(Argb8888Bitmap bitmap) {
        this.bitmapSequence.receiveDefaultImage(bitmap);
    }

    @Override
    public void receiveAnimationControl(PngAnimationControl control) {
        this.bitmapSequence.receiveAnimationControl(control);
    }

    @Override
    public Argb8888ScanlineProcessor receiveFrameControl(PngFrameControl control) {
        this.currentFrame = control;
        return this.scanlineProcessor.cloneWithNewBitmap(this.header.adjustFor(control));
    }

    @Override
    public void receiveFrameImage(Argb8888Bitmap bitmap) {
        if (null == this.currentFrame) {
            throw new IllegalStateException("Received a frame image with no frame control in place");
        }
        if (null == this.bitmapSequence.animationFrames) {
            throw new IllegalStateException("Received a frame image without animation control (or frame list?) in place");
        }
        this.bitmapSequence.animationFrames.add(new Argb8888BitmapSequence.Frame(this.currentFrame, bitmap));
        this.currentFrame = null;
    }

    @Override
    public Argb8888BitmapSequence getResult() {
        return this.bitmapSequence;
    }
}

