/*
 * Decompiled with CFR 0.152.
 */
package com.nekokittygames.mffs.common;

import com.google.common.collect.MapMaker;
import com.nekokittygames.mffs.api.PointXYZ;
import com.nekokittygames.mffs.common.MFFSMaschines;
import com.nekokittygames.mffs.common.tileentity.TileEntityAdvSecurityStation;
import com.nekokittygames.mffs.common.tileentity.TileEntityAreaDefenseStation;
import com.nekokittygames.mffs.common.tileentity.TileEntityCapacitor;
import com.nekokittygames.mffs.common.tileentity.TileEntityControlSystem;
import com.nekokittygames.mffs.common.tileentity.TileEntityExtractor;
import com.nekokittygames.mffs.common.tileentity.TileEntityMachines;
import com.nekokittygames.mffs.common.tileentity.TileEntityProjector;
import com.nekokittygames.mffs.common.tileentity.TileEntitySecStorage;
import java.util.Hashtable;
import java.util.Map;
import java.util.Random;
import net.minecraft.world.World;

public final class Linkgrid {
    private static Map WorldpowernetMap = new MapMaker().weakKeys().makeMap();

    public static Worldlinknet getWorldMap(World world) {
        if (world != null) {
            if (!WorldpowernetMap.containsKey(world)) {
                WorldpowernetMap.put(world, new Worldlinknet());
            }
            return (Worldlinknet)WorldpowernetMap.get(world);
        }
        return null;
    }

    public static class Worldlinknet {
        private Map<Integer, TileEntityProjector> Projektor = new Hashtable<Integer, TileEntityProjector>();
        private Map<Integer, TileEntityCapacitor> Capacitors = new Hashtable<Integer, TileEntityCapacitor>();
        private Map<Integer, TileEntityAdvSecurityStation> SecStation = new Hashtable<Integer, TileEntityAdvSecurityStation>();
        private Map<Integer, TileEntityAreaDefenseStation> DefStation = new Hashtable<Integer, TileEntityAreaDefenseStation>();
        private Map<Integer, TileEntityExtractor> Extractor = new Hashtable<Integer, TileEntityExtractor>();
        private Map<Integer, TileEntityProjector> Jammer = new Hashtable<Integer, TileEntityProjector>();
        private Map<Integer, TileEntityProjector> FieldFusion = new Hashtable<Integer, TileEntityProjector>();
        private Map<Integer, TileEntitySecStorage> SecStorage = new Hashtable<Integer, TileEntitySecStorage>();
        private Map<Integer, TileEntityControlSystem> ControlSystem = new Hashtable<Integer, TileEntityControlSystem>();

        public Map<Integer, TileEntitySecStorage> getSecStorage() {
            return this.SecStorage;
        }

        public Map<Integer, TileEntityControlSystem> getControlSystem() {
            return this.ControlSystem;
        }

        public Map<Integer, TileEntityExtractor> getExtractor() {
            return this.Extractor;
        }

        public Map<Integer, TileEntityProjector> getProjektor() {
            return this.Projektor;
        }

        public Map<Integer, TileEntityCapacitor> getCapacitor() {
            return this.Capacitors;
        }

        public Map<Integer, TileEntityAdvSecurityStation> getSecStation() {
            return this.SecStation;
        }

        public Map<Integer, TileEntityAreaDefenseStation> getDefStation() {
            return this.DefStation;
        }

        public Map<Integer, TileEntityProjector> getJammer() {
            return this.Jammer;
        }

        public Map<Integer, TileEntityProjector> getFieldFusion() {
            return this.FieldFusion;
        }

        public int refreshID(TileEntityMachines tileEntity, int remDeviceID) {
            Random random = new Random();
            int DeviceID = random.nextInt();
            if (tileEntity instanceof TileEntitySecStorage) {
                if (remDeviceID == 0) {
                    while (this.SecStorage.get(DeviceID) != null) {
                        DeviceID = random.nextInt();
                    }
                } else {
                    DeviceID = remDeviceID;
                }
                this.SecStorage.put(DeviceID, (TileEntitySecStorage)tileEntity);
                return DeviceID;
            }
            if (tileEntity instanceof TileEntityControlSystem) {
                if (remDeviceID == 0) {
                    while (this.ControlSystem.get(DeviceID) != null) {
                        DeviceID = random.nextInt();
                    }
                } else {
                    DeviceID = remDeviceID;
                }
                this.ControlSystem.put(DeviceID, (TileEntityControlSystem)tileEntity);
                return DeviceID;
            }
            if (tileEntity instanceof TileEntityAdvSecurityStation) {
                if (remDeviceID == 0) {
                    while (this.SecStation.get(DeviceID) != null) {
                        DeviceID = random.nextInt();
                    }
                } else {
                    DeviceID = remDeviceID;
                }
                this.SecStation.put(DeviceID, (TileEntityAdvSecurityStation)tileEntity);
                return DeviceID;
            }
            if (tileEntity instanceof TileEntityAreaDefenseStation) {
                if (remDeviceID == 0) {
                    while (this.DefStation.get(DeviceID) != null) {
                        DeviceID = random.nextInt();
                    }
                } else {
                    DeviceID = remDeviceID;
                }
                this.DefStation.put(DeviceID, (TileEntityAreaDefenseStation)tileEntity);
                return DeviceID;
            }
            if (tileEntity instanceof TileEntityCapacitor) {
                if (remDeviceID == 0) {
                    while (this.Capacitors.get(DeviceID) != null) {
                        DeviceID = random.nextInt();
                    }
                } else {
                    DeviceID = remDeviceID;
                }
                this.Capacitors.put(DeviceID, (TileEntityCapacitor)tileEntity);
                return DeviceID;
            }
            if (tileEntity instanceof TileEntityExtractor) {
                if (remDeviceID == 0) {
                    while (this.Extractor.get(DeviceID) != null) {
                        DeviceID = random.nextInt();
                    }
                } else {
                    DeviceID = remDeviceID;
                }
                this.Extractor.put(DeviceID, (TileEntityExtractor)tileEntity);
                return DeviceID;
            }
            if (tileEntity instanceof TileEntityProjector) {
                if (remDeviceID == 0) {
                    while (this.Projektor.get(DeviceID) != null) {
                        DeviceID = random.nextInt();
                    }
                } else {
                    DeviceID = remDeviceID;
                }
                this.Projektor.put(DeviceID, (TileEntityProjector)tileEntity);
                return DeviceID;
            }
            return 0;
        }

        public int connectedtoCapacitor(TileEntityCapacitor Cap, int range) {
            int counter = 0;
            for (TileEntityProjector tileEntityProjector : this.Projektor.values()) {
                if (tileEntityProjector.getPowerSourceID() != Cap.getPowerStorageID() || !((double)range >= PointXYZ.distance(tileEntityProjector.getMaschinePoint(), Cap.getMaschinePoint()))) continue;
                ++counter;
            }
            for (TileEntityCapacitor tileEntityCapacitor : this.Capacitors.values()) {
                if (tileEntityCapacitor.getPowerSourceID() != Cap.getPowerStorageID() || !((double)range >= PointXYZ.distance(tileEntityCapacitor.getMaschinePoint(), Cap.getMaschinePoint()))) continue;
                ++counter;
            }
            for (TileEntityAreaDefenseStation tileEntityAreaDefenseStation : this.DefStation.values()) {
                if (tileEntityAreaDefenseStation.getPowerSourceID() != Cap.getPowerStorageID() || !((double)range >= PointXYZ.distance(tileEntityAreaDefenseStation.getMaschinePoint(), Cap.getMaschinePoint()))) continue;
                ++counter;
            }
            for (TileEntityExtractor tileEntityExtractor : this.Extractor.values()) {
                if (tileEntityExtractor.getPowerSourceID() != Cap.getPowerStorageID() || !((double)range >= PointXYZ.distance(tileEntityExtractor.getMaschinePoint(), Cap.getMaschinePoint()))) continue;
                ++counter;
            }
            return counter;
        }

        public TileEntityMachines getTileEntityMachines(String displayname, int key) {
            MFFSMaschines tem = MFFSMaschines.fromdisplayName(displayname);
            if (tem != null) {
                switch (tem.index) {
                    case 1: {
                        return this.getProjektor().get(key);
                    }
                    case 2: {
                        return this.getExtractor().get(key);
                    }
                    case 3: {
                        return this.getCapacitor().get(key);
                    }
                    case 5: {
                        return this.getDefStation().get(key);
                    }
                    case 6: {
                        return this.getSecStation().get(key);
                    }
                    case 7: {
                        return this.getSecStorage().get(key);
                    }
                    case 8: {
                        return this.getControlSystem().get(key);
                    }
                }
            }
            return null;
        }
    }
}

