/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.builder;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import mcjty.lib.base.ModBase;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.blocks.GenericItemBlock;
import mcjty.lib.builder.BlockFlags;
import mcjty.lib.builder.IActivateAction;
import mcjty.lib.builder.IAddCollisionBoxToList;
import mcjty.lib.builder.ICanRenderInLayer;
import mcjty.lib.builder.IClickAction;
import mcjty.lib.builder.IGetAIPathNodeType;
import mcjty.lib.builder.IGetBoundingBox;
import mcjty.lib.builder.IGetLightValue;
import mcjty.lib.builder.ISideRenderControl;
import mcjty.lib.builder.InformationString;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BaseBlockBuilder<T extends BaseBlockBuilder<T>> {
    private static final Pattern COMPILE = Pattern.compile("@", 16);
    public static final IProperty<?>[] EMPTY_PROPERTIES = new IProperty[0];
    protected final ModBase mod;
    protected final String registryName;
    protected CreativeTabs creativeTabs;
    protected Material material = Material.field_151573_f;
    protected Function<Block, ItemBlock> itemBlockFactory = GenericItemBlock::new;
    protected List<IProperty<?>> extraProperties = new ArrayList();
    protected IActivateAction action = (world, pos, player, hand, side, hitX, hitY, hitZ) -> false;
    protected IClickAction clickAction = (world, pos, player) -> {};
    protected IGetBoundingBox boundingBox = (state, source, pos) -> Block.field_185505_j;
    protected IAddCollisionBoxToList cdBoxToList = null;
    protected IGetAIPathNodeType getAIPathNodeType = (state, world, pos) -> null;
    protected InformationString informationString;
    protected InformationString informationStringWithShift;
    protected Set<BlockFlags> flags = new HashSet<BlockFlags>();
    protected int lightValue = -1;
    protected BaseBlock.RotationType rotationType = BaseBlock.RotationType.ROTATION;

    public BaseBlockBuilder(ModBase mod, String registryName) {
        this.mod = mod;
        this.registryName = registryName;
    }

    public T creativeTabs(CreativeTabs creativeTabs) {
        this.creativeTabs = creativeTabs;
        return (T)this;
    }

    public T material(Material material) {
        this.material = material;
        return (T)this;
    }

    public T itemBlockFactory(Function<Block, ItemBlock> itemBlockFactory) {
        this.itemBlockFactory = itemBlockFactory;
        return (T)this;
    }

    public T info(String informationString) {
        this.informationString = new InformationString(informationString);
        return (T)this;
    }

    public T infoParameter(Function<ItemStack, String> parameter) {
        this.informationString.addParameter(parameter);
        return (T)this;
    }

    public T infoExtended(String informationString) {
        this.informationStringWithShift = new InformationString(informationString);
        return (T)this;
    }

    public T infoExtendedParameter(Function<ItemStack, String> parameter) {
        this.informationStringWithShift.addParameter(parameter);
        return (T)this;
    }

    public T property(IProperty<?> property) {
        this.extraProperties.add(property);
        return (T)this;
    }

    public T flags(BlockFlags ... flags) {
        Collections.addAll(this.flags, flags);
        return (T)this;
    }

    public T rotationType(BaseBlock.RotationType rotationType) {
        this.rotationType = rotationType;
        return (T)this;
    }

    public T lightValue(int v) {
        this.lightValue = v;
        return (T)this;
    }

    public T clickAction(IClickAction action) {
        this.clickAction = action;
        return (T)this;
    }

    public T activateAction(IActivateAction action) {
        this.action = action;
        return (T)this;
    }

    public T getAIPathNodeType(IGetAIPathNodeType getter) {
        this.getAIPathNodeType = getter;
        return (T)this;
    }

    public T addCollisionBoxToList(IAddCollisionBoxToList list) {
        this.cdBoxToList = list;
        return (T)this;
    }

    public T boundingBox(IGetBoundingBox boundingBox) {
        this.boundingBox = boundingBox;
        return (T)this;
    }

    public BaseBlock build() {
        final IProperty<?>[] properties = this.calculateProperties();
        final ICanRenderInLayer canRenderInLayer = this.getCanRenderInLayer();
        final IGetLightValue getLightValue = this.getGetLightValue();
        final ISideRenderControl renderControl = this.getSideRenderControl();
        final IAddCollisionBoxToList boxToList = this.getAddCollisionBoxToList();
        BaseBlock block = new BaseBlock(this.mod, this.material, this.registryName, this.itemBlockFactory){

            @Override
            protected IProperty<?>[] getProperties() {
                return properties;
            }

            @Override
            public BaseBlock.RotationType getRotationType() {
                return BaseBlockBuilder.this.rotationType;
            }

            public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
                return canRenderInLayer.canRenderInLayer(state, layer);
            }

            public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
                return getLightValue.getLightValue(state, world, pos);
            }

            public boolean doesSideBlockRendering(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing face) {
                return renderControl.doesSideBlockRendering(state, world, pos, face);
            }

            public void func_180649_a(World worldIn, BlockPos pos, EntityPlayer playerIn) {
                BaseBlockBuilder.this.clickAction.doClick(worldIn, pos, playerIn);
            }

            public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
                if (!BaseBlockBuilder.this.action.doActivate(worldIn, pos, playerIn, hand, facing, hitX, hitY, hitZ)) {
                    return super.func_180639_a(worldIn, pos, state, playerIn, hand, facing, hitX, hitY, hitZ);
                }
                return true;
            }

            public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
                return BaseBlockBuilder.this.boundingBox.getBoundingBox(state, source, pos);
            }

            public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean isActualState) {
                if (!boxToList.addCollisionBoxToList(state, worldIn, pos, entityBox, collidingBoxes, entityIn, isActualState)) {
                    super.func_185477_a(state, worldIn, pos, entityBox, collidingBoxes, entityIn, isActualState);
                }
            }

            @Nullable
            public PathNodeType getAiPathNodeType(IBlockState state, IBlockAccess world, BlockPos pos) {
                PathNodeType type = BaseBlockBuilder.this.getAIPathNodeType.getAiPathNodeType(state, world, pos);
                if (type == null) {
                    return super.getAiPathNodeType(state, world, pos);
                }
                return type;
            }
        };
        this.setupBlock(block);
        return block;
    }

    protected IGetLightValue getGetLightValue() {
        if (this.lightValue == -1) {
            return (state, world, pos) -> state.func_185906_d();
        }
        return (state, world, pos) -> this.lightValue;
    }

    protected IAddCollisionBoxToList getAddCollisionBoxToList() {
        if (this.cdBoxToList != null) {
            return this.cdBoxToList;
        }
        if (this.flags.contains((Object)BlockFlags.NO_COLLISION)) {
            return (state, worldIn, pos, entityBox, collidingBoxes, entityIn, isActualState) -> true;
        }
        return (state, worldIn, pos, entityBox, collidingBoxes, entityIn, isActualState) -> false;
    }

    protected ISideRenderControl getSideRenderControl() {
        if (this.flags.contains((Object)BlockFlags.RENDER_NOSIDES)) {
            return (state, world, pos, face) -> world.func_180495_p(pos.func_177972_a(face)).equals(state);
        }
        return (state, world, pos, face) -> state.func_185914_p();
    }

    protected ICanRenderInLayer getCanRenderInLayer() {
        ICanRenderInLayer canRenderInLayer;
        BlockRenderLayer layer = null;
        if (this.flags.contains((Object)BlockFlags.RENDER_CUTOUT)) {
            layer = BlockRenderLayer.CUTOUT;
        } else if (this.flags.contains((Object)BlockFlags.RENDER_TRANSLUCENT)) {
            layer = BlockRenderLayer.TRANSLUCENT;
        }
        if (layer != null) {
            BlockRenderLayer finalLayer = layer;
            canRenderInLayer = this.flags.contains((Object)BlockFlags.RENDER_SOLID) ? (state, layer1) -> layer1 == BlockRenderLayer.SOLID || layer1 == finalLayer : (state, layer1) -> layer1 == finalLayer;
        } else {
            canRenderInLayer = (state, layer1) -> layer1 == BlockRenderLayer.SOLID;
        }
        return canRenderInLayer;
    }

    protected IProperty<?>[] calculateProperties() {
        IProperty<?>[] properties = BaseBlock.getProperties(this.rotationType);
        IProperty<?>[] additionalProperties = this.getAdditionalProperties();
        if (!this.extraProperties.isEmpty() || additionalProperties.length > 0) {
            ArrayList newProperties = new ArrayList();
            Collections.addAll(newProperties, properties);
            Collections.addAll(newProperties, additionalProperties);
            for (IProperty<?> property : this.extraProperties) {
                newProperties.add(property);
            }
            properties = newProperties.toArray(new IProperty[newProperties.size()]);
        }
        return properties;
    }

    protected IProperty<?>[] getAdditionalProperties() {
        return EMPTY_PROPERTIES;
    }

    protected void setupBlock(BaseBlock block) {
        block.setCreative(this.flags.contains((Object)BlockFlags.CREATIVE));
        if (this.creativeTabs != null) {
            block.func_149647_a(this.creativeTabs);
        }
        boolean opaque = !this.flags.contains((Object)BlockFlags.NON_OPAQUE);
        block.setOpaqueCube(opaque);
        boolean full = !this.flags.contains((Object)BlockFlags.NON_FULLCUBE);
        block.setFullcube(full);
        block.setInformationString(this.informationString);
        if (this.informationStringWithShift != null) {
            block.setInformationStringWithShift(this.informationStringWithShift);
        } else {
            block.setInformationStringWithShift(this.informationString);
        }
    }
}

