/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.network;

import io.netty.buffer.ByteBuf;
import mcjty.lib.network.IClientCommandHandler;
import mcjty.lib.network.NetworkTools;
import mcjty.lib.network.TypedMapTools;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.Logging;
import net.minecraft.client.Minecraft;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketDataFromServer
implements IMessage {
    private BlockPos pos;
    private TypedMap result;
    private String command;

    public void fromBytes(ByteBuf buf) {
        this.pos = NetworkTools.readPos(buf);
        this.command = NetworkTools.readString(buf);
        boolean resultPresent = buf.readBoolean();
        this.result = resultPresent ? TypedMapTools.readArguments(buf) : null;
    }

    public void toBytes(ByteBuf buf) {
        NetworkTools.writePos(buf, this.pos);
        NetworkTools.writeString(buf, this.command);
        buf.writeBoolean(this.result != null);
        if (this.result != null) {
            TypedMapTools.writeArguments(buf, this.result);
        }
    }

    public PacketDataFromServer() {
    }

    public PacketDataFromServer(BlockPos pos, String command, TypedMap result) {
        this.pos = pos;
        this.command = command;
        this.result = result;
    }

    public static class Handler
    implements IMessageHandler<PacketDataFromServer, IMessage> {
        public IMessage onMessage(PacketDataFromServer message, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(() -> this.handle(message, ctx));
            return null;
        }

        private void handle(PacketDataFromServer message, MessageContext ctx) {
            TileEntity te = Minecraft.func_71410_x().field_71441_e.func_175625_s(message.pos);
            if (!(te instanceof IClientCommandHandler)) {
                Logging.log("createInventoryReadyPacket: TileEntity is not a ClientCommandHandler!");
                return;
            }
            IClientCommandHandler clientCommandHandler = (IClientCommandHandler)te;
            if (!clientCommandHandler.receiveDataFromServer(message.command, message.result)) {
                Logging.log("Command " + message.command + " was not handled!");
            }
        }
    }
}

