/*
 * Decompiled with CFR 0.152.
 */
package crafttweaker.mc1120.commands;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.mc1120.brackets.BracketHandlerItem;
import crafttweaker.mc1120.commands.Commands;
import crafttweaker.mc1120.commands.CraftTweakerCommand;
import crafttweaker.mc1120.commands.SpecialMessagesChat;
import crafttweaker.mc1120.data.NBTConverter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.command.ICommandSender;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;

public class NamesCommand
extends CraftTweakerCommand {
    private ArrayList<String> subCommands;

    public NamesCommand() {
        super("names");
    }

    @Override
    protected void init() {
        this.setDescription(SpecialMessagesChat.getClickableCommandText("\u00a72/ct names", "/ct names", true), SpecialMessagesChat.getNormalMessage(" \u00a73Outputs a list of all item names in the game to the CraftTweaker log"), SpecialMessagesChat.getClickableCommandText(" \u00a7a/ct names display unloc maxstack maxuse maxdamage rarity repaircost damageable repairable creativetabs", "/ct names display unloc maxstack maxuse maxdamage rarity repaircost damageable repairable creativetabs", true), SpecialMessagesChat.getNormalMessage("  \u00a7bAdds all possible information to the output."));
        this.subCommands = new ArrayList(2);
        for (NameCommandParams para : NameCommandParams.values()) {
            if (para == NameCommandParams.REGISTRY_NAME) continue;
            this.subCommands.add(para.getCommandEquivalent());
        }
    }

    @Override
    public void executeCommand(MinecraftServer server, ICommandSender sender, String[] args) {
        ArrayList<NameCommandParams> paramList = new ArrayList<NameCommandParams>();
        paramList.add(NameCommandParams.REGISTRY_NAME);
        block0: for (String arg : args) {
            for (Object para : NameCommandParams.values()) {
                if (!para.getCommandEquivalent().equals(arg)) continue;
                paramList.add((NameCommandParams)((Object)para));
                continue block0;
            }
        }
        ArrayList<Item> items = new ArrayList<Item>(BracketHandlerItem.getItemNames().values());
        items.sort(Commands.ITEM_COMPARATOR);
        CraftTweakerAPI.logCommand("List of all registered Items:");
        StringBuilder syntaxStringBuilder = new StringBuilder();
        HashMap<NameCommandParams, Integer> timesUsed = new HashMap<NameCommandParams, Integer>();
        for (NameCommandParams param : paramList) {
            if (param == NameCommandParams.REGISTRY_NAME) {
                syntaxStringBuilder.append("\"").append(param.toString()).append("\"");
                continue;
            }
            syntaxStringBuilder.append(",\"").append(param.toString());
            if (!timesUsed.containsKey((Object)param)) {
                timesUsed.put(param, 1);
            } else {
                int t = (Integer)timesUsed.get((Object)param) + 1;
                timesUsed.replace(param, t);
                syntaxStringBuilder.append(t);
            }
            syntaxStringBuilder.append("\"");
        }
        CraftTweakerAPI.logCommand(syntaxStringBuilder.toString());
        int totalAmount = 0;
        for (Item item : items) {
            if (item == null) continue;
            NonNullList list = NonNullList.func_191196_a();
            item.func_150895_a(CreativeTabs.field_78027_g, list);
            if (!list.isEmpty()) {
                for (ItemStack stack : list) {
                    CraftTweakerAPI.logCommand(this.createOutputForItem(stack, paramList));
                    ++totalAmount;
                }
                continue;
            }
            ItemStack stack = new ItemStack(item, 1, 0);
            CraftTweakerAPI.logCommand(this.createOutputForItem(stack, paramList));
        }
        CraftTweakerAPI.logCommand("A total of " + items.size() + " unique Items registered by CraftTweaker.");
        CraftTweakerAPI.logCommand("A total of " + totalAmount + " effective Items registered by CraftTweaker.");
        sender.func_145747_a(SpecialMessagesChat.getLinkToCraftTweakerLog("List generated", sender));
    }

    @Override
    public List<String> getSubSubCommand(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        ArrayList<String> currentPossibleCommands = new ArrayList<String>();
        if (args.length <= 0) {
            return new ArrayList<String>(this.subCommands);
        }
        for (String cmd : this.subCommands) {
            if (!cmd.startsWith(args[args.length - 1])) continue;
            currentPossibleCommands.add(cmd);
        }
        return currentPossibleCommands;
    }

    public static String prepareForCSV(String string) {
        return string.replace("\"", "\"\"");
    }

    protected String createOutputForItem(ItemStack stack, List<NameCommandParams> paramList) {
        StringBuilder sb = new StringBuilder();
        for (NameCommandParams type : paramList) {
            if (type == NameCommandParams.REGISTRY_NAME) {
                sb.append("\"");
            } else {
                sb.append(",\"");
            }
            sb.append(NamesCommand.prepareForCSV(type.getInformation(stack)));
            sb.append("\"");
        }
        return sb.toString();
    }

    private static enum NameCommandParams {
        REGISTRY_NAME("23498z9384z9283z49", stack -> {
            String nbt;
            StringBuilder sb = new StringBuilder();
            sb.append("<").append(stack.func_77973_b().getRegistryName() != null ? stack.func_77973_b().getRegistryName().toString() : "[NO REGISTRY NAME] {" + stack.func_77973_b().getClass().toString() + "}").append(stack.func_77960_j() == 0 ? "" : ":" + stack.func_77960_j()).append(">");
            if (stack.serializeNBT().func_74764_b("tag") && (nbt = NBTConverter.from(stack.serializeNBT().func_74781_a("tag"), false).toString()).length() > 0) {
                sb.append(".withTag(").append(nbt).append(")");
            }
            return sb.toString();
        }),
        DISPLAY_NAME("display", ItemStack::func_82833_r),
        MOD_ID("modid", stack -> {
            ResourceLocation resLoc = stack.func_77973_b().getRegistryName();
            return resLoc != null ? stack.func_77973_b().getRegistryName().func_110624_b() : "[NO REGISTRY NAME] {" + stack.func_77973_b().getClass().toString() + "}";
        }),
        UNLOCALIZED("unloc", ItemStack::func_77977_a),
        MAX_STACK_SIZE("maxstack", stack -> Integer.toString(stack.func_77976_d())),
        MAX_ITEM_USE_DURATION("maxuse", stack -> Integer.toString(stack.func_77988_m())),
        MAX_ITEM_DAMAGE("maxdamage", stack -> Integer.toString(stack.func_77958_k())),
        RARITY("rarity", stack -> stack.func_77953_t().field_77934_f),
        REPAIR_COST("repaircost", stack -> Integer.toString(stack.func_82838_A())),
        DAMAGEABLE("damageable", stack -> Boolean.toString(stack.func_77973_b().func_77645_m())),
        REPAIRABLE("repairable", stack -> Boolean.toString(stack.func_77973_b().isRepairable())),
        CREATIVE_TABS("creativetabs", stack -> {
            StringBuilder tabString = new StringBuilder();
            tabString.append("[");
            for (CreativeTabs creativeTabs : stack.func_77973_b().getCreativeTabs()) {
                if (tabString.length() != 1) {
                    tabString.append(", ");
                }
                if (creativeTabs == null) continue;
                tabString.append(creativeTabs.func_78013_b());
            }
            tabString.append("]");
            return tabString.toString();
        });

        private String commandEquivalent;
        private Function<ItemStack, String> informationProducer;

        private NameCommandParams(String commandEquivalent, Function<ItemStack, String> informationProducer) {
            this.commandEquivalent = commandEquivalent;
            this.informationProducer = informationProducer;
        }

        public String getCommandEquivalent() {
            return this.commandEquivalent;
        }

        public String getInformation(ItemStack stack) {
            return this.informationProducer.apply(stack);
        }
    }
}

