/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.zenscript.expression;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Objects;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Type;
import stanhebben.zenscript.compiler.EnvironmentClass;
import stanhebben.zenscript.compiler.EnvironmentMethod;
import stanhebben.zenscript.compiler.IEnvironmentMethod;
import stanhebben.zenscript.compiler.ZenClassWriter;
import stanhebben.zenscript.definitions.ParsedFunctionArgument;
import stanhebben.zenscript.expression.Expression;
import stanhebben.zenscript.statements.Statement;
import stanhebben.zenscript.symbols.SymbolArgument;
import stanhebben.zenscript.type.ZenType;
import stanhebben.zenscript.util.MethodOutput;
import stanhebben.zenscript.util.ZenPosition;
import stanhebben.zenscript.util.ZenTypeUtil;

public class ExpressionJavaLambdaSimpleGeneric
extends Expression {
    private final Class interfaceClass;
    private final Class genericClass;
    private final List<ParsedFunctionArgument> arguments;
    private final List<Statement> statements;
    private final String descriptor;
    private final ZenType type;

    public ExpressionJavaLambdaSimpleGeneric(ZenPosition position, Class interfaceClass, List<ParsedFunctionArgument> arguments, List<Statement> statements, ZenType type) {
        super(position);
        this.interfaceClass = interfaceClass;
        this.arguments = arguments;
        this.statements = statements;
        this.type = type;
        ZenType genericType = arguments.get(0).getType();
        this.genericClass = genericType.equals(ZenType.ANY) ? Object.class : genericType.toJavaClass();
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        for (int i = 0; i < arguments.size(); ++i) {
            ZenType t = arguments.get(i).getType();
            if (t.equals(ZenType.ANY)) {
                sb.append(ZenTypeUtil.signature(interfaceClass.getMethods()[0].getParameterTypes()[i]));
                continue;
            }
            sb.append(t.getSignature());
        }
        sb.append(")").append(ZenTypeUtil.signature(interfaceClass.getDeclaredMethods()[0].getReturnType()));
        this.descriptor = sb.toString();
    }

    @Override
    public ZenType getType() {
        return this.type;
    }

    @Override
    public void compile(boolean result, IEnvironmentMethod environment) {
        if (!result) {
            return;
        }
        Method method = this.interfaceClass.getMethods()[0];
        String clsName = environment.makeClassNameWithMiddleName(this.getPosition().getFile().getClassName());
        ZenClassWriter cw = new ZenClassWriter(2);
        cw.visit(50, 1, clsName, this.createMethodSignature(), "java/lang/Object", new String[]{ZenTypeUtil.internal(this.interfaceClass)});
        MethodOutput constructor = new MethodOutput((ClassVisitor)cw, 1, "<init>", "()V", null, null);
        constructor.start();
        constructor.loadObject(0);
        constructor.invokeSpecial("java/lang/Object", "<init>", "()V");
        constructor.ret();
        constructor.end();
        MethodOutput output = new MethodOutput((ClassVisitor)cw, 1, method.getName(), this.descriptor, null, null);
        EnvironmentClass environmentClass = new EnvironmentClass((ClassVisitor)cw, environment);
        EnvironmentMethod environmentMethod = new EnvironmentMethod(output, environmentClass);
        for (int i = 0; i < this.arguments.size(); ++i) {
            ZenType typeToPut = this.arguments.get(i).getType();
            if (typeToPut.equals(ZenType.ANY)) {
                typeToPut = environment.getType(method.getGenericParameterTypes()[i]);
            }
            if (typeToPut == null) {
                typeToPut = environment.getType(method.getParameterTypes()[i]);
            }
            environmentMethod.putValue(this.arguments.get(i).getName(), new SymbolArgument(i + 1, typeToPut), this.getPosition());
        }
        output.start();
        for (Statement statement : this.statements) {
            statement.compile(environmentMethod);
        }
        output.ret();
        output.end();
        if (!Objects.equals(this.genericClass, Object.class)) {
            MethodOutput bridge = new MethodOutput((ClassVisitor)cw, 4161, method.getName(), ZenTypeUtil.descriptor(method), null, null);
            bridge.loadObject(0);
            bridge.loadObject(1);
            bridge.checkCast(ZenTypeUtil.internal(this.genericClass));
            if (this.arguments.size() > 1) {
                int i = 1;
                while (i < this.arguments.size()) {
                    bridge.load(Type.getType(method.getParameterTypes()[i]), ++i);
                }
            }
            bridge.invokeVirtual(clsName, method.getName(), this.descriptor);
            bridge.returnType(Type.getReturnType((Method)method));
            bridge.end();
        }
        environment.putClass(clsName, cw.toByteArray());
        environment.getOutput().newObject(clsName);
        environment.getOutput().dup();
        environment.getOutput().construct(clsName, new String[0]);
    }

    private String createMethodSignature() {
        StringBuilder sb = new StringBuilder();
        sb.append("Ljava/lang/Object;");
        sb.append(ZenTypeUtil.signature(this.interfaceClass));
        sb.deleteCharAt(sb.length() - 1);
        sb.append("<").append(ZenTypeUtil.signature(this.genericClass)).append(">").append(";");
        return sb.toString();
    }
}

