/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.base.tile;

import ic2.api.classic.energy.tile.IEnergySourceInfo;
import ic2.api.classic.network.adv.NetworkField;
import ic2.api.classic.tile.IElectrolyzerProvider;
import ic2.api.classic.tile.machine.IEUStorage;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergyAcceptor;
import ic2.api.energy.tile.IEnergyEmitter;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.item.ElectricItem;
import ic2.api.network.INetworkClientTileEntityEventListener;
import ic2.api.tile.IEnergyStorage;
import ic2.core.RotationList;
import ic2.core.block.base.tile.TileEntityMachine;
import ic2.core.block.base.util.comparator.ComparatorManager;
import ic2.core.block.base.util.comparator.comparators.ComparatorEUStorage;
import ic2.core.block.base.util.info.EmitterInfo;
import ic2.core.block.base.util.info.EnergyInfo;
import ic2.core.block.base.util.info.MaxInputInfo;
import ic2.core.block.base.util.info.TierInfo;
import ic2.core.block.base.util.info.misc.IEmitterTile;
import ic2.core.block.wiring.container.ContainerElectricBlock;
import ic2.core.inventory.base.IHasGui;
import ic2.core.inventory.container.ContainerIC2;
import ic2.core.inventory.filters.ArrayFilter;
import ic2.core.inventory.filters.BasicItemFilter;
import ic2.core.inventory.filters.CommonFilters;
import ic2.core.inventory.gui.GuiComponentContainer;
import ic2.core.inventory.management.AccessRule;
import ic2.core.inventory.management.InventoryHandler;
import ic2.core.inventory.management.SlotType;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2GuiLang;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.platform.registry.Ic2Resources;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public abstract class TileEntityElectricBlock
extends TileEntityMachine
implements IEnergySink,
IEUStorage,
IEnergySourceInfo,
IEnergyStorage,
IElectrolyzerProvider,
INetworkClientTileEntityEventListener,
ITickable,
IHasGui,
IEmitterTile {
    public int tier;
    public int output;
    public int maxEnergy;
    @NetworkField(index=3)
    public int energy;
    @NetworkField(index=4)
    public byte redstoneMode = 0;
    @NetworkField(index=5, compression=NetworkField.BitLevel.Bit8)
    public int state = 0;
    public boolean emit = false;
    public boolean addedToEnet;

    public TileEntityElectricBlock(int tier, int output, int maxEnergy) {
        super(2);
        this.tier = tier;
        this.output = output;
        this.maxEnergy = maxEnergy;
        this.addNetworkFields("state");
        this.addGuiFields("energy", "redstoneMode");
        this.addInfos(new EnergyInfo(this), new TierInfo(tier), new EmitterInfo(this), new MaxInputInfo(this));
    }

    @Override
    protected void addSlots(InventoryHandler handler) {
        handler.registerDefaultSideAccess(AccessRule.Both, RotationList.ALL);
        handler.registerDefaultSlotAccess(AccessRule.Both, 0, 1);
        handler.registerDefaultSlotsForSide(RotationList.UP, 0);
        handler.registerDefaultSlotsForSide(RotationList.DOWN, 1);
        handler.registerInputFilter(CommonFilters.ChargeEU, 0);
        handler.registerOutputFilter(CommonFilters.NotChargeEU, 0);
        handler.registerInputFilter(new ArrayFilter(CommonFilters.DischargeEU, new BasicItemFilter(Items.field_151137_ax), new BasicItemFilter(Ic2Items.suBattery), new BasicItemFilter(Blocks.field_150451_bX)), 1);
        handler.registerOutputFilter(CommonFilters.NotDischargeEU, 1);
        handler.registerSlotType(SlotType.Charge, 0);
        handler.registerSlotType(SlotType.Discharge, 1);
    }

    @Override
    protected void addComparators(ComparatorManager manager) {
        super.addComparators(manager);
        manager.addComparatorMode(new ComparatorEUStorage(this));
    }

    public ResourceLocation getTexture() {
        return Ic2Resources.energyStorage;
    }

    @Override
    public int getStoredEU() {
        return this.energy;
    }

    @Override
    public int getMaxEU() {
        return this.maxEnergy;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.energy = nbt.func_74762_e("energy");
        this.redstoneMode = nbt.func_74771_c("Mode");
        this.state = nbt.func_74762_e("state");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("energy", this.energy);
        nbt.func_74774_a("Mode", this.redstoneMode);
        nbt.func_74768_a("state", this.state);
        return nbt;
    }

    @Override
    public void onNetworkUpdate(String field) {
        super.onNetworkUpdate(field);
        if (field.equals("state")) {
            this.field_145850_b.func_175704_b(this.func_174877_v(), this.func_174877_v());
        }
    }

    public float getChargeLevel() {
        float ret = (float)this.energy / (float)this.maxEnergy;
        if (ret > 1.0f) {
            ret = 1.0f;
        }
        return ret;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (this.isSimulating() && !this.addedToEnet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
            this.addedToEnet = true;
        }
    }

    @Override
    public void onUnloaded() {
        if (this.isSimulating() && this.addedToEnet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
            this.addedToEnet = false;
        }
        super.onUnloaded();
    }

    @Override
    public boolean canSetFacing(EntityPlayer player, EnumFacing facing) {
        return this.getFacing() != facing;
    }

    @Override
    public boolean canRemoveBlock(EntityPlayer player) {
        return true;
    }

    @Override
    public boolean acceptsEnergyFrom(IEnergyEmitter emitter, EnumFacing side) {
        return this.getFacing() != side;
    }

    @Override
    public double getDemandedEnergy() {
        return this.maxEnergy - this.energy;
    }

    @Override
    public int getSinkTier() {
        return this.tier;
    }

    @Override
    public double injectEnergy(EnumFacing directionFrom, double amount, double voltage) {
        if (amount > (double)this.output || amount <= 0.0) {
            return 0.0;
        }
        this.energy = (int)((double)this.energy + amount);
        int left = 0;
        if (this.energy >= this.maxEnergy) {
            left = this.energy - this.maxEnergy;
            this.energy = this.maxEnergy;
        }
        this.getNetwork().updateTileGuiField(this, "energy");
        return left;
    }

    @Override
    public boolean emitsEnergyTo(IEnergyAcceptor receiver, EnumFacing side) {
        return this.getFacing() == side;
    }

    @Override
    public double getOfferedEnergy() {
        if (this.energy < this.output) {
            return 0.0;
        }
        if (this.redstoneMode == 6 && this.isRedstonePowered()) {
            return 0.0;
        }
        if (this.redstoneMode == 7 && this.isRedstonePowered() && this.energy < this.maxEnergy) {
            return 0.0;
        }
        return this.output;
    }

    @Override
    public int getMaxSendingEnergy() {
        return this.output;
    }

    @Override
    public void drawEnergy(double amount) {
        this.energy = (int)((double)this.energy - amount);
        this.getNetwork().updateTileGuiField(this, "energy");
    }

    @Override
    public int getSourceTier() {
        return this.tier;
    }

    @Override
    public void setFacing(EnumFacing face) {
        if (this.addedToEnet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
        }
        this.addedToEnet = false;
        super.setFacing(face);
        MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
        this.addedToEnet = true;
    }

    @Override
    public int getStored() {
        return this.energy;
    }

    @Override
    public void setStored(int newEnergy) {
        this.energy = newEnergy;
        this.getNetwork().updateTileGuiField(this, "energy");
    }

    @Override
    public int addEnergy(int amount) {
        this.energy += amount;
        this.getNetwork().updateTileGuiField(this, "energy");
        return this.energy;
    }

    @Override
    public int getCapacity() {
        return this.maxEnergy;
    }

    @Override
    public int getOutput() {
        return this.output;
    }

    @Override
    public double getOutputEnergyUnitsPerTick() {
        return this.output;
    }

    @Override
    public boolean isTeleporterCompatible(EnumFacing side) {
        return true;
    }

    @Override
    public int getTier() {
        return this.tier;
    }

    @Override
    public void addPower(int amount) {
        this.energy += amount;
        this.getNetwork().updateTileGuiField(this, "energy");
    }

    @Override
    public void drawPower(int amount) {
        this.energy -= amount;
        this.getNetwork().updateTileGuiField(this, "energy");
    }

    @Override
    public int getStoredEnergy() {
        return this.energy;
    }

    @Override
    public int getMaxEnergyStorage() {
        return this.maxEnergy;
    }

    @Override
    public void onNetworkEvent(EntityPlayer player, int event) {
        if (event == 0) {
            this.redstoneMode = (byte)(this.redstoneMode + 1);
            if (this.redstoneMode >= 8) {
                this.redstoneMode = 0;
            }
            this.updateNeighbors(true);
            this.getNetwork().updateTileGuiField(this, "redstoneMode");
        }
    }

    public LocaleComp getRedstoneMode() {
        switch (this.redstoneMode) {
            case 1: {
                return Ic2GuiLang.redstoneModeFull;
            }
            case 2: {
                return Ic2GuiLang.redstoneModePartiallyFilled;
            }
            case 3: {
                return Ic2GuiLang.redstoneMode50Full;
            }
            case 4: {
                return Ic2GuiLang.redstoneMode50Empty;
            }
            case 5: {
                return Ic2GuiLang.redstoneModeEmpty;
            }
            case 6: {
                return Ic2GuiLang.redstoneModeOutputWithoutSignal;
            }
            case 7: {
                return Ic2GuiLang.redstoneModeOutputWithoutSignalWhenFull;
            }
        }
        return Ic2GuiLang.redstoneModeNothing;
    }

    public void updateNeighbors(boolean needSelf) {
        if (needSelf) {
            this.field_145850_b.func_190524_a(this.func_174877_v(), this.func_145838_q(), this.func_174877_v());
        }
        for (EnumFacing side : EnumFacing.field_82609_l) {
            BlockPos newPos = this.func_174877_v().func_177972_a(side);
            if (!this.field_145850_b.func_175667_e(newPos)) continue;
            this.field_145850_b.func_190524_a(newPos, this.func_145838_q(), this.func_174877_v());
        }
    }

    @Override
    public boolean needsInitialRedstoneUpdate() {
        return true;
    }

    public void func_73660_a() {
        boolean newEmitting;
        int newState;
        this.handleRedstone();
        boolean isEmitting = this.isEmittingRedstone();
        if (this.energy > 0 && !((ItemStack)this.inventory.get(0)).func_190926_b()) {
            int removed = (int)ElectricItem.manager.charge((ItemStack)this.inventory.get(0), this.energy, this.tier, false, false);
            this.energy -= removed;
            if (removed > 0) {
                this.getNetwork().updateTileGuiField(this, "energy");
            }
        }
        if (this.maxEnergy > this.energy && !((ItemStack)this.inventory.get(1)).func_190926_b()) {
            ItemStack fuel = (ItemStack)this.inventory.get(1);
            Item item = fuel.func_77973_b();
            boolean removeItem = false;
            if (item == Items.field_151137_ax) {
                this.energy += 500;
                removeItem = true;
            } else if (item == Item.func_150898_a((Block)Blocks.field_150451_bX)) {
                this.energy += 5000;
                removeItem = true;
            } else if (item == Ic2Items.suBattery.func_77973_b()) {
                this.energy += 1000;
                removeItem = true;
            } else {
                int added = (int)ElectricItem.manager.discharge(fuel, this.maxEnergy - this.energy, this.tier, false, true, false);
                this.energy += added;
                if (added > 0) {
                    this.getNetwork().updateTileGuiField(this, "energy");
                }
            }
            if (this.energy > this.maxEnergy) {
                this.energy = this.maxEnergy;
            }
            if (removeItem) {
                fuel.func_190918_g(1);
                this.getNetwork().updateTileGuiField(this, "energy");
            }
        }
        if ((newState = this.getUpdatedState()) != this.state) {
            this.state = newState;
            this.getNetwork().updateTileEntityField(this, "state");
        }
        if (isEmitting != (newEmitting = this.isEmittingRedstone()) || this.emit != newEmitting) {
            this.updateNeighbors(true);
            this.emit = newEmitting;
        }
        this.updateComparators();
    }

    public int getUpdatedState() {
        float charge = this.getChargeLevel();
        if ((double)charge <= 0.01) {
            return 0;
        }
        if ((double)charge >= 0.99) {
            return 3;
        }
        if ((double)charge < 0.5) {
            return 1;
        }
        return 2;
    }

    public boolean isEmittingRedstone() {
        switch (this.redstoneMode) {
            case 1: {
                return this.energy >= this.maxEnergy;
            }
            case 2: {
                return this.energy > this.output && this.energy < this.maxEnergy;
            }
            case 3: {
                return this.energy >= this.maxEnergy / 2;
            }
            case 4: {
                return this.energy <= this.maxEnergy / 2;
            }
            case 5: {
                return this.energy < this.output;
            }
        }
        return false;
    }

    @Override
    public ContainerIC2 getGuiContainer(EntityPlayer player) {
        return new ContainerElectricBlock(player.field_71071_by, this);
    }

    @Override
    public Class<? extends GuiScreen> getGuiClass(EntityPlayer player) {
        return GuiComponentContainer.class;
    }

    @Override
    public void onGuiClosed(EntityPlayer player) {
    }

    @Override
    public boolean canInteractWith(EntityPlayer player) {
        return !this.func_145837_r();
    }

    @Override
    public boolean hasGui(EntityPlayer player) {
        return true;
    }
}

