/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.crop.crops;

import ic2.api.crops.CropProperties;
import ic2.api.crops.ICropTile;
import ic2.core.block.crop.crops.CropCardBase;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CropSeedFood
extends CropCardBase {
    String name;
    String color;
    int sprite;
    ItemStack gain;

    public CropSeedFood(String id, String color, int spriteID, ItemStack stack) {
        super(new CropProperties(2, 0, 4, 0, 0, 2));
        this.name = id;
        this.color = color;
        this.sprite = spriteID;
        this.gain = stack;
    }

    @Override
    public String getDiscoveredBy() {
        return "Notch";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTexture(int state) {
        if (state < 3) {
            return this.getSprite("bc")[47 + state];
        }
        return this.getSprite("bc")[this.sprite];
    }

    @Override
    public boolean canGrow(ICropTile cropTile) {
        return cropTile.getCurrentSize() < 3 && cropTile.getLightLevel() >= 9;
    }

    @Override
    public boolean canBeHarvested(ICropTile cropTile) {
        return cropTile.getCurrentSize() == 3;
    }

    @Override
    public String getId() {
        return this.name;
    }

    @Override
    public String[] getAttributes() {
        return new String[]{this.color, "Food", this.name};
    }

    @Override
    public int getMaxSize() {
        return 3;
    }

    @Override
    public int getSizeAfterHarvest(ICropTile cropTile) {
        return 1;
    }

    @Override
    public ItemStack getGain(ICropTile crop) {
        return this.gain.func_77946_l();
    }

    @Override
    public int getOptimalHarvestSize(ICropTile cropTile) {
        return 3;
    }
}

