/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.misc;

import ic2.core.platform.lang.ILocaleBlock;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2BlockLang;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.platform.registry.Ic2States;
import ic2.core.platform.textures.Ic2Icons;
import ic2.core.platform.textures.obj.ITexturedBlock;
import ic2.core.util.misc.StackUtil;
import ic2.core.util.obj.IBootable;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BlockPixelFoam
extends Block
implements ITexturedBlock,
IBootable,
ILocaleBlock {
    public static PropertyInteger metadata = PropertyInteger.func_177719_a((String)"metadata", (int)0, (int)15);

    public BlockPixelFoam() {
        super(Material.field_151576_e);
        this.func_149711_c(3.0f);
        this.func_149752_b(30.0f);
        this.func_149672_a(SoundType.field_185851_d);
        this.setHarvestLevel("pickaxe", 0);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{metadata});
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)metadata);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)metadata, (Comparable)Integer.valueOf(meta));
    }

    public String func_149732_F() {
        return this.getName().getLocalized();
    }

    public String func_149739_a() {
        return this.getName().getUnlocalized();
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    @Override
    public LocaleComp getName() {
        return Ic2BlockLang.foamPixel;
    }

    @Override
    public void onLoad() {
        Ic2States.pixelFoam = this.func_176223_P();
        Ic2Items.pixelFoam = new ItemStack((Block)this);
    }

    @Override
    public AxisAlignedBB getRenderBoundingBox(IBlockState state) {
        return field_185505_j;
    }

    @Override
    public TextureAtlasSprite getTextureFromState(IBlockState state, EnumFacing side) {
        return Ic2Icons.getTextures("b0")[240 + this.func_176201_c(state)];
    }

    @Override
    public TextureAtlasSprite getParticleTexture(IBlockState state) {
        return Ic2Icons.getTextures("b0")[240 + this.func_176201_c(state)];
    }

    @Override
    public List<IBlockState> getValidStates() {
        return this.func_176194_O().func_177619_a();
    }

    @Override
    public IBlockState getStateFromStack(ItemStack stack) {
        return this.func_176203_a(stack.func_77960_j());
    }

    public void func_149666_a(CreativeTabs itemIn, NonNullList<ItemStack> items) {
        for (int i = 0; i < 16; ++i) {
            if (!BlockPixelFoam.isMetaValid(i)) continue;
            items.add((Object)new ItemStack((Block)this, 1, i));
        }
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        BlockPos target;
        if (hand == EnumHand.OFF_HAND) {
            return false;
        }
        int meta = this.func_176201_c(state);
        if (meta == 0) {
            playerIn.field_70159_w += (double)facing.func_82601_c() * 2.5;
            playerIn.field_70181_x += (double)(facing.func_96559_d() * 1);
            playerIn.field_70179_y += (double)facing.func_82599_e() * 2.5;
            return true;
        }
        if (meta == 9) {
            if (StackUtil.isStackEqual(playerIn.func_184586_b(EnumHand.MAIN_HAND), new ItemStack((Block)Blocks.field_150328_O))) {
                playerIn.func_70691_i(playerIn.func_110138_aP() - playerIn.func_110143_aJ());
                ItemStack stack = playerIn.func_184586_b(EnumHand.MAIN_HAND);
                stack.func_190918_g(1);
                return true;
            }
        } else if (meta == 13) {
            if (StackUtil.isStackEqual(playerIn.func_184586_b(EnumHand.MAIN_HAND), new ItemStack(Blocks.field_150471_bO))) {
                playerIn.field_71071_by.func_70441_a(new ItemStack(Items.field_151106_aX));
                return true;
            }
        } else if (meta == 15 && worldIn.func_175623_d(target = pos.func_177972_a(facing.func_176734_d()))) {
            if (worldIn.func_175623_d(target.func_177977_b())) {
                playerIn.func_70634_a((double)target.func_177958_n() + 0.5, (double)(target.func_177956_o() - 1), (double)target.func_177952_p() + 0.5);
            } else if (worldIn.func_175623_d(target.func_177984_a())) {
                playerIn.func_70634_a((double)target.func_177958_n() + 0.5, (double)target.func_177956_o(), (double)target.func_177952_p() + 0.5);
            }
            return true;
        }
        return false;
    }

    public static boolean isMetaValid(int meta) {
        return meta != 3 && meta != 6 && meta != 14;
    }

    public static EnumDyeColor getSeconaryColor(int meta) {
        switch (meta) {
            case 0: {
                return EnumDyeColor.BROWN;
            }
            case 1: {
                return EnumDyeColor.YELLOW;
            }
            case 2: {
                return EnumDyeColor.YELLOW;
            }
            case 3: {
                return null;
            }
            case 4: {
                return EnumDyeColor.YELLOW;
            }
            case 5: {
                return EnumDyeColor.BLUE;
            }
            case 6: {
                return null;
            }
            case 7: {
                return EnumDyeColor.PURPLE;
            }
            case 8: {
                return EnumDyeColor.RED;
            }
            case 9: {
                return EnumDyeColor.RED;
            }
            case 10: {
                return EnumDyeColor.PINK;
            }
            case 11: {
                return EnumDyeColor.BLACK;
            }
            case 12: {
                return EnumDyeColor.GREEN;
            }
            case 13: {
                return EnumDyeColor.BROWN;
            }
            case 14: {
                return null;
            }
            case 15: {
                return EnumDyeColor.GRAY;
            }
        }
        return null;
    }
}

