/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.personal.base.util;

import ic2.api.classic.trading.trades.ISubTrade;
import ic2.api.classic.trading.trades.ITrade;
import ic2.api.classic.util.IWorldTickCallback;
import ic2.core.IC2;
import ic2.core.block.personal.base.TileEntityTradeOMatBase;
import ic2.core.block.personal.base.util.TradeCallBack;
import ic2.core.network.fieldEvents.custom.NBTFieldPacket;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.MathHelper;

public class TradeSyncer {
    final TileEntityTradeOMatBase tile;
    Map<EntityPlayer, ServerEntry> serverData = new LinkedHashMap<EntityPlayer, ServerEntry>();
    Set<EntityPlayer> dirtyData = new LinkedHashSet<EntityPlayer>();
    ClientEntry clientData = new ClientEntry();
    boolean updater = false;
    IWorldTickCallback receiver = new TradeCallBack(this);

    public TradeSyncer(TileEntityTradeOMatBase trade) {
        this.tile = trade;
    }

    public void createDataForPlayer(EntityPlayer player) {
        this.serverData.put(player, new ServerEntry(player, true));
        this.dirtyData.add(player);
        this.addUpdater();
    }

    public void clearDataForPlayer(EntityPlayer player) {
        this.serverData.remove(player);
        this.dirtyData.remove(player);
    }

    public void markAllDirty() {
        for (ServerEntry server : this.serverData.values()) {
            server.markDirty();
            this.dirtyData.add(server.player);
        }
        this.addUpdater();
    }

    public void updateAll() {
        for (ServerEntry server : this.serverData.values()) {
            this.dirtyData.add(server.player);
        }
        this.addUpdater();
    }

    public void moveTrade(EntityPlayer player, int direction) {
        ServerEntry entry = this.serverData.get(player);
        if (entry == null) {
            return;
        }
        entry.moveDir(direction);
        this.dirtyData.add(player);
        this.addUpdater();
    }

    public void markDirty(EntityPlayer player) {
        ServerEntry entry = this.serverData.get(player);
        if (entry == null) {
            return;
        }
        entry.markDirty();
        this.dirtyData.add(player);
        this.addUpdater();
    }

    public void addUpdater() {
        if (this.updater || this.tile.isRendering()) {
            return;
        }
        this.updater = true;
        IC2.callbacks.addCallback(this.tile.func_145831_w(), this.receiver);
    }

    public void updateAllDirty() {
        if (this.dirtyData.isEmpty()) {
            return;
        }
        for (EntityPlayer player : this.dirtyData) {
            NBTFieldPacket packet = this.createPacket(player);
            if (packet == null) continue;
            this.tile.getNetwork().initiateCustomTileEntityEvent(this.tile, player, packet);
        }
        this.dirtyData.clear();
    }

    public NBTFieldPacket createPacket(EntityPlayer player) {
        ServerEntry entry = this.serverData.get(player);
        if (entry == null) {
            return null;
        }
        if (entry.isDirty()) {
            entry.updateData(this.tile);
        }
        return new NBTFieldPacket(entry.getPacketNBT());
    }

    public void receivePacket(EntityPlayer player, NBTFieldPacket data) {
        this.clientData.receive(player, data.getNBTData());
    }

    public ClientEntry getClientData() {
        return this.clientData;
    }

    public ITrade getServerTrade(EntityPlayer player) {
        ServerEntry entry = this.serverData.get(player);
        if (entry == null) {
            return null;
        }
        return entry.getServerTrade();
    }

    public static class ClientEntry {
        public ITrade focus;
        public int tradeSlot = 0;
        public int maxTradeSlot = 0;
        public List<ISubTrade> subTrades = new ArrayList<ISubTrade>();
        public int currentSubTrade = 0;

        public void receive(EntityPlayer player, NBTTagCompound nbt) {
            this.focus = null;
            this.tradeSlot = nbt.func_74762_e("Current");
            this.maxTradeSlot = nbt.func_74762_e("MaxTrades");
            if (nbt.func_74764_b("TradeData")) {
                this.focus = IC2.manager.createTradeFromNBT(nbt.func_74775_l("TradeData"));
            }
            this.subTrades.clear();
            if (this.focus != null) {
                this.subTrades.addAll(this.focus.getSubTrades(player.func_110124_au(), nbt.func_74767_n("IgnoreOwner")));
            }
            this.currentSubTrade = 0;
        }

        public void loadFromServer(ServerEntry entry) {
            this.focus = entry.getServerTrade();
            this.subTrades.clear();
            if (this.focus != null) {
                this.subTrades.addAll(this.focus.getSubTrades(entry.player.func_110124_au(), entry.ignoreOwner));
            }
            this.currentSubTrade = 0;
            this.tradeSlot = entry.currentView;
            this.maxTradeSlot = entry.possibleTrades.size();
        }

        public boolean hasSubTradeShown() {
            return this.currentSubTrade < this.subTrades.size();
        }

        public ISubTrade getSubTrade() {
            if (this.currentSubTrade < this.subTrades.size()) {
                return this.subTrades.get(this.currentSubTrade);
            }
            return null;
        }

        public boolean canMoveTrade(boolean up) {
            if (up) {
                return this.tradeSlot + 1 < this.maxTradeSlot;
            }
            return this.tradeSlot > 0;
        }

        public boolean canMoveSubTrade(boolean up) {
            if (up) {
                return this.currentSubTrade + 1 < this.subTrades.size();
            }
            return this.currentSubTrade > 0;
        }

        public void moveSubTrade(boolean up) {
            this.currentSubTrade = MathHelper.func_76125_a((int)(this.currentSubTrade + (up ? 1 : -1)), (int)0, (int)(this.subTrades.size() - 1));
        }
    }

    public static class ServerEntry {
        final EntityPlayer player;
        List<ITrade> possibleTrades = new ArrayList<ITrade>();
        int currentView = 0;
        boolean isDirty = true;
        boolean ignoreOwner;

        public ServerEntry(EntityPlayer thePlayer, boolean ignore) {
            this.player = thePlayer;
            this.ignoreOwner = ignore;
        }

        public void updateData(TileEntityTradeOMatBase trade) {
            this.currentView = 0;
            this.possibleTrades.clear();
            this.possibleTrades.addAll(trade.getTradesForPlayer(this.player.func_110124_au()));
            this.isDirty = false;
        }

        public void addTrades(List<ITrade> list) {
            this.currentView = 0;
            this.possibleTrades.clear();
            this.possibleTrades.addAll(list);
        }

        public void moveDir(int amount) {
            this.currentView = MathHelper.func_76125_a((int)(this.currentView + amount), (int)0, (int)(this.possibleTrades.size() - 1));
        }

        public void markDirty() {
            this.isDirty = true;
        }

        public boolean isDirty() {
            return this.isDirty;
        }

        public ITrade getServerTrade() {
            if (this.currentView < this.possibleTrades.size()) {
                return this.possibleTrades.get(this.currentView);
            }
            return null;
        }

        public boolean hasNoTrades() {
            return this.possibleTrades.isEmpty();
        }

        public NBTTagCompound getPacketNBT() {
            NBTTagCompound data;
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74768_a("Current", this.currentView);
            nbt.func_74768_a("MaxTrades", this.possibleTrades.size());
            nbt.func_74757_a("IgnoreOwner", this.ignoreOwner);
            if (this.currentView < this.possibleTrades.size() && !(data = IC2.manager.saveTradeToNBT(this.possibleTrades.get(this.currentView))).func_82582_d()) {
                nbt.func_74782_a("TradeData", (NBTBase)data);
            }
            return nbt;
        }
    }
}

