/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.personal.trades.energy.sub;

import ic2.api.classic.trading.trades.ISubTrade;
import ic2.api.classic.trading.trades.ITrade;
import ic2.core.block.personal.base.trades.builder.ItemTradeFabricator;
import ic2.core.block.personal.trades.energy.BasicCustomEnergyTrade;
import ic2.core.platform.lang.storage.Ic2GuiLang;
import ic2.core.platform.registry.Ic2Formatters;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.item.ItemStack;

public class BasicCustomEnergySubTrade
implements ISubTrade {
    BasicCustomEnergyTrade trade;

    public BasicCustomEnergySubTrade(BasicCustomEnergyTrade owner) {
        this.trade = owner;
    }

    @Override
    public ITrade getTrade() {
        return this.trade;
    }

    @Override
    public boolean canPerformTrade(UUID player) {
        return this.trade.canDoSubTrade(this, player);
    }

    @Override
    public List<ItemStack> getRequiredItems(UUID player) {
        int index = this.trade.getTradeSlot(this);
        if (index == -1) {
            return new ArrayList<ItemStack>();
        }
        return this.trade.inputs.get(index);
    }

    @Override
    public List<String> getToolTip() {
        ArrayList<String> list = new ArrayList<String>();
        int index = this.trade.getTradeSlot(this);
        if (index != -1) {
            ItemTradeFabricator.ItemTradeRules rule = this.trade.rules.get(index);
            if (rule.creative) {
                list.add(Ic2GuiLang.tradeInfinite.getLocalized());
            }
            if (rule.money) {
                list.add(Ic2GuiLang.tradeMoneyNeededTrade.getLocalizedFormatted(rule.moneyNeeded));
            } else {
                if (rule.useOreDictionary) {
                    list.add(Ic2GuiLang.tradeSupportsOre.getLocalized());
                }
                if (rule.ignoreNBT) {
                    list.add(Ic2GuiLang.tradeIgnoresNBT.getLocalized());
                }
            }
            if (rule.waitingAfterBuy) {
                list.add(Ic2GuiLang.tradeHasDelay.getLocalizedFormatted(this.formattedTime(rule.waitingTime)));
            }
            if (rule.tradeLimit) {
                list.add(Ic2GuiLang.tradeHasCap.getLocalizedFormatted(rule.limitPerPlayer));
            }
        }
        return list;
    }

    @Override
    public boolean isMoneyTrade() {
        int index = this.trade.getTradeSlot(this);
        if (index == -1) {
            return false;
        }
        return this.trade.rules.get((Object)Integer.valueOf((int)index)).money;
    }

    @Override
    public int getNeededMoney() {
        int index = this.trade.getTradeSlot(this);
        if (index == -1) {
            return 0;
        }
        return this.trade.rules.get((Object)Integer.valueOf((int)index)).moneyNeeded;
    }

    private String formattedTime(int time) {
        DecimalFormat form = Ic2Formatters.timeFormat;
        int delay = time / 20;
        int seconds = delay % 60;
        int minutes = delay / 60 % 60;
        int hours = delay / 3600 % 24;
        int days = delay / 86400;
        return "" + form.format(days) + ":" + form.format(hours) + ":" + form.format(minutes) + ":" + form.format(seconds);
    }
}

