/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.personal.trades.items;

import ic2.api.classic.item.ICoinItem;
import ic2.api.classic.trading.ITradeInventory;
import ic2.api.classic.trading.providers.IItemTradeProvider;
import ic2.api.classic.trading.providers.ITradeProvider;
import ic2.api.classic.trading.trades.IItemTrade;
import ic2.api.classic.trading.trades.IModifyableTrade;
import ic2.api.classic.trading.trades.ISubTrade;
import ic2.api.classic.trading.trades.ITrade;
import ic2.api.classic.trading.trades.TradeType;
import ic2.core.block.personal.base.trades.builder.ItemTradeFabricator;
import ic2.core.block.personal.base.trades.builder.TradeNeededComparer;
import ic2.core.block.personal.trades.items.sub.BasicCustomItemSubTrade;
import ic2.core.util.math.IntCounter;
import ic2.core.util.misc.StackUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.NonNullList;

public class BasicCustomItemTrade
implements IItemTrade,
IModifyableTrade<ItemStack> {
    UUID owner;
    public Map<Integer, List<ItemStack>> inputs = new HashMap<Integer, List<ItemStack>>();
    Map<Integer, List<ItemStack>> outputs = new HashMap<Integer, List<ItemStack>>();
    public Map<Integer, ItemTradeFabricator.ItemTradeRules> rules = new HashMap<Integer, ItemTradeFabricator.ItemTradeRules>();
    List<ISubTrade> subTrades = new ArrayList<ISubTrade>();
    Map<Integer, Map<UUID, IntCounter>> tradesDone = new HashMap<Integer, Map<UUID, IntCounter>>();
    Map<Integer, Map<UUID, Long>> lastTrades = new HashMap<Integer, Map<UUID, Long>>();

    public BasicCustomItemTrade() {
    }

    public BasicCustomItemTrade(UUID newOwner) {
        this.owner = newOwner;
    }

    public void addSlot(int slot, NonNullList<ItemStack> in, NonNullList<ItemStack> out) {
        ArrayList<ItemStack> input = new ArrayList<ItemStack>();
        ArrayList<ItemStack> output = new ArrayList<ItemStack>();
        for (int i = 0; i < 8; ++i) {
            ItemStack stack = (ItemStack)in.get(i);
            if (!stack.func_190926_b()) {
                input.add(stack.func_77946_l());
            }
            if ((stack = (ItemStack)out.get(i)).func_190926_b()) continue;
            output.add(stack.func_77946_l());
        }
        this.inputs.put(slot, input);
        this.outputs.put(slot, output);
    }

    public void addRules(int slot, ItemTradeFabricator.ItemTradeRules rule) {
        this.rules.put(slot, rule);
    }

    public void createSubTrades() {
        for (int i = 0; i < 3 && (this.rules.containsKey(i) || this.outputs.containsKey(i)); ++i) {
            this.subTrades.add(new BasicCustomItemSubTrade(this));
        }
    }

    @Override
    public boolean canAccessTrade(UUID player) {
        for (ISubTrade sub : this.subTrades) {
            if (!sub.canPerformTrade(player)) continue;
            return true;
        }
        return false;
    }

    @Override
    public TradeType getType() {
        return TradeType.Item;
    }

    @Override
    public List<ISubTrade> getSubTrades(UUID player, boolean ignoreOwner) {
        ArrayList<ISubTrade> trades = new ArrayList<ISubTrade>();
        for (ISubTrade sub : this.subTrades) {
            if ((ignoreOwner || !this.isOwner(player)) && !sub.canPerformTrade(player)) continue;
            trades.add(sub);
        }
        return trades;
    }

    @Override
    public ISubTrade getSubTradeFromSlot(int slot, UUID player, boolean ignoreOwner) {
        if (this.subTrades.size() > slot) {
            ISubTrade trade = this.subTrades.get(slot);
            if (ignoreOwner && !trade.canPerformTrade(player) || !ignoreOwner && !this.isOwner(player)) {
                return null;
            }
            return trade;
        }
        return null;
    }

    @Override
    public int getTradeSlot(ISubTrade sub) {
        return this.subTrades.indexOf(sub);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ActionResult<List<ItemStack>> trade(UUID player, ITradeProvider prov, ISubTrade trade, ITradeInventory inv, int limit) {
        int smallest;
        int index = this.subTrades.indexOf(trade);
        if (index == -1 || !(prov instanceof IItemTradeProvider) || limit < 1) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)EMPTY_LIST);
        }
        ItemTradeFabricator.ItemTradeRules rule = this.rules.get(index);
        if (rule.waitingAfterBuy && !this.hasEnoughDelay(index, player, rule.waitingTime, prov.getProviderWorld().func_82737_E())) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)EMPTY_LIST);
        }
        int n = smallest = rule.tradeLimit ? Math.min(rule.limitPerPlayer - this.getPlayerTradesDone(index, player), limit) : limit;
        if (smallest <= 0) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)EMPTY_LIST);
        }
        if (rule.waitingAfterBuy && smallest > 1) {
            smallest = 1;
        }
        LinkedHashMap<ItemStack, Integer> needs = new LinkedHashMap<ItemStack, Integer>();
        if (rule.money) {
            void var11_14;
            int totalMoneyValue = 0;
            boolean bl = false;
            while (var11_14 < inv.getSlotCount()) {
                ItemStack stack = inv.getItemStack((int)var11_14).func_77946_l();
                int value = this.getMoneyValue(stack, true);
                if (value > 0) {
                    this.addToOutputMap(needs, stack);
                    totalMoneyValue += value;
                }
                ++var11_14;
            }
            if ((totalMoneyValue /= rule.moneyNeeded) <= 0) {
                return new ActionResult(EnumActionResult.PASS, (Object)EMPTY_LIST);
            }
            if (totalMoneyValue < smallest) {
                smallest = totalMoneyValue;
            }
        } else {
            for (ItemStack itemStack : this.inputs.get(index)) {
                this.addToMap(needs, itemStack, rule.ignoreNBT);
            }
            for (Map.Entry entry : needs.entrySet()) {
                int count = inv.getItemCount(new TradeNeededComparer((ItemStack)entry.getKey(), rule.useOreDictionary, rule.ignoreNBT));
                if ((count /= ((Integer)entry.getValue()).intValue()) < 0) {
                    return new ActionResult(EnumActionResult.PASS, (Object)EMPTY_LIST);
                }
                if (count >= smallest) continue;
                smallest = count;
            }
        }
        int provided = this.getStockCount(trade, prov, player);
        if (provided <= 0) {
            return new ActionResult(EnumActionResult.PASS, (Object)EMPTY_LIST);
        }
        if (smallest > provided) {
            smallest = provided;
        }
        LinkedHashMap<ItemStack, Integer> linkedHashMap = new LinkedHashMap<ItemStack, Integer>();
        for (ItemStack stack : this.outputs.get(index)) {
            this.addToOutputMap(linkedHashMap, stack);
        }
        ArrayList<ItemStack> adding = new ArrayList<ItemStack>();
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        if (rule.money) {
            int totalMoney;
            int toAdd = totalMoney = rule.moneyNeeded * smallest;
            for (Map.Entry entry : needs.entrySet()) {
                if (totalMoney <= 0) break;
                totalMoney -= this.getMoneyValue(inv.removeItems(new TradeNeededComparer((ItemStack)entry.getKey(), false, false), (Integer)entry.getValue()));
            }
            if (totalMoney < 0) {
                int leftOver = Math.abs(totalMoney);
                List<ItemStack> list = prov.generateCoins(leftOver);
                for (ItemStack item : list) {
                    result.add(item.func_77946_l());
                }
            }
            adding.addAll(prov.generateCoins(toAdd));
        } else {
            for (Map.Entry in : needs.entrySet()) {
                adding.addAll(inv.removeItems(new TradeNeededComparer((ItemStack)in.getKey(), rule.useOreDictionary, rule.ignoreNBT), (Integer)in.getValue() * smallest));
            }
        }
        for (Map.Entry out : linkedHashMap.entrySet()) {
            if (rule.creative) {
                result.addAll(this.getStackAsList((ItemStack)out.getKey(), (Integer)out.getValue() * smallest));
                continue;
            }
            result.addAll(((IItemTradeProvider)prov).getNearbyItemStack(new TradeNeededComparer((ItemStack)out.getKey(), false, false), (Integer)out.getValue() * smallest, false));
        }
        if (rule.waitingAfterBuy) {
            this.updateDelay(index, player, prov.getProviderWorld().func_82737_E());
        }
        prov.onTradePerformed(player, trade, adding);
        this.addPlayerTradeAmount(index, player, smallest);
        return new ActionResult(EnumActionResult.SUCCESS, result);
    }

    public int getMoneyValue(ItemStack stack, boolean includeStack) {
        int value;
        if (stack.func_190926_b()) {
            return 0;
        }
        if (stack.func_77973_b() instanceof ICoinItem && (value = ((ICoinItem)stack.func_77973_b()).getMoneyValue(stack) * (includeStack ? stack.func_190916_E() : 1)) > 0) {
            return value;
        }
        return 0;
    }

    public int getMoneyValue(List<ItemStack> list) {
        if (list == null || list.isEmpty()) {
            return 0;
        }
        int totalMoney = 0;
        for (ItemStack stack : list) {
            totalMoney += this.getMoneyValue(stack, true);
        }
        return totalMoney;
    }

    private void addToOutputMap(Map<ItemStack, Integer> map, ItemStack compare) {
        for (Map.Entry<ItemStack, Integer> entry : map.entrySet()) {
            ItemStack stack = entry.getKey();
            if (!StackUtil.isStackEqual(stack, compare, false, false)) continue;
            entry.setValue(entry.getValue() + compare.func_190916_E());
            return;
        }
        map.put(compare, compare.func_190916_E());
    }

    private List<ItemStack> getStackAsList(ItemStack stack, int amount) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        while (amount > 0) {
            int thisTime = Math.min(stack.func_77976_d(), amount);
            list.add(StackUtil.copyWithSize(stack, thisTime));
            amount -= thisTime;
        }
        return list;
    }

    private void addToMap(Map<ItemStack, Integer> map, ItemStack compare, boolean ignoreNBT) {
        for (Map.Entry<ItemStack, Integer> entry : map.entrySet()) {
            ItemStack stack = entry.getKey();
            if (!StackUtil.isStackEqual(stack, compare, false, ignoreNBT)) continue;
            entry.setValue(entry.getValue() + compare.func_190916_E());
            return;
        }
        map.put(compare, compare.func_190916_E());
    }

    @Override
    public List<ItemStack> getTradeResults(ISubTrade sub) {
        int index = this.getTradeSlot(sub);
        if (index == -1) {
            return EMPTY_LIST;
        }
        return this.outputs.get(index);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) throws Exception {
        this.inputs.clear();
        this.outputs.clear();
        this.rules.clear();
        this.tradesDone.clear();
        this.lastTrades.clear();
        this.owner = nbt.func_186857_a("Owner");
        NBTTagList list = nbt.func_150295_c("MainData", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound data = list.func_150305_b(i);
            int slot = data.func_74762_e("Slot");
            this.loadItem(data.func_150295_c("Inputs", 10), slot, this.inputs);
            this.loadItem(data.func_150295_c("Outputs", 10), slot, this.outputs);
            this.loadLimits(slot, data.func_150295_c("Limits", 10));
            this.loadWaiting(slot, data.func_150295_c("Waiting", 10));
            ItemTradeFabricator.ItemTradeRules rule = new ItemTradeFabricator.ItemTradeRules();
            rule.load(data.func_74775_l("Rules"));
            this.rules.put(slot, rule);
        }
        this.createSubTrades();
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        NBTTagList entries = new NBTTagList();
        for (int i = 0; i < this.subTrades.size(); ++i) {
            NBTTagCompound data = new NBTTagCompound();
            data.func_74768_a("Slot", i);
            data.func_74782_a("Inputs", (NBTBase)this.saveItems(this.inputs.get(i)));
            data.func_74782_a("Outputs", (NBTBase)this.saveItems(this.outputs.get(i)));
            data.func_74782_a("Rules", (NBTBase)this.rules.get(i).save());
            data.func_74782_a("Limits", (NBTBase)this.saveLimits(i));
            data.func_74782_a("Waiting", (NBTBase)this.saveWaiting(i));
            entries.func_74742_a((NBTBase)data);
        }
        nbt.func_74782_a("MainData", (NBTBase)entries);
        nbt.func_186854_a("Owner", this.owner);
    }

    private NBTTagList saveWaiting(int slot) {
        if (!this.lastTrades.containsKey(slot)) {
            return new NBTTagList();
        }
        NBTTagList list = new NBTTagList();
        for (Map.Entry<UUID, Long> entry : this.lastTrades.get(slot).entrySet()) {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_186854_a("Key", entry.getKey());
            nbt.func_74772_a("Value", entry.getValue().longValue());
            list.func_74742_a((NBTBase)nbt);
        }
        return list;
    }

    private void loadWaiting(int slot, NBTTagList list) {
        if (list.func_82582_d()) {
            return;
        }
        HashMap<UUID, Long> data = new HashMap<UUID, Long>();
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound nbt = list.func_150305_b(i);
            data.put(nbt.func_186857_a("Key"), nbt.func_74763_f("Value"));
        }
        this.lastTrades.put(slot, data);
    }

    private NBTTagList saveLimits(int slot) {
        if (!this.tradesDone.containsKey(slot)) {
            return new NBTTagList();
        }
        NBTTagList list = new NBTTagList();
        for (Map.Entry<UUID, IntCounter> entry : this.tradesDone.get(slot).entrySet()) {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_186854_a("Key", entry.getKey());
            nbt.func_74768_a("Value", entry.getValue().getValue());
            list.func_74742_a((NBTBase)nbt);
        }
        return list;
    }

    private void loadLimits(int slot, NBTTagList list) {
        if (list.func_82582_d()) {
            return;
        }
        HashMap<UUID, IntCounter> data = new HashMap<UUID, IntCounter>();
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound nbt = list.func_150305_b(i);
            IntCounter count = new IntCounter(nbt.func_74762_e("Value"));
            count.setStartValue(0);
            data.put(nbt.func_186857_a("Key"), count);
        }
        this.tradesDone.put(slot, data);
    }

    private NBTTagList saveItems(List<ItemStack> list) {
        if (list == null || list.isEmpty()) {
            return new NBTTagList();
        }
        NBTTagList dataList = new NBTTagList();
        for (int i = 0; i < list.size(); ++i) {
            NBTTagCompound nbt = new NBTTagCompound();
            list.get(i).func_77955_b(nbt);
            dataList.func_74742_a((NBTBase)nbt);
        }
        return dataList;
    }

    private void loadItem(NBTTagList list, int slot, Map<Integer, List<ItemStack>> map) throws Exception {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (int i = 0; i < list.func_74745_c(); ++i) {
            ItemStack stack = new ItemStack(list.func_150305_b(i));
            if (stack.func_190926_b()) {
                throw new Exception("Null Item inside the Map");
            }
            items.add(stack);
        }
        map.put(slot, items);
    }

    @Override
    public ITrade<ItemStack> newInstance(UUID newOwner) {
        BasicCustomItemTrade newInstance = new BasicCustomItemTrade(newOwner);
        newInstance.inputs = new HashMap<Integer, List<ItemStack>>(this.inputs);
        newInstance.outputs = new HashMap<Integer, List<ItemStack>>(this.outputs);
        newInstance.rules = new HashMap<Integer, ItemTradeFabricator.ItemTradeRules>(this.rules);
        newInstance.createSubTrades();
        return newInstance;
    }

    @Override
    public void deleteSubTrade(ISubTrade sub) {
        int index = this.getTradeSlot(sub);
        if (index == -1) {
            return;
        }
        HashMap<ISubTrade, List[]> map = new HashMap<ISubTrade, List[]>();
        HashMap done = new HashMap();
        HashMap rule = new HashMap();
        HashMap last = new HashMap();
        for (int i = 0; i < this.subTrades.size(); ++i) {
            if (i == index) continue;
            ISubTrade id = this.subTrades.get(i);
            map.put(id, new List[]{this.inputs.get(i), this.outputs.get(i)});
            this.putIfNotNull(done, id, this.tradesDone.get(i));
            this.putIfNotNull(last, id, this.lastTrades.get(i));
            this.putIfNotNull(rule, id, this.rules.get(i));
        }
        this.inputs.clear();
        this.outputs.clear();
        this.subTrades.remove(index);
        this.rules.clear();
        this.tradesDone.clear();
        this.lastTrades.clear();
        for (Map.Entry entry : map.entrySet()) {
            ISubTrade id = (ISubTrade)entry.getKey();
            int newIndex = this.subTrades.indexOf(id);
            List[] array = (List[])entry.getValue();
            this.putIfNotNull(this.inputs, newIndex, array[0]);
            this.putIfNotNull(this.outputs, newIndex, array[1]);
            this.putIfNotNull(this.tradesDone, newIndex, done.get(id));
            this.putIfNotNull(this.lastTrades, newIndex, last.get(id));
            this.putIfNotNull(this.rules, newIndex, rule.get(id));
        }
    }

    private void putIfNotNull(Map map, Object key, Object value) {
        if (value == null) {
            return;
        }
        map.put(key, value);
    }

    public boolean isOwner(UUID check) {
        return this.owner != null && this.owner.equals(check);
    }

    public boolean canDoSubTrade(ISubTrade sub, UUID user) {
        IntCounter counter;
        Map<UUID, IntCounter> counts;
        int index = this.subTrades.indexOf(sub);
        if (index == -1) {
            return false;
        }
        ItemTradeFabricator.ItemTradeRules rule = this.rules.get(index);
        return !rule.tradeLimit || (counts = this.tradesDone.get(index)) == null || (counter = counts.get(user)) == null || counter.getValue() < rule.limitPerPlayer;
    }

    @Override
    public int getStockCount(ISubTrade trade, ITradeProvider prov, UUID player) {
        int smallest;
        int index = this.subTrades.indexOf(trade);
        if (index == -1 || !(prov instanceof IItemTradeProvider)) {
            return 0;
        }
        ItemTradeFabricator.ItemTradeRules rule = this.rules.get(index);
        int n = smallest = rule.tradeLimit ? rule.limitPerPlayer - this.getPlayerTradesDone(index, player) : Short.MAX_VALUE;
        if (smallest <= 0) {
            return 0;
        }
        if (rule.waitingAfterBuy) {
            smallest = 1;
            if (!this.hasEnoughDelay(index, player, rule.waitingTime, prov.getProviderWorld().func_82737_E())) {
                return 0;
            }
        }
        List<ItemStack> outputList = this.outputs.get(index);
        LinkedHashMap<ItemStack, Integer> outputNeeds = new LinkedHashMap<ItemStack, Integer>();
        for (ItemStack itemStack : outputList) {
            this.addToOutputMap(outputNeeds, itemStack);
        }
        if (outputNeeds.isEmpty()) {
            return 0;
        }
        if (rule.creative) {
            return smallest;
        }
        for (Map.Entry entry : outputNeeds.entrySet()) {
            int count = this.getTotalStackSize(((IItemTradeProvider)prov).getNearbyItemStack(new TradeNeededComparer((ItemStack)entry.getKey(), false, false), (Integer)entry.getValue() * Short.MAX_VALUE, true));
            if ((count /= ((Integer)entry.getValue()).intValue()) <= 0) {
                return 0;
            }
            if (count >= smallest) continue;
            smallest = count;
        }
        return smallest;
    }

    public int getPlayerTradesDone(int slot, UUID player) {
        IntCounter counter;
        Map<UUID, IntCounter> map = this.tradesDone.get(slot);
        if (map == null) {
            map = new HashMap<UUID, IntCounter>();
            this.tradesDone.put(slot, map);
        }
        if ((counter = map.get(player)) == null) {
            counter = new IntCounter();
            map.put(player, counter);
        }
        return counter.getValue();
    }

    public void addPlayerTradeAmount(int slot, UUID player, int amount) {
        IntCounter counter;
        Map<UUID, IntCounter> map = this.tradesDone.get(slot);
        if (map == null) {
            map = new HashMap<UUID, IntCounter>();
            this.tradesDone.put(slot, map);
        }
        if ((counter = map.get(player)) == null) {
            counter = new IntCounter();
            map.put(player, counter);
        }
        counter.increase(amount);
    }

    public boolean hasEnoughDelay(int slot, UUID player, int delay, long currentTime) {
        Map<UUID, Long> map = this.lastTrades.get(slot);
        if (map == null) {
            map = new HashMap<UUID, Long>();
            this.lastTrades.put(slot, map);
        }
        if (map.containsKey(player)) {
            return map.get(player) + (long)delay < currentTime;
        }
        return true;
    }

    public void updateDelay(int slot, UUID player, long time) {
        Map<UUID, Long> map = this.lastTrades.get(slot);
        if (map == null) {
            map = new HashMap<UUID, Long>();
            this.lastTrades.put(slot, map);
        }
        map.put(player, time);
    }

    public int getTotalStackSize(List<ItemStack> list) {
        if (list == null || list.isEmpty()) {
            return 0;
        }
        int total = 0;
        for (ItemStack stack : list) {
            total += stack.func_190916_E();
        }
        return total;
    }
}

