/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.wiring.container;

import baubles.api.BaublesApi;
import baubles.api.cap.IBaublesItemHandler;
import baubles.common.container.SlotBauble;
import ic2.core.block.base.tile.TileEntityElectricBlock;
import ic2.core.inventory.container.ContainerTileComponent;
import ic2.core.inventory.gui.GuiIC2;
import ic2.core.inventory.gui.components.special.EnergyStorageComp;
import ic2.core.inventory.slots.SlotArmor;
import ic2.core.inventory.slots.SlotCharge;
import ic2.core.inventory.slots.SlotDischarge;
import ic2.core.platform.registry.Ic2GuiComp;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.Slot;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ContainerElectricBlock
extends ContainerTileComponent<TileEntityElectricBlock> {
    public static final EntityEquipmentSlot[] VALID_EQUIPMENT_SLOTS = new EntityEquipmentSlot[]{EntityEquipmentSlot.HEAD, EntityEquipmentSlot.CHEST, EntityEquipmentSlot.LEGS, EntityEquipmentSlot.FEET};

    public ContainerElectricBlock(InventoryPlayer player, TileEntityElectricBlock block) {
        super(block);
        this.func_75146_a(new SlotCharge(block, block.tier, 0, 56, 17));
        this.func_75146_a(new SlotDischarge(block, block.tier, 1, 56, 53));
        if (Loader.isModLoaded((String)"baubles")) {
            this.loadBaubles(player.field_70458_d);
        }
        for (int i = 0; i < 4; ++i) {
            this.func_75146_a(new SlotArmor(player, 3 - i, VALID_EQUIPMENT_SLOTS[i], 8, 8 + i * 18));
        }
        this.addPlayerInventory(player);
        this.addComponent(new EnergyStorageComp(block));
    }

    @Optional.Method(modid="baubles")
    public void loadBaubles(EntityPlayer player) {
        IBaublesItemHandler handler = BaublesApi.getBaublesHandler((EntityPlayer)player);
        if (handler == null) {
            return;
        }
        int i = 0;
        for (int x = 0; x < 2; ++x) {
            for (int y = 0; y < 4 && i < 7; ++i, ++y) {
                this.func_75146_a((Slot)new SlotBauble(player, handler, i, -35 + x * 19, 8 + y * 18));
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onGuiLoaded(GuiIC2 gui) {
        gui.setMCOffset(Ic2GuiComp.energyStorageMCOffset);
    }

    @Override
    public int guiInventorySize() {
        return 2;
    }

    @Override
    public ResourceLocation getTexture() {
        return ((TileEntityElectricBlock)this.getGuiHolder()).getTexture();
    }

    @Override
    protected boolean moveIntoInventoryInverted() {
        return false;
    }
}

