/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.inventory.gui;

import ic2.core.inventory.container.ContainerComponent;
import ic2.core.inventory.gui.GuiIC2;
import ic2.core.inventory.gui.components.GuiComponent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;

public class GuiComponentContainer
extends GuiIC2 {
    protected List<GuiComponent>[] components = this.createComponents(GuiComponent.ActionRequest.values().length);

    public GuiComponentContainer(ContainerComponent container) {
        super(container, container.getTexture());
        this.setGuiName(container.getGuiName());
        this.registerComponents(container.getComponents());
        container.onGuiLoaded(this);
    }

    public void registerComponents(List<GuiComponent> components) {
        for (GuiComponent comp : components) {
            this.registerComponent(comp);
        }
    }

    public void registerComponent(GuiComponent comp) {
        for (GuiComponent.ActionRequest request : comp.getNeededRequests()) {
            this.components[request.ordinal()].add(comp);
        }
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        List<GuiComponent> compList = this.components[GuiComponent.ActionRequest.GuiInit.ordinal()];
        for (GuiComponent comp : compList) {
            if (!comp.isEnabled()) continue;
            comp.onGuiInit(this);
        }
    }

    @Override
    public void onGuiTick() {
        List<GuiComponent> compList = this.components[GuiComponent.ActionRequest.GuiTick.ordinal()];
        for (GuiComponent comp : compList) {
            if (!comp.isEnabled()) continue;
            comp.onGuiTick(this);
        }
    }

    @Override
    public void onPostDraw(int mouseX, int mouseY, float ticks) {
        int x = mouseX - this.getXOffset();
        int y = mouseY - this.getYOffset();
        List<GuiComponent> compList = this.components[GuiComponent.ActionRequest.PostDraw.ordinal()];
        for (GuiComponent comp : compList) {
            if (!comp.isEnabled()) continue;
            comp.postDraw(this, x, y);
        }
    }

    @Override
    public void onToolTipCollection(int mouseX, int mouseY, List<String> list) {
        int x = mouseX - this.getXOffset();
        int y = mouseY - this.getYOffset();
        List<GuiComponent> compList = this.components[GuiComponent.ActionRequest.ToolTip.ordinal()];
        for (GuiComponent comp : compList) {
            if (!comp.isEnabled() || !comp.isVisible()) continue;
            comp.onToolTipCollecting(this, x, y, list);
        }
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        int x = mouseX - this.getXOffset();
        int y = mouseY - this.getYOffset();
        List<GuiComponent> compList = this.components[GuiComponent.ActionRequest.FrontgroundDraw.ordinal()];
        for (GuiComponent comp : compList) {
            if (!comp.isEnabled()) continue;
            comp.drawFrontground(this, x, y);
        }
    }

    @Override
    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        super.func_146976_a(partialTicks, mouseX, mouseY);
        int x = mouseX - this.getXOffset();
        int y = mouseY - this.getYOffset();
        List<GuiComponent> compList = this.components[GuiComponent.ActionRequest.BackgroundDraw.ordinal()];
        for (GuiComponent comp : compList) {
            if (!comp.isEnabled()) continue;
            GlStateManager.func_179144_i((int)this.textureInstance.func_110552_b());
            comp.drawBackground(this, x, y, partialTicks);
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        int x = mouseX - this.getXOffset();
        int y = mouseY - this.getYOffset();
        List<GuiComponent> compList = this.components[GuiComponent.ActionRequest.MouseClick.ordinal()];
        for (GuiComponent comp : compList) {
            if (!comp.isEnabled() || !comp.isVisible() || !comp.isMouseOver(x, y) || !comp.onMouseClick(this, x, y, mouseButton)) continue;
            return;
        }
        super.func_73864_a(mouseX, mouseY, mouseButton);
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        List<GuiComponent> compList = this.components[GuiComponent.ActionRequest.KeyPressed.ordinal()];
        for (GuiComponent comp : compList) {
            if (!comp.isEnabled() || !comp.onKeyTyped(this, typedChar, keyCode)) continue;
            return;
        }
        super.func_73869_a(typedChar, keyCode);
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        List<GuiComponent> compList = this.components[GuiComponent.ActionRequest.ButtonNotify.ordinal()];
        for (GuiComponent comp : compList) {
            if (!comp.isEnabled()) continue;
            comp.onButtonClick(this, button);
        }
    }

    private List<GuiComponent>[] createComponents(int count) {
        List[] result = new List[count];
        for (int i = 0; i < count; ++i) {
            result[i] = new ArrayList();
        }
        return result;
    }
}

