/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.inventory.gui.components.reactorPlanner;

import ic2.core.block.machine.med.TileEntityReactorPlanner;
import ic2.core.block.machine.med.logic.TickingReactorLogic;
import ic2.core.block.machine.med.logic.TickingSteamReactorLogic;
import ic2.core.inventory.gui.GuiIC2;
import ic2.core.inventory.gui.components.GuiComponent;
import ic2.core.inventory.gui.components.reactorPlanner.ReactorPlannerPageBaseComp;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2GuiLang;
import ic2.core.platform.registry.Ic2GuiComp;
import ic2.core.platform.registry.Ic2Items;
import java.util.Arrays;
import java.util.List;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ReactorPlannerPageOneComp
extends ReactorPlannerPageBaseComp {
    public ReactorPlannerPageOneComp(TileEntityReactorPlanner tile) {
        super(Ic2GuiComp.reactorPlannerPageOne, 1, Ic2Items.nuclearReactor.func_77946_l(), tile);
    }

    @Override
    public LocaleComp getName() {
        return Ic2GuiLang.reactorSetupInfo;
    }

    @Override
    public List<GuiComponent.ActionRequest> getNeededRequests() {
        return Arrays.asList(GuiComponent.ActionRequest.BackgroundDraw, GuiComponent.ActionRequest.FrontgroundDraw, GuiComponent.ActionRequest.MouseClick, GuiComponent.ActionRequest.ToolTip);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawFrontground(GuiIC2 gui, int mouseX, int mouseY) {
        if (!this.isPageSelected()) {
            return;
        }
        if (this.planner.isSteamReactor) {
            boolean cooling;
            TickingSteamReactorLogic.SteamReactorPrediction predict = (TickingSteamReactorLogic.SteamReactorPrediction)this.planner.getPrediction();
            int excess = predict.heatPerTick - predict.coolingPerTick;
            boolean bl = cooling = excess < 0;
            if (cooling) {
                excess = -excess;
            }
            gui.drawString(Ic2GuiLang.expectedHeat.getLocalizedFormatted(predict.heatPerTick), 5, 130, 0x404040);
            gui.drawString(Ic2GuiLang.expectedSteamProduction.getLocalizedFormatted(format.format(predict.steamPerTick)), 5, 140, 0x404040);
            gui.drawString(Ic2GuiLang.expectedVentCooling.getLocalizedFormatted(predict.coolingPerTick), 5, 150, 0x404040);
            gui.drawString(Ic2GuiLang.expectedReactorCooling.getLocalizedFormatted(predict.reactorCoolingPerTick), 5, 160, 0x404040);
            gui.drawString((cooling ? Ic2GuiLang.excessCooling : Ic2GuiLang.excessHeating).getLocalizedFormatted(excess), 5, 170, 0x404040);
        } else {
            boolean cooling;
            TickingReactorLogic.ReactorPrediction predict = (TickingReactorLogic.ReactorPrediction)this.planner.getPrediction();
            int excess = predict.heatPerTick - predict.coolingPerTick;
            boolean bl = cooling = excess < 0;
            if (cooling) {
                excess = -excess;
            }
            gui.drawString(Ic2GuiLang.expectedHeat.getLocalizedFormatted(predict.heatPerTick), 5, 130, 0x404040);
            gui.drawString(Ic2GuiLang.expectedHeatPackHeat.getLocalizedFormatted(format.format(predict.heatPackHeatPerTick)), 5, 140, 0x404040);
            gui.drawString(Ic2GuiLang.expectedVentCooling.getLocalizedFormatted(predict.coolingPerTick), 5, 150, 0x404040);
            gui.drawString(Ic2GuiLang.expectedReactorCooling.getLocalizedFormatted(predict.reactorCoolingPerTick), 5, 160, 0x404040);
            gui.drawString((cooling ? Ic2GuiLang.excessCooling : Ic2GuiLang.excessHeating).getLocalizedFormatted(excess), 5, 170, 0x404040);
        }
    }
}

