/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.sounds;

import ic2.core.IC2;
import ic2.core.audio.AudioSource;
import ic2.core.audio.ISoundTracker;
import ic2.core.inventory.base.IHasInventory;
import ic2.core.item.armor.base.ItemArmorJetpackBase;
import ic2.core.util.obj.plugins.IBaublesPlugin;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class JetpackTrackHandler
implements ISoundTracker {
    Item item = Items.field_190931_a;
    EntityPlayer player;
    int index = 0;
    int lastMode = 2;
    AudioSource source;

    public JetpackTrackHandler(EntityPlayer entity) {
        this.player = entity;
    }

    @Override
    public void onTick() {
        if (this.index == 0) {
            IHasInventory inventory;
            ItemStack stack = this.player.func_184582_a(EntityEquipmentSlot.CHEST);
            ItemArmorJetpackBase jetpack = this.getJetpack(stack);
            if (jetpack != null) {
                this.index = 1;
                this.item = jetpack;
                int newMode = jetpack.getJetpackUse(stack);
                if (newMode != this.lastMode && newMode < 2) {
                    this.source = jetpack.createAudioSource(stack, this.player, ItemArmorJetpackBase.JetpackUseMode.values()[newMode]);
                    if (this.source != null) {
                        this.source.play();
                    }
                }
                this.lastMode = newMode;
                return;
            }
            IBaublesPlugin plugin = IC2.loader.getPlugin("baubles", IBaublesPlugin.class);
            if (plugin != null && (inventory = plugin.getBaublesInventory(this.player)) != null && (jetpack = this.getJetpack(stack = inventory.getStackInSlot(plugin.getArmorSlot()))) != null) {
                this.index = 2;
                this.item = jetpack;
                int newMode = jetpack.getJetpackUse(stack);
                if (newMode != this.lastMode && newMode < 2) {
                    this.source = jetpack.createAudioSource(stack, this.player, ItemArmorJetpackBase.JetpackUseMode.values()[newMode]);
                    if (this.source != null) {
                        this.source.play();
                    }
                }
                this.lastMode = newMode;
            }
        } else {
            int currentUse;
            ItemStack stack = this.getInventoryStack();
            if (stack.func_190926_b()) {
                this.index = 0;
                this.item = Items.field_190931_a;
                this.lastMode = 0;
                if (this.source != null) {
                    this.source.remove();
                    this.source = null;
                }
                return;
            }
            ItemArmorJetpackBase jetpack = this.getJetpack(stack);
            if (jetpack == null) {
                this.index = 0;
                this.item = Items.field_190931_a;
                this.lastMode = 0;
                if (this.source != null) {
                    this.source.remove();
                    this.source = null;
                }
                return;
            }
            if (jetpack != this.item) {
                this.index = 0;
                this.item = Items.field_190931_a;
                this.lastMode = 0;
                if (this.source != null) {
                    this.source.remove();
                    this.source = null;
                }
                return;
            }
            if (this.source != null && this.source.isRemoved()) {
                this.lastMode = -1;
            }
            if ((currentUse = jetpack.getJetpackUse(stack)) != this.lastMode) {
                this.lastMode = currentUse;
                if (this.source != null) {
                    this.source.remove();
                }
                if (this.lastMode >= 2) {
                    return;
                }
                this.source = jetpack.createAudioSource(stack, this.player, ItemArmorJetpackBase.JetpackUseMode.values()[this.lastMode]);
                if (this.source != null) {
                    this.source.play();
                }
            }
        }
    }

    @Override
    public boolean isValid(World world) {
        return this.player.func_130014_f_() == world && !this.player.field_70128_L;
    }

    public ItemStack getInventoryStack() {
        IHasInventory inventory;
        if (this.index == 0) {
            return ItemStack.field_190927_a;
        }
        if (this.index == 1) {
            return this.player.func_184582_a(EntityEquipmentSlot.CHEST);
        }
        IBaublesPlugin plugin = IC2.loader.getPlugin("baubles", IBaublesPlugin.class);
        if (plugin != null && (inventory = plugin.getBaublesInventory(this.player)) != null) {
            return inventory.getStackInSlot(plugin.getArmorSlot());
        }
        return ItemStack.field_190927_a;
    }

    public ItemArmorJetpackBase getJetpack(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        if (stack.func_77973_b() instanceof ItemArmorJetpackBase.IIndirectJetpack) {
            return ((ItemArmorJetpackBase.IIndirectJetpack)stack.func_77973_b()).getJetpack();
        }
        if (stack.func_77973_b() instanceof ItemArmorJetpackBase) {
            return (ItemArmorJetpackBase)stack.func_77973_b();
        }
        return null;
    }
}

