/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.items.teleportprobe;

import io.netty.buffer.ByteBuf;
import mcjty.lib.network.NetworkTools;
import mcjty.rftools.RFTools;
import mcjty.rftools.items.teleportprobe.GuiAdvancedPorter;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketTargetsReady
implements IMessage {
    private int target;
    private int[] targets;
    private String[] names;

    public void fromBytes(ByteBuf buf) {
        this.target = buf.readInt();
        int size = buf.readInt();
        this.targets = new int[size];
        this.names = new String[size];
        for (int i = 0; i < size; ++i) {
            this.targets[i] = buf.readInt();
            this.names[i] = NetworkTools.readString((ByteBuf)buf);
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.target);
        buf.writeInt(this.targets.length);
        for (int i = 0; i < this.targets.length; ++i) {
            buf.writeInt(this.targets[i]);
            NetworkTools.writeString((ByteBuf)buf, (String)this.names[i]);
        }
    }

    public PacketTargetsReady() {
    }

    public PacketTargetsReady(int target, int[] targets, String[] names) {
        this.target = target;
        this.targets = targets;
        this.names = names;
    }

    public static class Handler
    implements IMessageHandler<PacketTargetsReady, IMessage> {
        public IMessage onMessage(PacketTargetsReady message, MessageContext ctx) {
            RFTools.proxy.addScheduledTaskClient(() -> this.handle(message, ctx));
            return null;
        }

        private void handle(PacketTargetsReady message, MessageContext ctx) {
            GuiAdvancedPorter.setInfo(message.target, message.targets, message.names);
        }
    }
}

