/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.util.bbcode;

import java.util.LinkedList;
import java.util.List;
import joptsimple.internal.Strings;
import net.malisis.core.client.gui.GuiRenderer;
import net.malisis.core.util.bbcode.BBCodeParser;
import net.malisis.core.util.bbcode.node.BBNode;
import net.malisis.core.util.bbcode.node.BBRootNode;
import net.malisis.core.util.bbcode.node.BBTextNode;
import net.malisis.core.util.bbcode.render.BBCodeRenderer;
import net.malisis.core.util.bbcode.render.IBBCodeRenderer;
import org.apache.commons.lang3.StringUtils;

public class BBString {
    private String text;
    private BBNode rootNode = new BBRootNode();
    private List<BBTextNode> textNodes = new LinkedList<BBTextNode>();
    private BBCodeRenderer renderer;

    public BBString() {
        this.setText("");
    }

    public BBString(String text) {
        this();
        this.setText(text);
        this.renderer = new BBCodeRenderer(this);
    }

    public void setText(String text) {
        this.text = text == null ? "" : text;
    }

    public String getText() {
        return this.text;
    }

    public BBNode getRoot() {
        return this.rootNode;
    }

    public String getRawText() {
        return this.getRoot().toRawString();
    }

    public String getBBString() {
        return this.getRoot().toBBString();
    }

    public void parseText() {
        new BBCodeParser(this).parse();
        this.buildTextNodeList(this.getRoot());
    }

    private void buildTextNodeList(BBNode node) {
        if (node == this.getRoot()) {
            this.textNodes.clear();
        }
        for (BBNode n : node) {
            if (n instanceof BBTextNode) {
                this.textNodes.add((BBTextNode)n);
                continue;
            }
            this.buildTextNodeList(n);
        }
    }

    public void insertNode(BBNode node, int start, int end) {
        for (BBTextNode tn : this.textNodes) {
            if (!tn.isInRange(start, end)) continue;
            BBNode copy = node.copy();
            BBNode parent = tn.getParent();
            String newText = tn.delete(start, end);
            BBTextNode[] split = tn.split(start);
            if (split == null) continue;
            if (!node.isStandAlone() && !StringUtils.isEmpty((CharSequence)newText)) {
                BBTextNode newTextNode = new BBTextNode(newText);
                newTextNode.setIndex(start);
                split[1].shiftIndex(newText.length());
                copy.insert(newTextNode);
            }
            parent.insertBefore(split[0], tn);
            parent.insertBefore(copy, tn);
            parent.insertBefore(split[1], tn);
            parent.remove(tn);
        }
        this.clean();
    }

    public void addText(String txt, int position) {
        if (this.textNodes.size() == 0) {
            this.getRoot().insert(new BBTextNode(txt));
            this.buildTextNodeList(this.getRoot());
            return;
        }
        int shift = 0;
        for (BBTextNode tn : this.textNodes) {
            tn.shiftIndex(shift);
            shift += tn.insert(position, txt);
        }
    }

    public void deleteText(int start, int end) {
        int shift = 0;
        for (BBTextNode tn : this.textNodes) {
            tn.shiftIndex(shift);
            int amount = -tn.delete(start, end).length();
            shift += amount;
        }
        this.clean();
    }

    public void clean() {
        this.getRoot().clean();
        this.buildTextNodeList(this.getRoot());
    }

    public void buildRenderLines(List<String> lines) {
        this.renderer.buildLines(lines);
    }

    public void render(GuiRenderer guiRenderer, int x, int y, int z, IBBCodeRenderer<?> bbcr) {
        this.renderer.render(guiRenderer, x, y, z, bbcr);
    }

    public String debug(BBNode node, int level) {
        String str = Strings.repeat((char)' ', (int)(level * 3)) + node.toString() + "\n";
        for (BBNode n : node) {
            str = str + this.debug(n, level + 1);
        }
        return str;
    }

    public String printTextNodes() {
        return this.textNodes.toString();
    }

    public String toString() {
        String str = this.text + "\n" + this.debug(this.getRoot(), 0);
        return str;
    }
}

