/*
 * Decompiled with CFR 0.152.
 */
package gcewing.sg;

import gcewing.sg.BaseMod;
import gcewing.sg.BaseModClient;
import gcewing.sg.BaseUtils;
import gcewing.sg.Trans3;
import gcewing.sg.Vector3;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleDigging;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BaseBlock<TE extends TileEntity>
extends BlockContainer
implements BaseMod.IBlock {
    public static boolean debugState = false;
    public static IOrientationHandler orient1Way = new Orient1Way();
    protected MapColor mapColor;
    protected IProperty[] properties;
    protected Object[][] propertyValues;
    protected int numProperties;
    protected EnumBlockRenderType renderID = EnumBlockRenderType.MODEL;
    protected Class<? extends TileEntity> tileEntityClass = null;
    protected IOrientationHandler orientationHandler = orient1Way;
    protected String[] textureNames;
    protected BaseMod.ModelSpec modelSpec;
    protected BaseMod mod;
    protected AxisAlignedBB boxHit;
    protected ThreadLocal<TileEntity> harvestingTileEntity = new ThreadLocal();

    public BaseBlock(Material material) {
        this(material, null, null, null);
    }

    public BaseBlock(Material material, IOrientationHandler orient) {
        this(material, orient, null, null);
    }

    public BaseBlock(Material material, Class<TE> teClass) {
        this(material, null, teClass, null);
    }

    public BaseBlock(Material material, IOrientationHandler orient, Class<TE> teClass) {
        this(material, orient, teClass, null);
    }

    public BaseBlock(Material material, Class<TE> teClass, String teID) {
        this(material, null, teClass, teID);
    }

    public BaseBlock(Material material, IOrientationHandler orient, Class<TE> teClass, String teID) {
        super(material);
        if (orient == null) {
            orient = orient1Way;
        }
        this.orientationHandler = orient;
        if (teClass.getName().equalsIgnoreCase("gcewing.sg.tileentity.DHDTE")) {
            teID = "gcewing.sg.DHDTE";
        }
        if (teClass.getName().equalsIgnoreCase("gcewing.sg.tileentity.PowerTE")) {
            teID = "gcewing.sg.PowerTE";
        }
        if (teClass.getName().equalsIgnoreCase("gcewing.sg.tileentity.SGBaseTE")) {
            teID = "gcewing.sg.SGBaseTE";
        }
        if (teClass.getName().equalsIgnoreCase("gcewing.sg.tileentity.SGInterfaceTE")) {
            teID = "gcewing.sg.SGInterfaceTE";
        }
        if (teClass.getName().equalsIgnoreCase("gcewing.sg.tileentity.SGRingTE")) {
            teID = "gcewing.sg.SGRingTE";
        }
        if (teClass.getName().equalsIgnoreCase("gcewing.sg.tileentity.SGPowerTE")) {
            teID = "gcewing.sg.SGPowerTE";
        }
        if (teClass.getName().equalsIgnoreCase("gcewing.sg.features.ic2.IC2PowerTE")) {
            teID = "gcewing.sg.ic2.IC2PowerTE";
        }
        if (teClass.getName().equalsIgnoreCase("gcewing.sg.features.cc.CCInterfaceTE")) {
            teID = "gcewing.sg.cc.CCInterfaceTE";
        }
        if (teClass.getName().equalsIgnoreCase("gcewing.sg.features.oc.OCInterfaceTE")) {
            teID = "gcewing.sg.oc.OCInterfaceTE";
        }
        if (teClass.getName().equalsIgnoreCase("gcewing.sg.features.ic2.zpm.ZPMInterfaceCartTE")) {
            teID = "gcewing.sg.ic2.zpm.ZPMInterfaceCartTE";
        }
        this.tileEntityClass = teClass;
        if (teClass != null) {
            if (teID == null) {
                teID = teClass.getName();
            }
            try {
                GameRegistry.registerTileEntity(teClass, (String)teID);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    public IOrientationHandler getOrientationHandler() {
        return orient1Way;
    }

    protected void defineProperties() {
        this.properties = new IProperty[4];
        this.propertyValues = new Object[4][];
        this.getOrientationHandler().defineProperties(this);
    }

    protected void addProperty(IProperty property) {
        if (debugState) {
            System.out.printf("BaseBlock.addProperty: %s to %s\n", property, this.getClass().getName());
        }
        if (this.numProperties >= 4) {
            throw new IllegalStateException("Block " + this.getClass().getName() + " has too many properties");
        }
        int i = this.numProperties++;
        this.properties[i] = property;
        Object[] values = BaseUtils.arrayOf(property.func_177700_c());
        this.propertyValues[i] = values;
        if (debugState) {
            System.out.printf("BaseBlock.addProperty: %s now has %s properties\n", this.getClass().getName(), this.numProperties);
        }
    }

    protected BlockStateContainer func_180661_e() {
        if (debugState) {
            System.out.printf("BaseBlock.createBlockState: Defining properties\n", new Object[0]);
        }
        this.defineProperties();
        if (debugState) {
            this.dumpProperties();
        }
        this.checkProperties();
        IProperty[] props = Arrays.copyOf(this.properties, this.numProperties);
        if (debugState) {
            System.out.printf("BaseBlock.createBlockState: Creating BlockState with %s properties\n", props.length);
        }
        return new BlockStateContainer((Block)this, props);
    }

    private void dumpProperties() {
        System.out.printf("BaseBlock: Properties of %s:\n", this.getClass().getName());
        for (int i = 0; i < this.numProperties; ++i) {
            System.out.printf("%s: %s\n", i, this.properties[i]);
            Object[] values = this.propertyValues[i];
            for (int j = 0; j < values.length; ++j) {
                System.out.printf("   %s: %s\n", j, values[j]);
            }
        }
    }

    protected void checkProperties() {
        int n = 1;
        for (int i = 0; i < this.numProperties; ++i) {
            n *= this.propertyValues[i].length;
        }
        if (n > 16) {
            throw new IllegalStateException(String.format("Block %s has %s combinations of property values (16 allowed)", this.getClass().getName(), n));
        }
    }

    public int func_176201_c(IBlockState state) {
        int meta = 0;
        for (int i = this.numProperties - 1; i >= 0; --i) {
            int k;
            Comparable value = state.func_177229_b(this.properties[i]);
            Object[] values = this.propertyValues[i];
            for (k = values.length - 1; k > 0 && !values[k].equals(value); --k) {
            }
            if (debugState) {
                System.out.printf("BaseBlock.getMetaFromState: property %s value %s --> %s of %s\n", i, value, k, values.length);
            }
            meta = meta * values.length + k;
        }
        if (debugState) {
            System.out.printf("BaseBlock.getMetaFromState: %s --> %s\n", state, meta);
        }
        return meta & 0xF;
    }

    public IBlockState func_176203_a(int meta) {
        IBlockState state = this.func_176223_P();
        int m = meta;
        for (int i = this.numProperties - 1; i >= 0; --i) {
            Object[] values = this.propertyValues[i];
            int n = values.length;
            int k = m % n;
            m /= n;
            state = state.func_177226_a(this.properties[i], (Comparable)values[k]);
        }
        if (debugState) {
            System.out.printf("BaseBlock.getStateFromMeta: %s --> %s\n", meta, state);
        }
        return state;
    }

    @Override
    public int getNumSubtypes() {
        return 1;
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity te, ItemStack stack) {
        this.harvestingTileEntity.set(te);
        super.func_180657_a(world, player, pos, state, te, stack);
        this.harvestingTileEntity.set(null);
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        TileEntity te = world.func_175625_s(pos);
        if (te == null) {
            te = this.harvestingTileEntity.get();
        }
        return this.getDropsFromTileEntity(world, pos, state, te, fortune);
    }

    protected List<ItemStack> getDropsFromTileEntity(IBlockAccess world, BlockPos pos, IBlockState state, TileEntity te, int fortune) {
        return super.getDrops(world, pos, state, fortune);
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return this.renderID;
    }

    @Override
    public String getQualifiedRendererClassName() {
        String name = this.getRendererClassName();
        if (name != null) {
            // empty if block
        }
        return name;
    }

    protected String getRendererClassName() {
        return null;
    }

    public void setModelAndTextures(String modelName, String ... textureNames) {
        this.textureNames = textureNames;
        this.modelSpec = new BaseMod.ModelSpec(modelName, textureNames);
    }

    public void setModelAndTextures(String modelName, Vector3 origin, String ... textureNames) {
        this.textureNames = textureNames;
        this.modelSpec = new BaseMod.ModelSpec(modelName, origin, textureNames);
    }

    @Override
    public String[] getTextureNames() {
        return this.textureNames;
    }

    @Override
    public BaseMod.ModelSpec getModelSpec(IBlockState state) {
        return this.modelSpec;
    }

    public Trans3 localToGlobalRotation(IBlockAccess world, BlockPos pos) {
        return this.localToGlobalRotation(world, pos, world.func_180495_p(pos));
    }

    public Trans3 localToGlobalRotation(IBlockAccess world, BlockPos pos, IBlockState state) {
        return this.localToGlobalTransformation(world, pos, state, Vector3.zero);
    }

    public Trans3 localToGlobalTransformation(IBlockAccess world, BlockPos pos) {
        return this.localToGlobalTransformation(world, pos, world.func_180495_p(pos));
    }

    public Trans3 localToGlobalTransformation(IBlockAccess world, BlockPos pos, IBlockState state) {
        return this.localToGlobalTransformation(world, pos, state, Vector3.blockCenter(pos));
    }

    @Override
    public Trans3 localToGlobalTransformation(IBlockAccess world, BlockPos pos, IBlockState state, Vector3 origin) {
        IOrientationHandler oh = this.getOrientationHandler();
        return oh.localToGlobalTransformation(world, pos, state, origin);
    }

    @Override
    public Trans3 itemTransformation() {
        return Trans3.ident;
    }

    public boolean hasTileEntity(IBlockState state) {
        return this.tileEntityClass != null;
    }

    public TE getTileEntity(IBlockAccess world, BlockPos pos) {
        if (this.func_149716_u()) {
            return (TE)world.func_175625_s(pos);
        }
        return null;
    }

    public TileEntity func_149915_a(World world, int meta) {
        if (this.tileEntityClass != null) {
            try {
                return this.tileEntityClass.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        IBlockState state = this.getOrientationHandler().onBlockPlaced((Block)this, world, pos, side, hitX, hitY, hitZ, this.func_176203_a(meta), placer);
        return state;
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        TE te;
        super.func_176213_c(world, pos, state);
        if (this.hasTileEntity(state) && (te = this.getTileEntity((IBlockAccess)world, pos)) instanceof BaseMod.ITileEntity) {
            ((BaseMod.ITileEntity)te).onAddedToWorld();
        }
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity te;
        if (this.hasTileEntity(state) && (te = world.func_175625_s(pos)) instanceof IInventory) {
            InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)((IInventory)te));
        }
    }

    public boolean addLandingEffects(IBlockState state, WorldServer world, BlockPos pos, IBlockState iblockstate, EntityLivingBase entity, int numParticles) {
        IBlockState particleState = this.getParticleState((IBlockAccess)world, pos);
        world.func_175739_a(EnumParticleTypes.BLOCK_DUST, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, numParticles, 0.0, 0.0, 0.0, 0.15, new int[]{Block.func_176210_f((IBlockState)particleState)});
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(IBlockState blockState, World world, RayTraceResult target, ParticleManager pm) {
        BlockPos pos = target.func_178782_a();
        IBlockState state = this.getParticleState((IBlockAccess)world, pos);
        int i = pos.func_177958_n();
        int j = pos.func_177956_o();
        int k = pos.func_177952_p();
        AxisAlignedBB boundingBox = blockState.func_185900_c((IBlockAccess)world, pos);
        float f = 0.1f;
        double d0 = (double)i + RANDOM.nextDouble() * (boundingBox.field_72336_d - boundingBox.field_72340_a - (double)(f * 2.0f)) + (double)f + boundingBox.field_72340_a;
        double d1 = (double)j + RANDOM.nextDouble() * (boundingBox.field_72337_e - boundingBox.field_72338_b - (double)(f * 2.0f)) + (double)f + boundingBox.field_72338_b;
        double d2 = (double)k + RANDOM.nextDouble() * (boundingBox.field_72334_f - boundingBox.field_72339_c - (double)(f * 2.0f)) + (double)f + boundingBox.field_72339_c;
        switch (target.field_178784_b) {
            case DOWN: {
                d1 = (double)j + boundingBox.field_72338_b - (double)f;
                break;
            }
            case UP: {
                d1 = (double)j + boundingBox.field_72337_e + (double)f;
                break;
            }
            case NORTH: {
                d2 = (double)k + boundingBox.field_72339_c - (double)f;
                break;
            }
            case SOUTH: {
                d2 = (double)k + boundingBox.field_72334_f + (double)f;
                break;
            }
            case WEST: {
                d0 = (double)i + boundingBox.field_72340_a - (double)f;
                break;
            }
            case EAST: {
                d0 = (double)i + boundingBox.field_72336_d + (double)f;
            }
        }
        DiggingFX fx = new DiggingFX(world, d0, d1, d2, 0.0, 0.0, 0.0, state);
        pm.func_78873_a(fx.func_174846_a(pos).func_70543_e(0.2f).func_70541_f(0.6f));
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, BlockPos pos, ParticleManager pm) {
        IBlockState state = this.getParticleState((IBlockAccess)world, pos);
        int b0 = 4;
        for (int i = 0; i < b0; ++i) {
            for (int j = 0; j < b0; ++j) {
                for (int k = 0; k < b0; ++k) {
                    double d0 = (double)pos.func_177958_n() + ((double)i + 0.5) / (double)b0;
                    double d1 = (double)pos.func_177956_o() + ((double)j + 0.5) / (double)b0;
                    double d2 = (double)pos.func_177952_p() + ((double)k + 0.5) / (double)b0;
                    DiggingFX fx = new DiggingFX(world, d0, d1, d2, d0 - (double)pos.func_177958_n() - 0.5, d1 - (double)pos.func_177956_o() - 0.5, d2 - (double)pos.func_177952_p() - 0.5, state);
                    pm.func_78873_a((Particle)fx.func_174846_a(pos));
                }
            }
        }
        return true;
    }

    @Override
    public IBlockState getParticleState(IBlockAccess world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        return this.func_176221_a(state, world, pos);
    }

    public RayTraceResult func_180636_a(IBlockState state, World world, BlockPos pos, Vec3d start, Vec3d end) {
        this.boxHit = null;
        RayTraceResult result = null;
        double nearestDistance = 0.0;
        List<AxisAlignedBB> list = this.getGlobalCollisionBoxes((IBlockAccess)world, pos, state, null);
        if (list != null) {
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                AxisAlignedBB box = list.get(i);
                RayTraceResult mp = box.func_72327_a(start, end);
                if (mp == null) continue;
                mp.subHit = i;
                double d = start.func_72436_e(mp.field_72307_f);
                if (result != null && !(d < nearestDistance)) continue;
                result = mp;
                nearestDistance = d;
            }
        }
        if (result != null) {
            int i = result.subHit;
            this.boxHit = list.get(i).func_72317_d((double)(-pos.func_177958_n()), (double)(-pos.func_177956_o()), (double)(-pos.func_177952_p()));
            result = new RayTraceResult(result.field_72307_f, result.field_178784_b, pos);
            result.subHit = i;
        }
        return result;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        AxisAlignedBB box = this.boxHit;
        if (box == null) {
            box = this.getLocalBounds(world, pos, state, null);
        }
        if (box != null) {
            return box;
        }
        return super.func_185496_a(state, world, pos);
    }

    public AxisAlignedBB getCollisionBoundingBox(IBlockState state, World world, BlockPos pos) {
        return this.func_185496_a(state, (IBlockAccess)world, pos);
    }

    protected AxisAlignedBB getLocalBounds(IBlockAccess world, BlockPos pos, IBlockState state, Entity entity) {
        BaseMod.ModelSpec spec = this.getModelSpec(state);
        if (spec != null) {
            BaseModClient.IModel model = this.mod.getModel(spec.modelName);
            Trans3 t = this.localToGlobalTransformation(world, pos, state, Vector3.blockCenter).translate(spec.origin);
            return t.t(model.getBounds());
        }
        return null;
    }

    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB clip, List result, Entity entity, boolean enableStats) {
        List<AxisAlignedBB> list = this.getGlobalCollisionBoxes((IBlockAccess)world, pos, state, entity);
        if (list != null) {
            for (AxisAlignedBB box : list) {
                if (clip.func_72326_a(box)) {
                    result.add(box);
                    continue;
                }
                super.func_185477_a(state, world, pos, clip, result, entity, enableStats);
            }
        }
    }

    protected List<AxisAlignedBB> getGlobalCollisionBoxes(IBlockAccess world, BlockPos pos, IBlockState state, Entity entity) {
        Trans3 t = this.localToGlobalTransformation(world, pos, state);
        return this.getCollisionBoxes(world, pos, state, t, entity);
    }

    protected List<AxisAlignedBB> getLocalCollisionBoxes(IBlockAccess world, BlockPos pos, IBlockState state, Entity entity) {
        Trans3 t = this.localToGlobalTransformation(world, pos, state, Vector3.zero);
        return this.getCollisionBoxes(world, pos, state, t, entity);
    }

    protected List<AxisAlignedBB> getCollisionBoxes(IBlockAccess world, BlockPos pos, IBlockState state, Trans3 t, Entity entity) {
        BaseMod.ModelSpec spec = this.getModelSpec(state);
        if (spec != null) {
            BaseModClient.IModel model = this.mod.getModel(spec.modelName);
            ArrayList<AxisAlignedBB> list = new ArrayList<AxisAlignedBB>();
            model.addBoxesToList(t.translate(spec.origin), list);
            return list;
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public static class DiggingFX
    extends ParticleDigging {
        public DiggingFX(World world, double x1, double y1, double z1, double x2, double y2, double z2, IBlockState state) {
            super(world, x1, y1, z1, x2, y2, z2, state);
        }
    }

    public static class Orient1Way
    implements IOrientationHandler {
        @Override
        public void defineProperties(BaseBlock block) {
        }

        @Override
        public IBlockState onBlockPlaced(Block block, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, IBlockState baseState, EntityLivingBase placer) {
            return baseState;
        }

        @Override
        public Trans3 localToGlobalTransformation(IBlockAccess world, BlockPos pos, IBlockState state, Vector3 origin) {
            return new Trans3(origin);
        }
    }

    public static interface IOrientationHandler {
        public void defineProperties(BaseBlock var1);

        public IBlockState onBlockPlaced(Block var1, World var2, BlockPos var3, EnumFacing var4, float var5, float var6, float var7, IBlockState var8, EntityLivingBase var9);

        public Trans3 localToGlobalTransformation(IBlockAccess var1, BlockPos var2, IBlockState var3, Vector3 var4);
    }
}

