/*
 * Decompiled with CFR 0.152.
 */
package gcewing.sg;

import gcewing.sg.BaseBlockUtils;
import gcewing.sg.BaseMod;
import gcewing.sg.BaseReflectionUtils;
import gcewing.sg.Trans3;
import gcewing.sg.Vector3;
import java.lang.reflect.Field;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.server.management.PlayerChunkMap;
import net.minecraft.server.management.PlayerChunkMapEntry;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeChunkManager;

public class BaseTileEntity
extends TileEntity
implements BaseMod.ITileEntity {
    public byte side;
    public byte turn;
    public ForgeChunkManager.Ticket chunkTicket;
    protected boolean updateChunk;
    protected static Field changedSectionFilter = BaseReflectionUtils.getFieldDef(BaseReflectionUtils.classForName("net.minecraft.server.management.PlayerChunkMapEntry"), "changedSectionFilter", "field_187288_h");

    public int getX() {
        return this.field_174879_c.func_177958_n();
    }

    public int getY() {
        return this.field_174879_c.func_177956_o();
    }

    public int getZ() {
        return this.field_174879_c.func_177952_p();
    }

    public void setSide(int side) {
        this.side = (byte)side;
    }

    public void setTurn(int turn) {
        this.turn = (byte)turn;
    }

    public Trans3 localToGlobalRotation() {
        return this.localToGlobalTransformation(Vector3.zero);
    }

    public Trans3 localToGlobalTransformation() {
        return this.localToGlobalTransformation(Vector3.blockCenter(this.field_174879_c));
    }

    public Trans3 localToGlobalTransformation(double x, double y, double z) {
        return this.localToGlobalTransformation(new Vector3(x + 0.5, y + 0.5, z + 0.5));
    }

    public Trans3 localToGlobalTransformation(Vector3 origin) {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        Block block = state.func_177230_c();
        if (block instanceof BaseMod.IBlock) {
            return ((BaseMod.IBlock)block).localToGlobalTransformation((IBlockAccess)this.field_145850_b, this.field_174879_c, state, origin);
        }
        System.out.printf("BaseTileEntity.localToGlobalTransformation: Wrong block type at %s\n", this.field_174879_c);
        return new Trans3(origin);
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound nbt = new NBTTagCompound();
        if (this.syncWithClient()) {
            this.func_189515_b(nbt);
        }
        return nbt;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        if (this.syncWithClient()) {
            NBTTagCompound nbt = new NBTTagCompound();
            this.func_189515_b(nbt);
            if (this.updateChunk) {
                nbt.func_74757_a("updateChunk", true);
                this.updateChunk = false;
            }
            return new SPacketUpdateTileEntity(this.field_174879_c, 0, nbt);
        }
        return null;
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        NBTTagCompound nbt = pkt.func_148857_g();
        this.func_145839_a(nbt);
        if (nbt.func_74767_n("updateChunk")) {
            this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c);
        }
    }

    boolean syncWithClient() {
        return true;
    }

    public void markBlockForUpdate() {
        this.updateChunk = true;
        BaseBlockUtils.markBlockForUpdate(this.field_145850_b, this.field_174879_c);
    }

    public void markForUpdate() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            int x = this.field_174879_c.func_177958_n();
            int y = this.field_174879_c.func_177956_o();
            int z = this.field_174879_c.func_177952_p();
            PlayerChunkMap pm = ((WorldServer)this.field_145850_b).func_184164_w();
            PlayerChunkMapEntry entry = pm.func_187301_b(x >> 4, z >> 4);
            if (entry != null) {
                int oldFlags = BaseReflectionUtils.getIntField(entry, changedSectionFilter);
                entry.func_187265_a(x & 0xF, y, z & 0xF);
                BaseReflectionUtils.setIntField(entry, changedSectionFilter, oldFlags);
            }
        }
    }

    public void playSoundEffect(SoundEvent name, float volume, float pitch) {
        this.playSoundEffect(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, name, volume, pitch);
    }

    public void playSoundEffect(World world, double x, double y, double z, SoundEvent name, float volume, float pitch) {
        if (world.field_72995_K) {
            world.func_184134_a(x, y, z, name, SoundCategory.BLOCKS, volume, pitch, false);
        } else {
            world.func_184148_a(null, x, y, z, name, SoundCategory.BLOCKS, volume, pitch);
        }
    }

    @Override
    public void onAddedToWorld() {
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.side = nbt.func_74771_c("side");
        this.turn = nbt.func_74771_c("turn");
        this.readContentsFromNBT(nbt);
    }

    public void readFromItemStack(ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt != null) {
            this.readFromItemStackNBT(nbt);
        }
    }

    public void readFromItemStackNBT(NBTTagCompound nbt) {
        this.readContentsFromNBT(nbt);
    }

    public void readContentsFromNBT(NBTTagCompound nbt) {
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        if (this.side != 0) {
            nbt.func_74774_a("side", this.side);
        }
        if (this.turn != 0) {
            nbt.func_74774_a("turn", this.turn);
        }
        this.writeContentsToNBT(nbt);
        return nbt;
    }

    public void writeToItemStackNBT(NBTTagCompound nbt) {
        this.writeContentsToNBT(nbt);
    }

    public void writeContentsToNBT(NBTTagCompound nbt) {
    }

    public void markChanged() {
        this.func_70296_d();
        this.markForUpdate();
    }

    public void markBlockChanged() {
        this.func_70296_d();
        this.markBlockForUpdate();
    }

    public void func_145843_s() {
        this.releaseChunkTicket();
        super.func_145843_s();
    }

    public void releaseChunkTicket() {
        if (this.chunkTicket != null) {
            ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)this.chunkTicket);
            this.chunkTicket = null;
        }
    }

    public static ItemStack blockStackWithTileEntity(Block block, int size, BaseTileEntity te) {
        return BaseTileEntity.blockStackWithTileEntity(block, size, 0, te);
    }

    public static ItemStack blockStackWithTileEntity(Block block, int size, int meta, BaseTileEntity te) {
        ItemStack stack = new ItemStack(block, size, meta);
        if (te != null) {
            NBTTagCompound tag = new NBTTagCompound();
            te.writeToItemStackNBT(tag);
            stack.func_77982_d(tag);
        }
        return stack;
    }

    public ItemStack newItemStack(int size) {
        return BaseTileEntity.blockStackWithTileEntity(this.func_145838_q(), size, this);
    }
}

