/*
 * Decompiled with CFR 0.152.
 */
package dev.aura.justenoughreactors.jei.reactor;

import dev.aura.justenoughreactors.jei.BlankJEIRecipeCategory;
import dev.aura.justenoughreactors.jei.reactor.ReactorWrapper;
import dev.aura.justenoughreactors.util.DrawableFrame;
import dev.aura.justenoughreactors.util.Resources;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import erogenousbeef.bigreactors.init.BrBlocks;
import java.util.List;
import javax.annotation.Nonnull;
import lombok.Generated;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IGuiFluidStackGroup;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import net.minecraft.block.Block;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class ReactorCategory
extends BlankJEIRecipeCategory<ReactorWrapper> {
    public static final String ID = "justenoughreactors:reactor";
    private final IDrawable background = new DrawableFrame(Resources.getReactorCornerTexture(), Resources.getReactorSideTexture(), Resources.getReactorCenterTexture());

    public ReactorCategory(IRecipeCategoryRegistration registry) {
        this(registry.getJeiHelpers());
    }

    public ReactorCategory(IJeiHelpers helpers) {
        this(helpers.getGuiHelper());
    }

    @SuppressFBWarnings(value={"NP_NONNULL_PARAM_VIOLATION"}, justification="BrBlocks.reactorCasing won't be null at runtime!")
    public ReactorCategory(IGuiHelper guiHelper) {
        super(guiHelper.createDrawableIngredient((Object)new ItemStack((Block)BrBlocks.reactorCasing, 1, 0)));
    }

    @Nonnull
    public String getUid() {
        return ID;
    }

    @Nonnull
    public String getTitle() {
        return I18n.func_135052_a((String)"justenoughreactors.gui.reactor.title", (Object[])new Object[0]);
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull ReactorWrapper recipeWrapper, @Nonnull IIngredients ingredients) {
        if (recipeWrapper.getReactorEntry().isBlock()) {
            IGuiItemStackGroup itemStacks = recipeLayout.getItemStacks();
            itemStacks.init(0, true, 15, 15);
            itemStacks.set(0, (List)ingredients.getInputs(ItemStack.class).get(0));
        } else {
            IGuiFluidStackGroup fluidStacks = recipeLayout.getFluidStacks();
            fluidStacks.init(0, true, 16, 16);
            fluidStacks.set(0, (List)ingredients.getInputs(FluidStack.class).get(0));
        }
    }

    @Generated
    public IDrawable getBackground() {
        return this.background;
    }
}

