/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.common.multiblock.computer;

import com.google.common.collect.Maps;
import erogenousbeef.bigreactors.common.multiblock.IInputOutputPort;
import erogenousbeef.bigreactors.common.multiblock.MultiblockTurbine;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityTurbineComputerPort;
import it.zerono.mods.zerocore.api.multiblock.MultiblockTileEntityBase;
import it.zerono.mods.zerocore.lib.compat.LuaHelper;
import it.zerono.mods.zerocore.lib.compat.computer.ComputerMethod;
import it.zerono.mods.zerocore.lib.compat.computer.MultiblockComputerPeripheral;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class TurbineComputerPeripheral
extends MultiblockComputerPeripheral<TileEntityTurbineComputerPort> {
    public TurbineComputerPeripheral(@Nonnull TileEntityTurbineComputerPort turbineComputerPort) {
        super((MultiblockTileEntityBase)turbineComputerPort);
    }

    public String getPeripheralStaticName() {
        return "extremereactor-turbineComputerPort";
    }

    public void populatePeripheralMethods(@Nonnull List<ComputerMethod> methods) {
        super.populatePeripheralMethods(methods);
        methods.add(new ComputerMethod("getActive", TurbineComputerPeripheral::getActive));
        methods.add(new ComputerMethod("getEnergyProducedLastTick", TurbineComputerPeripheral::getEnergyProducedLastTick));
        methods.add(new ComputerMethod("getEnergyStored", TurbineComputerPeripheral::getEnergyStored));
        methods.add(new ComputerMethod("getFluidAmountMax", TurbineComputerPeripheral::getFluidAmountMax));
        methods.add(new ComputerMethod("getFluidFlowRate", TurbineComputerPeripheral::getFluidFlowRate));
        methods.add(new ComputerMethod("getFluidFlowRateMax", TurbineComputerPeripheral::getFluidFlowRateMax));
        methods.add(new ComputerMethod("getFluidFlowRateMaxMax", TurbineComputerPeripheral::getFluidFlowRateMaxMax));
        methods.add(new ComputerMethod("getInputAmount", TurbineComputerPeripheral::getInputAmount));
        methods.add(new ComputerMethod("getInputType", TurbineComputerPeripheral::getInputType));
        methods.add(new ComputerMethod("getOutputAmount", TurbineComputerPeripheral::getOutputAmount));
        methods.add(new ComputerMethod("getOutputType", TurbineComputerPeripheral::getOutputType));
        methods.add(new ComputerMethod("getRotorSpeed", TurbineComputerPeripheral::getRotorSpeed));
        methods.add(new ComputerMethod("getNumberOfBlades", TurbineComputerPeripheral::getNumberOfBlades));
        methods.add(new ComputerMethod("getBladeEfficiency", TurbineComputerPeripheral::getBladeEfficiency));
        methods.add(new ComputerMethod("getRotorMass", TurbineComputerPeripheral::getRotorMass));
        methods.add(new ComputerMethod("getInductorEngaged", TurbineComputerPeripheral::getInductorEngaged));
        methods.add(new ComputerMethod("getEnergyCapacity", TurbineComputerPeripheral::getEnergyCapacity));
        methods.add(new ComputerMethod("getEnergyStats", TurbineComputerPeripheral::getEnergyStats));
        methods.add(new ComputerMethod("setActive", TurbineComputerPeripheral::setActive, 1, true));
        methods.add(new ComputerMethod("setFluidFlowRateMax", TurbineComputerPeripheral::setFluidFlowRateMax, 1, true));
        methods.add(new ComputerMethod("setVentNone", TurbineComputerPeripheral::setVentNone, 0, true));
        methods.add(new ComputerMethod("setVentOverflow", TurbineComputerPeripheral::setVentOverflow, 0, true));
        methods.add(new ComputerMethod("setVentAll", TurbineComputerPeripheral::setVentAll, 0, true));
        methods.add(new ComputerMethod("setInductorEngaged", TurbineComputerPeripheral::setInductorEngaged, 1, true));
    }

    public static Object[] getActive(@Nonnull TurbineComputerPeripheral peripheral, @Nonnull Object[] arguments) throws Exception {
        return new Object[]{TurbineComputerPeripheral.getTurbineControllerOrFail(peripheral).getActive()};
    }

    public static Object[] getEnergyProducedLastTick(@Nonnull TurbineComputerPeripheral peripheral, @Nonnull Object[] arguments) throws Exception {
        return new Object[]{Float.valueOf(TurbineComputerPeripheral.getTurbineControllerOrFail(peripheral).getEnergyGeneratedLastTick())};
    }

    public static Object[] getEnergyStored(@Nonnull TurbineComputerPeripheral peripheral, @Nonnull Object[] arguments) throws Exception {
        return new Object[]{TurbineComputerPeripheral.getTurbineControllerOrFail(peripheral).getEnergyStored()};
    }

    public static Object[] getFluidAmountMax(@Nonnull TurbineComputerPeripheral peripheral, @Nonnull Object[] arguments) throws Exception {
        return new Object[]{4000};
    }

    public static Object[] getFluidFlowRate(@Nonnull TurbineComputerPeripheral peripheral, @Nonnull Object[] arguments) throws Exception {
        return new Object[]{TurbineComputerPeripheral.getTurbineControllerOrFail(peripheral).getFluidConsumedLastTick()};
    }

    public static Object[] getFluidFlowRateMax(@Nonnull TurbineComputerPeripheral peripheral, @Nonnull Object[] arguments) throws Exception {
        return new Object[]{TurbineComputerPeripheral.getTurbineControllerOrFail(peripheral).getMaxIntakeRate()};
    }

    public static Object[] getFluidFlowRateMaxMax(@Nonnull TurbineComputerPeripheral peripheral, @Nonnull Object[] arguments) throws Exception {
        return new Object[]{TurbineComputerPeripheral.getTurbineControllerOrFail(peripheral).getMaxIntakeRateMax()};
    }

    public static Object[] getInputAmount(@Nonnull TurbineComputerPeripheral peripheral, @Nonnull Object[] arguments) throws Exception {
        return new Object[]{TurbineComputerPeripheral.getFluidAmount(peripheral, IInputOutputPort.Direction.Input)};
    }

    public static Object[] getInputType(@Nonnull TurbineComputerPeripheral peripheral, @Nonnull Object[] arguments) throws Exception {
        return new Object[]{TurbineComputerPeripheral.getFluidName(peripheral, IInputOutputPort.Direction.Input)};
    }

    public static Object[] getOutputAmount(@Nonnull TurbineComputerPeripheral peripheral, @Nonnull Object[] arguments) throws Exception {
        return new Object[]{TurbineComputerPeripheral.getFluidAmount(peripheral, IInputOutputPort.Direction.Output)};
    }

    public static Object[] getOutputType(@Nonnull TurbineComputerPeripheral peripheral, @Nonnull Object[] arguments) throws Exception {
        return new Object[]{TurbineComputerPeripheral.getFluidName(peripheral, IInputOutputPort.Direction.Output)};
    }

    public static Object[] getRotorSpeed(@Nonnull TurbineComputerPeripheral peripheral, @Nonnull Object[] arguments) throws Exception {
        return new Object[]{Float.valueOf(TurbineComputerPeripheral.getTurbineControllerOrFail(peripheral).getRotorSpeed())};
    }

    public static Object[] getNumberOfBlades(@Nonnull TurbineComputerPeripheral peripheral, @Nonnull Object[] arguments) throws Exception {
        return new Object[]{TurbineComputerPeripheral.getTurbineControllerOrFail(peripheral).getNumRotorBlades()};
    }

    public static Object[] getBladeEfficiency(@Nonnull TurbineComputerPeripheral peripheral, @Nonnull Object[] arguments) throws Exception {
        return new Object[]{Float.valueOf(TurbineComputerPeripheral.getTurbineControllerOrFail(peripheral).getRotorEfficiencyLastTick() * 100.0f)};
    }

    public static Object[] getRotorMass(@Nonnull TurbineComputerPeripheral peripheral, @Nonnull Object[] arguments) throws Exception {
        return new Object[]{TurbineComputerPeripheral.getTurbineControllerOrFail(peripheral).getRotorMass()};
    }

    public static Object[] getInductorEngaged(@Nonnull TurbineComputerPeripheral peripheral, @Nonnull Object[] arguments) throws Exception {
        return new Object[]{TurbineComputerPeripheral.getTurbineControllerOrFail(peripheral).getInductorEngaged()};
    }

    public static Object[] getEnergyCapacity(@Nonnull TurbineComputerPeripheral peripheral, @Nonnull Object[] arguments) throws Exception {
        return new Object[]{TurbineComputerPeripheral.getTurbineControllerOrFail(peripheral).getEnergyCapacity()};
    }

    public static Object[] getEnergyStats(@Nonnull TurbineComputerPeripheral peripheral, @Nonnull Object[] arguments) throws Exception {
        MultiblockTurbine turbine = TurbineComputerPeripheral.getTurbineControllerOrFail(peripheral);
        HashMap stats = Maps.newHashMap();
        stats.put("energyStored", turbine.getEnergyStored());
        stats.put("energyCapacity", turbine.getEnergyCapacity());
        stats.put("energyProducedLastTick", Float.valueOf(turbine.getEnergyGeneratedLastTick()));
        return new Object[]{stats};
    }

    public static Object[] setActive(@Nonnull TurbineComputerPeripheral peripheral, @Nonnull Object[] arguments) throws Exception {
        TurbineComputerPeripheral.getTurbineControllerOrFail(peripheral).setActive(LuaHelper.getBooleanFromArgs((Object[])arguments, (int)0));
        return null;
    }

    public static Object[] setFluidFlowRateMax(@Nonnull TurbineComputerPeripheral peripheral, @Nonnull Object[] arguments) throws Exception {
        TurbineComputerPeripheral.getTurbineControllerOrFail(peripheral).setMaxIntakeRate(LuaHelper.getIntFromArgs((Object[])arguments, (int)0));
        return null;
    }

    public static Object[] setVentNone(@Nonnull TurbineComputerPeripheral peripheral, @Nonnull Object[] arguments) throws Exception {
        TurbineComputerPeripheral.getTurbineControllerOrFail(peripheral).setVentStatus(MultiblockTurbine.VentStatus.DoNotVent, true);
        return null;
    }

    public static Object[] setVentOverflow(@Nonnull TurbineComputerPeripheral peripheral, @Nonnull Object[] arguments) throws Exception {
        TurbineComputerPeripheral.getTurbineControllerOrFail(peripheral).setVentStatus(MultiblockTurbine.VentStatus.VentOverflow, true);
        return null;
    }

    public static Object[] setVentAll(@Nonnull TurbineComputerPeripheral peripheral, @Nonnull Object[] arguments) throws Exception {
        TurbineComputerPeripheral.getTurbineControllerOrFail(peripheral).setVentStatus(MultiblockTurbine.VentStatus.VentAll, true);
        return null;
    }

    public static Object[] setInductorEngaged(@Nonnull TurbineComputerPeripheral peripheral, @Nonnull Object[] arguments) throws Exception {
        TurbineComputerPeripheral.getTurbineControllerOrFail(peripheral).setInductorEngaged(LuaHelper.getBooleanFromArgs((Object[])arguments, (int)0), true);
        return null;
    }

    private static MultiblockTurbine getTurbineControllerOrFail(@Nonnull TurbineComputerPeripheral peripheral) throws Exception {
        if (!((TileEntityTurbineComputerPort)peripheral.getMultiblockPart()).isConnected()) {
            throw new Exception("Unable to access turbine - port is not connected");
        }
        return ((TileEntityTurbineComputerPort)peripheral.getMultiblockPart()).getTurbine();
    }

    @Nullable
    private static IFluidTankProperties getTankProperties(@Nonnull TurbineComputerPeripheral peripheral, @Nonnull IInputOutputPort.Direction direction) throws Exception {
        MultiblockTurbine turbine = TurbineComputerPeripheral.getTurbineControllerOrFail(peripheral);
        IFluidTankProperties[] properties = turbine.getFluidHandler(direction).getTankProperties();
        return null != properties && properties.length > 0 ? properties[0] : null;
    }

    private static int getFluidAmount(@Nonnull TurbineComputerPeripheral peripheral, @Nonnull IInputOutputPort.Direction direction) throws Exception {
        IFluidTankProperties properties = TurbineComputerPeripheral.getTankProperties(peripheral, direction);
        FluidStack stack = null != properties ? properties.getContents() : null;
        return null != stack ? stack.amount : 0;
    }

    @Nullable
    private static String getFluidName(@Nonnull TurbineComputerPeripheral peripheral, @Nonnull IInputOutputPort.Direction direction) throws Exception {
        IFluidTankProperties properties = TurbineComputerPeripheral.getTankProperties(peripheral, direction);
        FluidStack stack = null != properties ? properties.getContents() : null;
        Fluid fluid = null != stack ? stack.getFluid() : null;
        return null != fluid ? fluid.getName() : null;
    }
}

