/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.elements;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.gui.TooltipRenderer;
import mezz.jei.gui.elements.IMouseClickedButtonCallback;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;

public class GuiIconButton
extends GuiButton {
    private final Consumer<List<String>> tooltipCallback;
    private final Supplier<IDrawable> iconSupplier;
    private final IMouseClickedButtonCallback mouseClickCallback;

    public GuiIconButton(int buttonId, IDrawable icon, IMouseClickedButtonCallback mouseClickCallback) {
        this(buttonId, tooltip -> {}, () -> icon, mouseClickCallback);
    }

    public GuiIconButton(int buttonId, Consumer<List<String>> tooltipCallback, Supplier<IDrawable> iconSupplier, IMouseClickedButtonCallback mouseClickCallback) {
        super(buttonId, 0, 0, 0, 0, "");
        this.tooltipCallback = tooltipCallback;
        this.iconSupplier = iconSupplier;
        this.mouseClickCallback = mouseClickCallback;
    }

    public void updateBounds(Rectangle area) {
        this.field_146128_h = area.x;
        this.field_146129_i = area.y;
        this.field_146120_f = area.width;
        this.field_146121_g = area.height;
    }

    public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
        if (this.field_146125_m) {
            mc.func_110434_K().func_110577_a(field_146122_a);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.field_146123_n = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
            int i = this.func_146114_a(this.field_146123_n);
            GlStateManager.func_179147_l();
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            int firstHalfWidth = this.field_146120_f / 2;
            int secondHalfWidth = (int)Math.ceil((float)this.field_146120_f / 2.0f);
            this.func_73729_b(this.field_146128_h, this.field_146129_i, 0, 46 + i * 20, firstHalfWidth, this.field_146121_g);
            this.func_73729_b(this.field_146128_h + firstHalfWidth, this.field_146129_i, 200 - secondHalfWidth, 46 + i * 20, secondHalfWidth, this.field_146121_g);
            this.func_146119_b(mc, mouseX, mouseY);
            IDrawable icon = this.iconSupplier.get();
            int xOffset = this.field_146128_h + (this.field_146120_f - icon.getWidth()) / 2;
            int yOffset = this.field_146129_i + (this.field_146121_g - icon.getHeight()) / 2;
            GlStateManager.func_179094_E();
            if (this.field_146120_f % 2 == 1) {
                GlStateManager.func_179137_b((double)0.5, (double)0.0, (double)0.0);
            }
            if (this.field_146121_g % 2 == 1) {
                GlStateManager.func_179137_b((double)0.0, (double)0.5, (double)0.0);
            }
            icon.draw(mc, xOffset, yOffset);
            GlStateManager.func_179121_F();
        }
    }

    public void drawTooltips(Minecraft minecraft, int mouseX, int mouseY) {
        if (this.func_146115_a()) {
            ArrayList<String> tooltip = new ArrayList<String>();
            this.tooltipCallback.accept(tooltip);
            TooltipRenderer.drawHoveringText(minecraft, tooltip, mouseX, mouseY, 150);
        }
    }

    public boolean func_146116_c(Minecraft mc, int mouseX, int mouseY) {
        if (super.func_146116_c(mc, mouseX, mouseY) && this.mouseClickCallback.mousePressed(mc, mouseX, mouseY)) {
            this.func_146113_a(mc.func_147118_V());
            return true;
        }
        return false;
    }
}

