/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.tile.mob;

import com.buuz135.industrial.IndustrialForegoing;
import com.buuz135.industrial.item.addon.AdultFilterAddonItem;
import com.buuz135.industrial.item.addon.FortuneAddonItem;
import com.buuz135.industrial.proxy.BlockRegistry;
import com.buuz135.industrial.proxy.FluidsRegistry;
import com.buuz135.industrial.tile.CustomColoredItemHandler;
import com.buuz135.industrial.tile.WorkingAreaElectricMachine;
import com.buuz135.industrial.tile.api.IAcceptsAdultFilter;
import com.buuz135.industrial.tile.api.IAcceptsFortuneAddon;
import com.buuz135.industrial.utils.ItemStackUtils;
import com.buuz135.industrial.utils.WorkUtils;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.ndrei.teslacorelib.inventory.BoundingRectangle;

public class MobRelocatorTile
extends WorkingAreaElectricMachine
implements IAcceptsAdultFilter,
IAcceptsFortuneAddon {
    private IFluidTank outExp;
    private ItemStackHandler outItems;

    public MobRelocatorTile() {
        super(MobRelocatorTile.class.getName().hashCode());
    }

    @Override
    protected void initializeInventories() {
        super.initializeInventories();
        this.outExp = this.addFluidTank(FluidsRegistry.ESSENCE, 8000, EnumDyeColor.LIME, "Experience tank", new BoundingRectangle(50, 25, 18, 54));
        this.outItems = new ItemStackHandler(12){

            protected void onContentsChanged(int slot) {
                MobRelocatorTile.this.func_70296_d();
            }
        };
        this.addInventory((IItemHandler)new CustomColoredItemHandler((IItemHandler)this.outItems, EnumDyeColor.ORANGE, "Mob drops", 93, 25, 4, 3){

            public boolean canInsertItem(int slot, ItemStack stack) {
                return false;
            }

            public boolean canExtractItem(int slot) {
                return true;
            }
        });
        this.addInventoryToStorage(this.outItems, "mob_relocator_out");
    }

    @Override
    public void protectedUpdate() {
        super.protectedUpdate();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.func_145831_w().func_72872_a(EntityXPOrb.class, this.getWorkingArea().func_72321_a(2.0, 2.0, 2.0)).stream().filter(entityXPOrb -> !entityXPOrb.field_70128_L).forEach(entityXPOrb -> {
            if (this.outExp.fill(new FluidStack((Fluid)FluidsRegistry.ESSENCE, (int)((float)(entityXPOrb.func_70526_d() * 20) * BlockRegistry.mobRelocatorBlock.getEssenceMultiplier())), false) > 0) {
                this.outExp.fill(new FluidStack((Fluid)FluidsRegistry.ESSENCE, (int)((float)(entityXPOrb.func_70526_d() * 20) * BlockRegistry.mobRelocatorBlock.getEssenceMultiplier())), true);
                entityXPOrb.func_70106_y();
                this.forceSync();
            } else if (entityXPOrb.field_70531_b < 4800) {
                entityXPOrb.field_70531_b = 4800;
            }
        });
    }

    @Override
    public float work() {
        if (WorkUtils.isDisabled(this.func_145838_q())) {
            return 0.0f;
        }
        AxisAlignedBB area = this.getWorkingArea();
        List mobs = this.func_145831_w().func_72872_a(EntityLiving.class, area);
        mobs.removeIf(entityLiving -> entityLiving.field_70128_L);
        if (mobs.size() == 0) {
            return 0.0f;
        }
        FakePlayer player = IndustrialForegoing.getFakePlayer(this.field_145850_b, this.field_174879_c);
        if (this.getFortuneLevel() > 0) {
            ItemStack stick = new ItemStack(Items.field_151055_y);
            stick.func_77966_a(Enchantments.field_185304_p, this.getFortuneLevel());
            player.func_184611_a(player.func_184600_cs(), stick);
        }
        AtomicBoolean hasWorked = new AtomicBoolean(false);
        boolean hasAddon = this.hasAddon();
        mobs.stream().filter(entityLiving -> !hasAddon || !(entityLiving instanceof EntityAgeable) || !entityLiving.func_70631_g_()).forEach(entityLiving -> {
            entityLiving.func_70097_a((DamageSource)new EntityDamageSource("mob_crusher", (Entity)player){

                public ITextComponent func_151519_b(EntityLivingBase entityLivingBaseIn) {
                    return new TextComponentTranslation("text.industrialforegoing.chat.crusher_kill", new Object[]{entityLivingBaseIn.func_145748_c_().func_150254_d(), TextFormatting.RESET});
                }
            }, (float)BlockRegistry.mobRelocatorBlock.getDamage());
            hasWorked.set(true);
        });
        List items = this.func_145831_w().func_72872_a(EntityItem.class, area);
        for (EntityItem item : items) {
            if (item.func_92059_d().func_190926_b() || item.field_70128_L) continue;
            if (ItemHandlerHelper.insertItem((IItemHandler)this.outItems, (ItemStack)item.func_92059_d(), (boolean)true).func_190926_b()) {
                ItemHandlerHelper.insertItem((IItemHandler)this.outItems, (ItemStack)item.func_92059_d(), (boolean)false);
                item.func_70106_y();
                continue;
            }
            item.lifespan = 1200;
        }
        player.func_184611_a(player.func_184600_cs(), ItemStack.field_190927_a);
        return hasWorked.get() ? 1.0f : 0.0f;
    }

    protected boolean acceptsFluidItem(ItemStack stack) {
        return ItemStackUtils.acceptsFluidItem(stack);
    }

    protected void processFluidItems(ItemStackHandler fluidItems) {
        ItemStackUtils.fillItemFromTank(fluidItems, this.outExp);
    }

    @Override
    public boolean hasAddon() {
        return this.hasAddon(AdultFilterAddonItem.class);
    }

    @Override
    public int getFortuneLevel() {
        return this.hasAddon(FortuneAddonItem.class) ? ((FortuneAddonItem)this.getAddon(FortuneAddonItem.class)).getLevel(this.getAddonStack(FortuneAddonItem.class)) : 0;
    }
}

