/*
 * Decompiled with CFR 0.152.
 */
package trinsdar.ic2c_extras.blocks.tileentity;

import ic2.core.block.generator.tile.TileEntityBasicSteamTurbine;
import ic2.core.platform.lang.components.base.LocaleComp;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fluids.FluidStack;
import trinsdar.ic2c_extras.util.references.Ic2cExtrasLang;

public class TileEntityAdvancedSteamTurbine
extends TileEntityBasicSteamTurbine {
    public int getOutput() {
        return Math.min(160, this.energy);
    }

    public void func_73660_a() {
        this.setActive(this.speed > 0.0f);
        if (this.energy >= 4000) {
            this.addChange(-0.005f);
        } else {
            FluidStack drained;
            float value = 256.0f * this.speed;
            if (value > 256.0f) {
                value = 256.0f;
            }
            if ((drained = this.drain(256.0f)) == null) {
                this.addChange(-0.002f);
            } else {
                this.addChange(this.limit((float)drained.amount - value, -0.005f, 0.005f));
            }
            float producing = 128.0f * this.speed;
            if (drained != null) {
                producing += (float)drained.amount / 8.0f;
            }
            if (producing >= 1.0f) {
                this.addEnergy((int)producing);
            }
            this.updateComparators();
        }
    }

    private float limit(float base, float min, float max) {
        return MathHelper.func_76131_a((float)base, (float)min, (float)max);
    }

    public double getOfferedEnergy() {
        return Math.min(160, this.energy);
    }

    public LocaleComp getBlockName() {
        return Ic2cExtrasLang.advancedSteamTurbine;
    }

    public int getSourceTier() {
        return 3;
    }

    public int getMaxSendingEnergy() {
        return 160;
    }
}

