/*
 * Decompiled with CFR 0.152.
 */
package tinker_io.tileentity;

import cofh.redstoneflux.api.IEnergyProvider;
import cofh.redstoneflux.api.IEnergyReceiver;
import cofh.redstoneflux.impl.EnergyStorage;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import slimeknights.tconstruct.smeltery.tileentity.TileTank;
import tinker_io.helper.BlockFinder;

public class TileEntityStirlingEngine
extends TileEntity
implements ITickable,
IEnergyProvider {
    public static String TAG_ANGLE = "angle";
    public static String TAG_RF_PER_TICK = "rfPerTick";
    private double angle = 0.0;
    private int rfPerTick = 0;
    private int energyExportCount = 0;
    private int syncCount = 0;
    protected EnergyStorage storage = new EnergyStorage(500000, 0, 2000);

    public int extractEnergy(EnumFacing from, int maxExtract, boolean simulate) {
        return this.storage.extractEnergy(Math.min(this.storage.getMaxExtract(), maxExtract), simulate);
    }

    public int getEnergyStored(EnumFacing from) {
        return this.storage.getEnergyStored();
    }

    public int getMaxEnergyStored(EnumFacing from) {
        return this.storage.getMaxEnergyStored();
    }

    public boolean canConnectEnergy(EnumFacing from) {
        return true;
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.angle = tagCompound.func_74769_h(TAG_ANGLE);
        this.rfPerTick = tagCompound.func_74762_e(TAG_RF_PER_TICK);
        this.storage.readFromNBT(tagCompound);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        tagCompound.func_74780_a(TAG_ANGLE, (double)((short)this.angle));
        tagCompound.func_74768_a(TAG_RF_PER_TICK, this.rfPerTick);
        this.storage.writeToNBT(tagCompound);
        return tagCompound;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbtTag = new NBTTagCompound();
        this.func_189515_b(nbtTag);
        return new SPacketUpdateTileEntity(this.field_174879_c, 1, nbtTag);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    public void func_73660_a() {
        FluidTank tank;
        this.rfPerTick = 0;
        if (this.syncCount <= 20) {
            this.notifyBlockUpdate();
            this.func_70296_d();
            ++this.syncCount;
        }
        if ((tank = this.getTankBelow()) != null) {
            this.calculateRfPerTick(tank);
            if (this.rfPerTick != 0 && this.getEnergyStored(null) < this.getMaxEnergyStored(null)) {
                this.storage.setEnergyStored(this.getEnergyStored(null) + this.rfPerTick);
                this.angle = (this.angle + 1.0) % 61.0;
                this.drainTank(tank);
                this.notifyBlockUpdate();
                this.func_70296_d();
            }
        }
        if (this.extraEnergyToSurroundingMachine()) {
            this.notifyBlockUpdate();
            this.func_70296_d();
        }
    }

    private void calculateRfPerTick(FluidTank tank) {
        Fluid fluid;
        FluidStack fluidStack = tank.getFluid();
        if (fluidStack != null && (fluid = fluidStack.getFluid()) != null) {
            this.rfPerTick = (fluid.getTemperature() - 300) * 15 / 100;
        }
    }

    private void drainTank(FluidTank tank) {
        FluidStack canDrain = tank.drain(1, false);
        if (canDrain != null) {
            tank.drain(2, true);
        }
    }

    public FluidTank getTankBelow() {
        TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177977_b());
        if (te instanceof TileTank) {
            return ((TileTank)te).getInternalTank();
        }
        return null;
    }

    private boolean extraEnergyToSurroundingMachine() {
        BlockPos blockPos;
        int exportPerTick = Math.min(this.storage.getEnergyStored(), 1000);
        BlockFinder blockFinder = new BlockFinder(this.field_174879_c, this.field_145850_b);
        List<Object> blocPosList = blockFinder.getSurroundingTileEntityPos(this.field_174879_c);
        if ((blocPosList = blocPosList.stream().filter(pos -> this.field_145850_b.func_175625_s(pos) instanceof IEnergyReceiver).collect(Collectors.toList())).size() == 0) {
            return false;
        }
        if (this.energyExportCount >= blocPosList.size()) {
            this.energyExportCount = 0;
        }
        if ((blockPos = (BlockPos)blocPosList.get(this.energyExportCount)) == null) {
            this.energyExportCount = 0;
            return false;
        }
        int averageExtraEnergy = (int)Math.floor((float)exportPerTick / (float)blocPosList.size());
        IEnergyReceiver rfStorage = (IEnergyReceiver)this.field_145850_b.func_175625_s(blockPos);
        if (rfStorage != null && this.storage.getEnergyStored() > 0 && rfStorage.getEnergyStored(EnumFacing.DOWN) < rfStorage.getMaxEnergyStored(EnumFacing.DOWN)) {
            this.storage.setEnergyStored(this.storage.getEnergyStored() - averageExtraEnergy);
            rfStorage.receiveEnergy(EnumFacing.DOWN, averageExtraEnergy, false);
        }
        ++this.energyExportCount;
        return true;
    }

    public int getRfPerTick() {
        return this.rfPerTick;
    }

    public void setEnergyAmount(int amount) {
        this.storage.setEnergyStored(amount);
    }

    public int getEnergyStored() {
        return this.storage.getEnergyStored();
    }

    public double getAngle() {
        return this.angle;
    }

    public FluidStack getFluid() {
        FluidTank tank = this.getTankBelow();
        if (tank != null && tank.getFluid() != null) {
            return tank.getFluid();
        }
        return null;
    }

    public int getFluidAmount() {
        FluidStack fluidStack = this.getFluid();
        if (fluidStack != null) {
            return fluidStack.amount;
        }
        return 0;
    }

    public int getTemperature() {
        FluidStack fluidStack = this.getFluid();
        if (fluidStack != null && fluidStack.getFluid() != null) {
            return fluidStack.getFluid().getTemperature();
        }
        return 0;
    }

    private void notifyBlockUpdate() {
        if (this.field_145850_b != null && this.field_174879_c != null) {
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
        }
    }
}

