/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common;

import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraftforge.common.ticket.AABBTicket;
import net.minecraftforge.common.ticket.ChunkTicketManager;
import net.minecraftforge.common.ticket.MultiTicketManager;
import net.minecraftforge.common.ticket.SimpleTicket;

public class FarmlandWaterManager {
    private static final Int2ObjectMap<Map<amn, ChunkTicketManager<bhe>>> customWaterHandler = new Int2ObjectOpenHashMap();

    public static <T extends SimpleTicket<bhe>> T addCustomTicket(amu world, T ticket, amn ... chunkPoses) {
        Preconditions.checkArgument((!world.G ? 1 : 0) != 0, (Object)"Water region is only determined server-side");
        Preconditions.checkArgument((chunkPoses.length > 0 ? 1 : 0) != 0, (Object)"Need at least one chunk pos");
        Map ticketMap = (Map)customWaterHandler.computeIfAbsent((Object)world.s.getDimension(), id -> new HashMap());
        if (chunkPoses.length == 1) {
            ((SimpleTicket)ticket).setBackend(ticketMap.computeIfAbsent(chunkPoses[0], ChunkTicketManager::new));
        } else {
            ChunkTicketManager[] tickets = new ChunkTicketManager[chunkPoses.length];
            for (int i2 = 0; i2 < chunkPoses.length; ++i2) {
                tickets[i2] = ticketMap.computeIfAbsent(chunkPoses[i2], ChunkTicketManager::new);
            }
            ((SimpleTicket)ticket).setBackend(new MultiTicketManager(tickets));
        }
        ((SimpleTicket)ticket).validate();
        return (T)ticket;
    }

    public static AABBTicket addAABBTicket(amu world, bhb aabb) {
        amn leftUp = new amn((int)aabb.a >> 4, (int)aabb.c >> 4);
        amn rightDown = new amn((int)aabb.d >> 4, (int)aabb.f >> 4);
        HashSet<amn> posSet = new HashSet<amn>();
        for (int x = leftUp.a; x <= rightDown.a; ++x) {
            for (int z = leftUp.b; z <= rightDown.b; ++z) {
                posSet.add(new amn(x, z));
            }
        }
        return FarmlandWaterManager.addCustomTicket(world, new AABBTicket(aabb), posSet.toArray(new amn[0]));
    }

    public static boolean hasBlockWaterTicket(amu world, et pos) {
        ChunkTicketManager<bhe> ticketManager = FarmlandWaterManager.getTicketManager(new amn(pos.p() >> 4, pos.r() >> 4), world);
        if (ticketManager != null) {
            bhe posAsVec3d = new bhe((fq)pos);
            for (SimpleTicket<bhe> ticket : ticketManager.getTickets()) {
                if (!ticket.matches(posAsVec3d)) continue;
                return true;
            }
        }
        return false;
    }

    static void removeTickets(axw chunk) {
        ChunkTicketManager<bhe> ticketManager = FarmlandWaterManager.getTicketManager(chunk.k(), chunk.q());
        if (ticketManager != null) {
            for (SimpleTicket<bhe> ticket : ticketManager.getTickets()) {
                ticket.invalidate();
            }
        }
    }

    private static ChunkTicketManager<bhe> getTicketManager(amn pos, amu world) {
        Preconditions.checkArgument((!world.G ? 1 : 0) != 0, (Object)"Water region is only determined server-side");
        Map ticketMap = (Map)customWaterHandler.get(world.s.getDimension());
        if (ticketMap == null) {
            return null;
        }
        return (ChunkTicketManager)ticketMap.get(pos);
    }
}

