/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.crafting;

import com.google.common.collect.Maps;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraftforge.common.crafting.CraftingHelper;

public class JsonContext {
    private String modId;
    private Map<String, akq> constants = Maps.newHashMap();

    public JsonContext(String modId) {
        this.modId = modId;
    }

    public String getModId() {
        return this.modId;
    }

    public String appendModId(String data) {
        if (data.indexOf(58) == -1) {
            return this.modId + ":" + data;
        }
        return data;
    }

    @Nullable
    public akq getConstant(String name) {
        return this.constants.get(name);
    }

    void loadConstants(JsonObject ... jsons) {
        for (JsonObject json : jsons) {
            if (json.has("conditions") && !CraftingHelper.processConditions(json.getAsJsonArray("conditions"), this)) continue;
            if (!json.has("ingredient")) {
                throw new JsonSyntaxException("Constant entry must contain 'ingredient' value");
            }
            this.constants.put(rc.h((JsonObject)json, (String)"name"), CraftingHelper.getIngredient(json.get("ingredient"), this));
        }
    }
}

