/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.integration.crafttweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.api.item.IIngredient;
import java.util.ArrayList;
import java.util.List;
import sonar.core.integration.crafttweaker.CraftTweakerHelper;
import sonar.core.recipes.ISonarRecipe;
import sonar.core.recipes.ISonarRecipeObject;
import sonar.core.recipes.RecipeHelperV2;
import sonar.core.recipes.RecipeObjectType;

public class SonarRemoveRecipe
implements IAction {
    public RecipeHelperV2 recipes;
    public ISonarRecipe recipe;
    public boolean valid = true;

    public SonarRemoveRecipe(RecipeHelperV2 recipes, RecipeObjectType type, List<IIngredient> ingredients) {
        this.recipes = recipes;
        ArrayList<ISonarRecipeObject> sonar_objects = new ArrayList<ISonarRecipeObject>();
        for (IIngredient i : ingredients) {
            ISonarRecipeObject obj = CraftTweakerHelper.convertItemIngredient(i);
            if (obj == null) {
                this.valid = false;
                CraftTweakerAPI.logError((String)String.format("%s: INVALID ITEM : %s", recipes.getRecipeID(), i));
                continue;
            }
            sonar_objects.add(obj);
        }
        if (this.valid) {
            switch (type) {
                case INPUT: {
                    this.recipe = recipes.getRecipeFromInputs(null, sonar_objects.toArray());
                    break;
                }
                case OUTPUT: {
                    this.recipe = recipes.getRecipeFromOutputs(null, sonar_objects.toArray());
                }
            }
        }
    }

    public void apply() {
        boolean result;
        if (this.valid && this.recipe != null && !(result = this.recipes.removeRecipe(this.recipe))) {
            CraftTweakerAPI.logError((String)String.format("%s: Removing Recipe - Failed to remove recipe %s", this.recipes.getRecipeID()));
        }
    }

    public String describe() {
        if (!this.valid || this.recipe == null) {
            return "INVALID RECIPE";
        }
        return String.format("Removing %s recipe (%s = %s)", this.recipes.getRecipeID(), this.recipe.inputs(), this.recipe.outputs());
    }
}

