/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.network;

import io.netty.buffer.ByteBuf;
import mcmultipart.api.multipart.IMultipartTile;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import sonar.core.SonarCore;
import sonar.core.api.nbt.INBTSyncable;
import sonar.core.helpers.NBTHelper;
import sonar.core.network.PacketMultipart;
import sonar.core.network.PacketMultipartHandler;

public class PacketMultipartSync
extends PacketMultipart {
    public NBTTagCompound tag;
    public NBTHelper.SyncType type;

    public PacketMultipartSync() {
    }

    public PacketMultipartSync(BlockPos pos, NBTTagCompound tag, int slotID) {
        super(slotID, pos);
        this.tag = tag;
    }

    public PacketMultipartSync(BlockPos pos, NBTTagCompound tag, NBTHelper.SyncType type, int slotID) {
        super(slotID, pos);
        this.tag = tag;
        this.type = type;
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.tag = ByteBufUtils.readTag((ByteBuf)buf);
        if (buf.readBoolean()) {
            this.type = NBTHelper.SyncType.values()[buf.readByte()];
        }
    }

    @Override
    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.tag);
        if (this.type == null) {
            buf.writeBoolean(false);
        } else {
            buf.writeBoolean(true);
            buf.writeByte(this.type.ordinal());
        }
    }

    public static class Handler
    extends PacketMultipartHandler<PacketMultipartSync> {
        @Override
        public IMessage processMessage(PacketMultipartSync message, EntityPlayer player, World world, IMultipartTile part, MessageContext ctx) {
            if (world.field_72995_K) {
                SonarCore.proxy.getThreadListener(ctx.side).func_152344_a(() -> {
                    if (part instanceof INBTSyncable) {
                        INBTSyncable sync = (INBTSyncable)part;
                        sync.readData(message.tag, message.type != null ? message.type : NBTHelper.SyncType.DEFAULT_SYNC);
                    }
                    world.func_175704_b(part.getPartPos(), part.getPartPos());
                });
            }
            return null;
        }
    }
}

