/*
 * Decompiled with CFR 0.152.
 */
package omtteam.omlib.network.messages;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import omtteam.omlib.handler.OwnerShareHandler;
import omtteam.omlib.util.Player;

public class MessageSetSharePlayerList
implements IMessage {
    private HashMap<Player, ArrayList<Player>> ownerShareMap;

    public MessageSetSharePlayerList() {
    }

    public MessageSetSharePlayerList(OwnerShareHandler shareHandler) {
        this.ownerShareMap = shareHandler.getOwnerShareMap();
    }

    public void fromBytes(ByteBuf buf) {
        this.ownerShareMap = new HashMap();
        int lengthofMap = buf.readInt();
        for (int i = 0; i < lengthofMap; ++i) {
            Player owner = Player.readFromByteBuf(buf);
            ArrayList<Player> sharePlayerList = new ArrayList<Player>();
            int lengthOfPlayerList = buf.readInt();
            if (lengthOfPlayerList > 0) {
                for (int j = 0; j < lengthOfPlayerList; ++j) {
                    sharePlayerList.add(Player.readFromByteBuf(buf));
                }
            }
            this.ownerShareMap.put(owner, sharePlayerList);
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.ownerShareMap.size());
        for (Map.Entry<Player, ArrayList<Player>> entry : this.ownerShareMap.entrySet()) {
            Player owner = entry.getKey();
            Player.writeToByteBuf(owner, buf);
            buf.writeInt(entry.getValue().size());
            if (entry.getValue().size() <= 0) continue;
            for (Player player : entry.getValue()) {
                Player.writeToByteBuf(player, buf);
            }
        }
    }

    public static class MessageHandlerSetSharePlayerList
    implements IMessageHandler<MessageSetSharePlayerList, IMessage> {
        @SideOnly(value=Side.CLIENT)
        public IMessage onMessage(MessageSetSharePlayerList messageIn, MessageContext ctx) {
            MessageSetSharePlayerList message = messageIn;
            Minecraft.func_71410_x().func_152344_a(() -> OwnerShareHandler.getInstance().setOwnerShareMap(messageIn.ownerShareMap));
            return null;
        }
    }
}

