/*
 * Decompiled with CFR 0.152.
 */
package omtteam.omlib.util;

import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.ParametersAreNullableByDefault;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.management.UserListOpsEntry;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.UsernameCache;
import omtteam.omlib.handler.ConfigHandler;
import omtteam.omlib.handler.OwnerShareHandler;
import omtteam.omlib.tileentity.ITrustedPlayersManager;
import omtteam.omlib.tileentity.TileEntityOwnedBlock;
import omtteam.omlib.util.Player;
import omtteam.omlib.util.TrustedPlayer;

public class PlayerUtil {
    public static boolean isPlayerOP(EntityPlayer player) {
        return player.func_184102_h() != null && player.func_184102_h().func_184103_al().func_152603_m().func_152683_b((Object)player.func_146103_bH()) != null && ((UserListOpsEntry)player.func_184102_h().func_184103_al().func_152603_m().func_152683_b((Object)player.func_146103_bH())).func_152644_a() == 4;
    }

    @Nullable
    public static UUID getPlayerUUID(String username) {
        for (Map.Entry entry : UsernameCache.getMap().entrySet()) {
            if (!((String)entry.getValue()).equalsIgnoreCase(username)) continue;
            return (UUID)entry.getKey();
        }
        return null;
    }

    @Nullable
    @ParametersAreNullableByDefault
    public static UUID getPlayerUIDUnstable(String possibleUUID) {
        UUID uuid;
        if (possibleUUID == null || possibleUUID.isEmpty()) {
            return null;
        }
        try {
            uuid = UUID.fromString(possibleUUID);
        }
        catch (IllegalArgumentException e) {
            uuid = PlayerUtil.getPlayerUUID(possibleUUID);
        }
        return uuid;
    }

    @Nullable
    @ParametersAreNullableByDefault
    public static String getPlayerNameFromUUID(String possibleUUID) {
        if (possibleUUID == null || possibleUUID.isEmpty()) {
            return null;
        }
        return UsernameCache.getLastKnownUsername((UUID)UUID.fromString(possibleUUID));
    }

    @Nullable
    @ParametersAreNonnullByDefault
    public static TrustedPlayer getTrustedPlayer(EntityPlayer player, ITrustedPlayersManager machine) {
        if (machine.getTrustedPlayer(player.func_110124_au()) != null || ConfigHandler.offlineModeSupport && machine.getTrustedPlayer(player.func_70005_c_()) != null) {
            return machine.getTrustedPlayer(player.func_110124_au()) == null ? machine.getTrustedPlayer(player.func_70005_c_()) : machine.getTrustedPlayer(player.func_110124_au());
        }
        return null;
    }

    @Nullable
    @ParametersAreNonnullByDefault
    public static TrustedPlayer getTrustedPlayer(Player player, ITrustedPlayersManager machine) {
        if (machine.getTrustedPlayer(player.getUuid()) != null || ConfigHandler.offlineModeSupport && machine.getTrustedPlayer(player.getName()) != null) {
            return machine.getTrustedPlayer(player.getUuid()) == null ? machine.getTrustedPlayer(player.getName()) : machine.getTrustedPlayer(player.getUuid());
        }
        return null;
    }

    @ParametersAreNonnullByDefault
    public static boolean isPlayerTrusted(EntityPlayer entityPlayer, ITrustedPlayersManager trustedPlayersManager) {
        Player player = new Player(entityPlayer.func_110124_au(), entityPlayer.func_70005_c_());
        return PlayerUtil.isPlayerTrusted(player, trustedPlayersManager);
    }

    @ParametersAreNonnullByDefault
    public static boolean isPlayerTrusted(Player player, ITrustedPlayersManager trustedPlayersManager) {
        return ConfigHandler.offlineModeSupport ? trustedPlayersManager.getTrustedPlayer(player.getName()) != null : trustedPlayersManager.getTrustedPlayer(player.getUuid()) != null;
    }

    @ParametersAreNonnullByDefault
    public static boolean isPlayerOwner(EntityPlayer checkPlayer, TileEntityOwnedBlock ownedBlock) {
        Player owner = new Player(PlayerUtil.getPlayerUIDUnstable(ownedBlock.getOwner()), ownedBlock.getOwnerName());
        Player player = new Player(checkPlayer.func_146103_bH().getId(), checkPlayer.func_70005_c_());
        boolean allowed = player.equals(owner);
        if (!allowed && ConfigHandler.canOPAccessOwnedBlocks && PlayerUtil.isPlayerOP(checkPlayer)) {
            allowed = true;
        } else if (!allowed && OwnerShareHandler.getInstance().isPlayerSharedOwner(owner, player)) {
            allowed = true;
        }
        return allowed;
    }

    @ParametersAreNonnullByDefault
    public static boolean isPlayerOwner(Player player, TileEntityOwnedBlock ownedBlock) {
        Player owner = new Player(PlayerUtil.getPlayerUIDUnstable(ownedBlock.getOwner()), ownedBlock.getOwnerName());
        boolean allowed = player.equals(owner);
        if (!allowed && OwnerShareHandler.getInstance().isPlayerSharedOwner(owner, player)) {
            allowed = true;
        }
        return allowed;
    }

    @ParametersAreNonnullByDefault
    public static boolean isPlayerAdmin(EntityPlayer checkPlayer, ITrustedPlayersManager machine) {
        return PlayerUtil.isPlayerOwner(checkPlayer, machine.getOwnedBlock()) || PlayerUtil.isPlayerTrusted(checkPlayer, machine) && PlayerUtil.getTrustedPlayer((EntityPlayer)checkPlayer, (ITrustedPlayersManager)machine).admin;
    }

    @ParametersAreNonnullByDefault
    public static boolean isPlayerAdmin(Player player, ITrustedPlayersManager machine) {
        return PlayerUtil.isPlayerOwner(player, machine.getOwnedBlock()) || PlayerUtil.isPlayerTrusted(player, machine) && PlayerUtil.getTrustedPlayer((Player)player, (ITrustedPlayersManager)machine).admin;
    }

    public static void addChatMessage(@Nonnull ICommandSender sender, @Nonnull ITextComponent component) {
        if (sender instanceof EntityPlayer) {
            ((EntityPlayer)sender).func_146105_b(component, false);
        } else {
            sender.func_145747_a(component);
        }
    }
}

