/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.systems.SolarSystem.planets.overworld.tile;

import galaxyspace.core.registers.fluids.GSFluids;
import galaxyspace.core.registers.items.GSItems;
import galaxyspace.core.util.GSUtils;
import galaxyspace.systems.SolarSystem.planets.overworld.blocks.machines.BlockLiquidSeparator;
import javax.annotation.Nullable;
import micdoodle8.mods.galacticraft.api.transmission.NetworkType;
import micdoodle8.mods.galacticraft.core.energy.item.ItemElectricBase;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseElectricBlockWithInventory;
import micdoodle8.mods.galacticraft.core.network.IPacketReceiver;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.FluidUtil;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.core.wrappers.FluidHandlerWrapper;
import micdoodle8.mods.galacticraft.core.wrappers.IFluidHandlerWrapper;
import micdoodle8.mods.galacticraft.planets.asteroids.AsteroidsModule;
import micdoodle8.mods.miccore.Annotations;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.relauncher.Side;

public class TileEntityLiquidSeparator
extends TileBaseElectricBlockWithInventory
implements IFluidHandlerWrapper,
ISidedInventory,
IPacketReceiver {
    int PROCESS_TIME_REQUIRED;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int processTimeRequired;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int processTicks;
    private final int tankCapacity = 3000;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public FluidTank baseTank;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public FluidTank waterTank1;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public FluidTank waterTank2;
    private NonNullList<ItemStack> stacks;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public boolean reverse;

    public TileEntityLiquidSeparator() {
        this(1);
    }

    public TileEntityLiquidSeparator(int tier) {
        this.processTimeRequired = this.PROCESS_TIME_REQUIRED = 10;
        this.processTicks = 0;
        this.tankCapacity = 3000;
        this.baseTank = new FluidTank(this.tankCapacity);
        this.waterTank1 = new FluidTank(this.tankCapacity);
        this.waterTank2 = new FluidTank(this.tankCapacity);
        this.stacks = NonNullList.func_191197_a((int)8, (Object)ItemStack.field_190927_a);
        if (tier == 1) {
            this.storage.setMaxExtract(ConfigManagerCore.hardMode ? 60.0f : 45.0f);
            return;
        }
        this.setTier2();
    }

    private void setTier2() {
        this.storage.setCapacity(25000.0f);
        this.storage.setMaxExtract(ConfigManagerCore.hardMode ? 90.0f : 60.0f);
        this.processTimeRequired = 100;
        this.setTierGC(2);
    }

    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            FluidStack liquid;
            if (!this.getReverse()) {
                GSUtils.checkFluidTankTransfer(this.stacks, 1, this.waterTank2);
                GSUtils.checkFluidTankTransfer(this.stacks, 3, this.waterTank1);
                if (!((ItemStack)this.stacks.get(2)).func_190926_b() && (liquid = FluidUtil.getFluidContained((ItemStack)((ItemStack)this.stacks.get(2)))) != null) {
                    FluidUtil.loadFromContainer((FluidTank)this.baseTank, (Fluid)liquid.getFluid(), this.stacks, (int)2, (int)liquid.amount);
                }
            } else {
                GSUtils.checkFluidTankTransfer(this.stacks, 2, this.baseTank);
                if (!((ItemStack)this.stacks.get(1)).func_190926_b() && (liquid = FluidUtil.getFluidContained((ItemStack)((ItemStack)this.stacks.get(1)))) != null) {
                    FluidUtil.loadFromContainer((FluidTank)this.waterTank2, (Fluid)liquid.getFluid(), this.stacks, (int)1, (int)liquid.amount);
                }
                if (!((ItemStack)this.stacks.get(3)).func_190926_b() && (liquid = FluidUtil.getFluidContained((ItemStack)((ItemStack)this.stacks.get(3)))) != null) {
                    FluidUtil.loadFromContainer((FluidTank)this.waterTank1, (Fluid)liquid.getFluid(), this.stacks, (int)3, (int)liquid.amount);
                }
            }
            if (this.canProcess()) {
                if (this.hasEnoughEnergyToRun) {
                    int boost_speed = 0;
                    int energy_boost = 0;
                    for (int i = 0; i <= 3; ++i) {
                        if (((ItemStack)this.stacks.get(4 + i)).func_77969_a(new ItemStack(GSItems.UPGRADES, 1, 2))) {
                            ++boost_speed;
                        }
                        if (!((ItemStack)this.stacks.get(4 + i)).func_77969_a(new ItemStack(GSItems.UPGRADES, 1, 3))) continue;
                        ++energy_boost;
                    }
                    this.processTicks -= 1 * (1 + boost_speed);
                    this.storage.setMaxExtract(ConfigManagerCore.hardMode ? (float)(90 + 60 * boost_speed - 20 * energy_boost) : (float)(75 + 55 * boost_speed - 15 * energy_boost));
                    if (this.tierGC == 2) {
                        this.processTimeRequired = 200 / (1 + this.poweredByTierGC);
                    }
                    if (this.processTicks == 0) {
                        this.processTicks = this.processTimeRequired;
                    } else if (--this.processTicks <= 0) {
                        this.smeltItem();
                        this.processTicks = this.canProcess() ? this.processTimeRequired : 0;
                    }
                } else if (this.processTicks > 0 && this.processTicks < this.processTimeRequired && this.field_145850_b.field_73012_v.nextInt(4) == 0) {
                    ++this.processTicks;
                }
            } else {
                this.processTicks = 0;
            }
        }
    }

    public boolean canProcess() {
        if (!this.getReverse()) {
            if (this.baseTank.getFluidAmount() <= 0) {
                return false;
            }
            if (this.waterTank1.getFluidAmount() >= this.waterTank1.getCapacity() || this.waterTank2.getFluidAmount() >= this.waterTank2.getCapacity()) {
                return false;
            }
        } else {
            if (this.waterTank1.getFluidAmount() <= 0 && this.waterTank2.getFluidAmount() <= 0) {
                return false;
            }
            if (this.baseTank.getFluidAmount() >= this.baseTank.getCapacity()) {
                return false;
            }
            if (this.waterTank1.getFluid() == null || this.waterTank2.getFluid() == null) {
                return false;
            }
            if (FluidRegistry.getFluidName((FluidStack)this.waterTank1.getFluid()) == null || FluidRegistry.getFluidName((FluidStack)this.waterTank2.getFluid()) == null) {
                return false;
            }
        }
        return true;
    }

    public void smeltItem() {
        if (this.canProcess()) {
            int i = 0;
            TankLiquids[] ar = TankLiquids.values();
            if (!this.getReverse()) {
                for (int j = 0; j < ar.length; ++j) {
                    if (!ar[j].getFluid().equals((Object)this.baseTank.getFluid())) continue;
                    i = j;
                }
                if (this.baseTank.getFluid().equals((Object)ar[i].getFluid()) && ar[i].getOutFluid() != null) {
                    this.waterTank1.fill(ar[i].getOutFluid(), true);
                    if (ar[i].getOutFluid2() != null) {
                        this.waterTank2.fill(ar[i].getOutFluid2(), true);
                    }
                    this.baseTank.drain(ar[i].getFluid().amount, true);
                }
            } else {
                for (int j = 0; j < ar.length; ++j) {
                    if (ar[j].getOutFluid().equals((Object)this.waterTank1.getFluid()) && ar[j].getOutFluid2().equals((Object)this.waterTank2.getFluid())) {
                        i = j;
                        continue;
                    }
                    if (!ar[j].getOutFluid().equals((Object)this.waterTank2.getFluid()) || !ar[j].getOutFluid2().equals((Object)this.waterTank1.getFluid())) continue;
                    i = j;
                }
                if (this.waterTank1.getFluid().equals((Object)ar[i].getOutFluid()) && this.waterTank2.getFluid().equals((Object)ar[i].getOutFluid2())) {
                    this.baseTank.fill(ar[i].getFluid(), true);
                    this.waterTank1.drain(ar[i].getOutFluid().amount, true);
                    this.waterTank2.drain(ar[i].getOutFluid2().amount, true);
                } else if (this.waterTank2.getFluid().equals((Object)ar[i].getOutFluid()) && this.waterTank1.getFluid().equals((Object)ar[i].getOutFluid2())) {
                    this.baseTank.fill(ar[i].getFluid(), true);
                    this.waterTank1.drain(ar[i].getOutFluid2().amount, true);
                    this.waterTank2.drain(ar[i].getOutFluid().amount, true);
                }
            }
        }
    }

    public void func_145839_a(NBTTagCompound par1NBTTagCompound) {
        super.func_145839_a(par1NBTTagCompound);
        this.processTicks = par1NBTTagCompound.func_74762_e("smeltingTicks");
        this.stacks = this.readStandardItemsFromNBT(par1NBTTagCompound);
        this.reverse = par1NBTTagCompound.func_74767_n("reverse");
        if (par1NBTTagCompound.func_74764_b("baseTank")) {
            this.baseTank.readFromNBT(par1NBTTagCompound.func_74775_l("baseTank"));
        }
        if (par1NBTTagCompound.func_74764_b("waterTank1")) {
            this.waterTank1.readFromNBT(par1NBTTagCompound.func_74775_l("waterTank1"));
        }
        if (par1NBTTagCompound.func_74764_b("waterTank2")) {
            this.waterTank2.readFromNBT(par1NBTTagCompound.func_74775_l("waterTank2"));
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound par1NBTTagCompound) {
        super.func_189515_b(par1NBTTagCompound);
        par1NBTTagCompound.func_74768_a("smeltingTicks", this.processTicks);
        this.writeStandardItemsToNBT(par1NBTTagCompound, this.stacks);
        par1NBTTagCompound.func_74757_a("reverse", this.reverse);
        if (this.baseTank.getFluid() != null) {
            par1NBTTagCompound.func_74782_a("baseTank", (NBTBase)this.baseTank.writeToNBT(new NBTTagCompound()));
        }
        if (this.waterTank1.getFluid() != null) {
            par1NBTTagCompound.func_74782_a("waterTank1", (NBTBase)this.waterTank1.writeToNBT(new NBTTagCompound()));
        }
        if (this.waterTank2.getFluid() != null) {
            par1NBTTagCompound.func_74782_a("waterTank2", (NBTBase)this.waterTank2.writeToNBT(new NBTTagCompound()));
        }
        return par1NBTTagCompound;
    }

    public boolean func_145818_k_() {
        return true;
    }

    public String func_70005_c_() {
        return GCCoreUtil.translate((String)"tile.liquid_separator.name");
    }

    public int func_70302_i_() {
        return this.stacks.size();
    }

    public int func_70297_j_() {
        return 64;
    }

    public ItemStack func_70301_a(int var1) {
        return (ItemStack)this.stacks.get(var1);
    }

    public int[] func_180463_a(EnumFacing side) {
        return new int[]{0, 1, 2};
    }

    public boolean func_180462_a(int slotID, ItemStack itemstack, EnumFacing side) {
        return this.func_94041_b(slotID, itemstack);
    }

    public boolean func_180461_b(int slotID, ItemStack itemstack, EnumFacing side) {
        return slotID == 0;
    }

    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        switch (slotID) {
            case 0: {
                return ItemElectricBase.isElectricItem((Item)itemstack.func_77973_b());
            }
            case 1: {
                return true;
            }
        }
        return false;
    }

    protected NonNullList<ItemStack> getContainingItems() {
        return this.stacks;
    }

    public boolean shouldUseEnergy() {
        return this.processTicks > 0;
    }

    private EnumFacing getPipe() {
        return this.getFront().func_176735_f();
    }

    private EnumFacing getPipeUp() {
        this.getFront();
        return EnumFacing.UP;
    }

    public boolean canConnect(EnumFacing direction, NetworkType type) {
        if (direction == null) {
            return false;
        }
        if (type == NetworkType.POWER) {
            return direction == this.getElectricInputDirection();
        }
        if (type == NetworkType.FLUID) {
            return direction == this.getPipe() || direction == this.getFront().func_176746_e() || direction == this.getPipeUp();
        }
        return false;
    }

    public boolean canFill(EnumFacing from, Fluid fluid) {
        if (!this.getReverse() && from == this.getPipeUp()) {
            return this.baseTank.getFluid() == null || this.baseTank.getFluidAmount() < this.baseTank.getCapacity();
        }
        if (this.getReverse()) {
            if (from == this.getPipe()) {
                return this.waterTank1.getFluid() == null || this.waterTank1.getFluidAmount() < this.waterTank1.getCapacity();
            }
            if (from == this.getFront().func_176746_e()) {
                return this.waterTank2.getFluid() == null || this.waterTank2.getFluidAmount() < this.waterTank2.getCapacity();
            }
        }
        return false;
    }

    public int fill(EnumFacing from, FluidStack resource, boolean doFill) {
        int used = 0;
        if (!this.getReverse()) {
            String liquidName;
            if (resource != null && this.canFill(from, resource.getFluid()) && (liquidName = FluidRegistry.getFluidName((FluidStack)resource)) != null) {
                used = this.baseTank.fill(resource, doFill);
            }
        } else if (resource != null && this.canFill(from, resource.getFluid())) {
            String liquidName;
            if (from == this.getPipe()) {
                String liquidName2 = FluidRegistry.getFluidName((FluidStack)resource);
                if (liquidName2 != null) {
                    used = this.waterTank1.fill(resource, doFill);
                }
            } else if (from == this.getFront().func_176746_e() && (liquidName = FluidRegistry.getFluidName((FluidStack)resource)) != null) {
                used = this.waterTank2.fill(resource, doFill);
            }
        }
        return used;
    }

    public FluidStack drain(EnumFacing from, FluidStack resource, boolean doDrain) {
        if (!this.getReverse()) {
            if (from == this.getFront().func_176746_e() && resource != null && resource.isFluidEqual(this.waterTank2.getFluid())) {
                return this.waterTank2.drain(resource.amount, doDrain);
            }
            if (from == this.getPipe() && resource != null && resource.isFluidEqual(this.waterTank1.getFluid())) {
                return this.waterTank1.drain(resource.amount, doDrain);
            }
        } else {
            this.getPipe();
            if (from == EnumFacing.UP && resource != null && resource.isFluidEqual(this.baseTank.getFluid())) {
                return this.baseTank.drain(resource.amount, doDrain);
            }
        }
        return null;
    }

    public FluidStack drain(EnumFacing from, int maxDrain, boolean doDrain) {
        if (!this.getReverse()) {
            if (from == this.getFront().func_176746_e()) {
                return this.waterTank2.drain(maxDrain, doDrain);
            }
            if (from == this.getPipe()) {
                return this.waterTank1.drain(maxDrain, doDrain);
            }
        } else {
            this.getPipe();
            if (from == EnumFacing.UP) {
                return this.baseTank.drain(maxDrain, doDrain);
            }
        }
        return null;
    }

    public boolean canDrain(EnumFacing from, Fluid fluid) {
        if (!this.getReverse()) {
            if (from == this.getPipe()) {
                return this.waterTank1.getFluid() != null && this.waterTank1.getFluidAmount() > 0;
            }
            if (from == this.getFront().func_176746_e()) {
                return this.waterTank2.getFluid() != null && this.waterTank2.getFluidAmount() > 0;
            }
        } else {
            this.getPipe();
            if (from == EnumFacing.UP) {
                return this.baseTank.getFluid() != null && this.baseTank.getFluidAmount() > 0;
            }
        }
        return false;
    }

    public FluidTankInfo[] getTankInfo(EnumFacing from) {
        FluidTankInfo[] tankInfo = new FluidTankInfo[]{};
        this.getPipe();
        if (from == EnumFacing.UP) {
            tankInfo = new FluidTankInfo[]{new FluidTankInfo((IFluidTank)this.baseTank)};
        } else if (from == this.getPipe()) {
            tankInfo = new FluidTankInfo[]{new FluidTankInfo((IFluidTank)this.waterTank1)};
        } else if (from == this.getFront().func_176746_e()) {
            tankInfo = new FluidTankInfo[]{new FluidTankInfo((IFluidTank)this.waterTank2)};
        }
        return tankInfo;
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)new FluidHandlerWrapper((IFluidHandlerWrapper)this, facing);
        }
        return (T)super.getCapability(capability, facing);
    }

    public EnumFacing getElectricInputDirection() {
        return EnumFacing.DOWN;
    }

    public EnumFacing getFront() {
        IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        if (state.func_177230_c() instanceof BlockLiquidSeparator) {
            return (EnumFacing)state.func_177229_b((IProperty)BlockLiquidSeparator.FACING);
        }
        return EnumFacing.NORTH;
    }

    public void setReverse(boolean rev) {
        this.reverse = rev;
    }

    public boolean getReverse() {
        return this.reverse;
    }

    public int getScaledTankLevel(FluidTank tank, int i) {
        return tank.getFluidAmount() * i / tank.getCapacity();
    }

    public static enum TankLiquids {
        ETANEMETHANE(0, new FluidStack(GSFluids.LiquidEthaneMethane, 10), new FluidStack(AsteroidsModule.fluidMethaneGas, 5), FluidRegistry.getFluidStack((String)"ethane", (int)5)),
        WATER(1, new FluidStack(FluidRegistry.WATER, 50), FluidRegistry.getFluidStack((String)"hydrogen", (int)100), FluidRegistry.getFluidStack((String)"oxygen", (int)50)),
        ROCKETFUEL22(2, new FluidStack(GSFluids.HeliumHydrogen, 10), new FluidStack(GSFluids.Helium3, 2), FluidRegistry.getFluidStack((String)"hydrogen", (int)8));

        int index;
        FluidStack input;
        FluidStack output1;
        FluidStack output2;

        private TankLiquids(int id, FluidStack input, FluidStack output1, FluidStack output2) {
            this.index = id;
            this.input = input;
            this.output1 = output1;
            this.output2 = output2;
        }

        public FluidStack getFluid() {
            return this.input;
        }

        public FluidStack getOutFluid() {
            return this.output1;
        }

        public FluidStack getOutFluid2() {
            return this.output2;
        }
    }
}

