/*
 * Decompiled with CFR 0.152.
 */
package omtteam.openmodularturrets.entity.projectiles;

import java.util.Random;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import omtteam.openmodularturrets.blocks.turretheads.BlockAbstractTurretHead;
import omtteam.openmodularturrets.entity.projectiles.TurretProjectile;
import omtteam.openmodularturrets.entity.projectiles.damagesources.ArmorBypassDamageSource;
import omtteam.openmodularturrets.handler.OMTConfigHandler;
import omtteam.openmodularturrets.init.ModSounds;
import omtteam.openmodularturrets.tileentity.TurretBase;

public class FerroSlugProjectile
extends TurretProjectile {
    public FerroSlugProjectile(World p_i1776_1_) {
        super(p_i1776_1_);
        this.gravity = 0.0f;
    }

    public FerroSlugProjectile(World par1World, ItemStack ammo, TurretBase turretBase) {
        super(par1World, ammo, turretBase);
        this.gravity = 0.0f;
    }

    @Override
    @ParametersAreNonnullByDefault
    public void onHitBlock(IBlockState hitBlock, BlockPos pos) {
        if (hitBlock.func_177230_c() instanceof BlockAbstractTurretHead) {
            return;
        }
        if (!hitBlock.func_185904_a().func_76220_a()) {
            return;
        }
        if (OMTConfigHandler.canRailgunDestroyBlocks) {
            this.func_130014_f_().func_175655_b(pos, false);
        }
        this.func_70106_y();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void onHitEntity(Entity entity) {
        if (entity == null || this.func_130014_f_().field_72995_K || entity instanceof TurretProjectile) return;
        int damage = OMTConfigHandler.getRailgunTurretSettings().getDamage();
        if (this.isAmped && entity instanceof EntityLivingBase) {
            EntityLivingBase elb = (EntityLivingBase)entity;
            damage = (int)((double)damage + (double)((int)elb.func_110143_aJ()) * (this.getDamageAmpBonus() * (double)this.amp_level));
        }
        if (entity instanceof EntityPlayer) {
            if (!this.canDamagePlayer((EntityPlayer)entity)) return;
            entity.func_70097_a((DamageSource)new ArmorBypassDamageSource("ferroslug", this.fakeDrops, this.turretBase, (WorldServer)this.func_130014_f_()), (float)damage);
            entity.field_70172_ad = -1;
            this.playSound();
        } else {
            if (!this.canDamageEntity(entity)) return;
            this.setTagsForTurretHit(entity);
            entity.func_70097_a((DamageSource)new ArmorBypassDamageSource("ferroslug", this.fakeDrops, this.turretBase, (WorldServer)this.func_130014_f_()), (float)damage);
            entity.field_70172_ad = -1;
            this.playSound();
        }
        this.func_70106_y();
    }

    @Override
    public void playSound() {
        Random random = new Random();
        this.func_130014_f_().func_184133_a(null, new BlockPos(this.field_70165_t, this.field_70163_u, this.field_70161_v), ModSounds.railGunHitSound, SoundCategory.AMBIENT, OMTConfigHandler.getTurretSoundVolume(), random.nextFloat() + 0.5f);
    }

    @ParametersAreNonnullByDefault
    protected void func_184231_a(double y, boolean onGroundIn, IBlockState state, BlockPos pos) {
        this.field_70163_u += 12.0;
    }

    protected float func_70185_h() {
        return this.gravity;
    }

    @ParametersAreNonnullByDefault
    protected void func_70184_a(RayTraceResult result) {
    }

    @Override
    public double getDamageAmpBonus() {
        return OMTConfigHandler.getRailgunTurretSettings().getDamageAmp();
    }
}

