/*
 * Decompiled with CFR 0.152.
 */
package extracells.integration.opencomputers;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.implementations.tiles.IWirelessAccessPoint;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridBlock;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.util.AEPartLocation;
import appeng.api.util.DimensionalCoord;
import appeng.api.util.WorldCoord;
import extracells.integration.opencomputers.NetworkControl;
import extracells.integration.opencomputers.WirelessHandlerUpgradeAE$;
import extracells.registries.ItemEnum;
import extracells.util.FluidHelper;
import extracells.util.MachineSource;
import extracells.util.StorageChannels$;
import li.cil.oc.api.internal.Agent;
import li.cil.oc.api.internal.Database;
import li.cil.oc.api.internal.Drone;
import li.cil.oc.api.internal.MultiTank;
import li.cil.oc.api.internal.Robot;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.Connector;
import li.cil.oc.api.network.Environment;
import li.cil.oc.api.network.Message;
import li.cil.oc.api.network.Node;
import li.cil.oc.api.prefab.AbstractManagedEnvironment;
import li.cil.oc.server.network.Component;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.JavaConversions$;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.RichInt;
import scala.runtime.RichLong;

public abstract class NetworkControl$class {
    public static ItemStack getComponent(NetworkControl $this) {
        if ($this.robot() == null) {
            if ($this.drone() != null) {
                for (ItemStack item : $this.drone().internalComponents()) {
                    if (item == null) continue;
                    Item item2 = item.func_77973_b();
                    Item item3 = ItemEnum.OCUPGRADE.getItem();
                    if (item2 != null ? !item2.equals(item3) : item3 != null) continue;
                    return item;
                }
            }
            return null;
        }
        return $this.robot().func_70301_a($this.robot().componentSlot(((AbstractManagedEnvironment)$this).node().address()));
    }

    public static IGridHost getSecurity(NetworkControl $this) {
        IGridHost sec;
        if ($this.host().world().field_72995_K) {
            return null;
        }
        ItemStack component = $this.getComponent();
        return $this.checkRange(component, sec = (IGridHost)AEApi.instance().registries().locatable().getLocatableBy($this.getAEKey(component))) ? sec : null;
    }

    public static boolean checkRange(NetworkControl $this, ItemStack stack, IGridHost sec) {
        NonLocalReturnControl nonLocalReturnControl2;
        block13: {
            boolean bl;
            Object object = new Object();
            try {
                if (sec == null) {
                    return false;
                }
                IGridNode gridNode = sec.getGridNode(AEPartLocation.INTERNAL);
                if (gridNode == null) {
                    return false;
                }
                IGrid grid = gridNode.getGrid();
                if (grid == null) {
                    return false;
                }
                int n = stack.func_77952_i();
                switch (n) {
                    default: {
                        IGridBlock gridBlock = gridNode.getGridBlock();
                        if (gridBlock == null) {
                            return false;
                        }
                        DimensionalCoord loc = gridBlock.getLocation();
                        if (loc == null) {
                            return false;
                        }
                        JavaConversions$.MODULE$.iterableAsScalaIterable((Iterable)grid.getMachines((Class)AEApi.instance().definitions().blocks().wirelessAccessPoint().maybeEntity().get())).withFilter((Function1)new Serializable($this){

                            public final boolean apply(IGridNode check$ifrefutable$2) {
                                IGridNode iGridNode = check$ifrefutable$2;
                                boolean bl = iGridNode != null;
                                return bl;
                            }
                        }).foreach((Function1)new Serializable($this, object){
                            private final /* synthetic */ NetworkControl $outer;
                            private final Object nonLocalReturnKey1$1;

                            public final void apply(IGridNode node) {
                                IWirelessAccessPoint accessPoint = (IWirelessAccessPoint)node;
                                WorldCoord distance = accessPoint.getLocation().subtract((int)this.$outer.agent().xPosition(), (int)this.$outer.agent().yPosition(), (int)this.$outer.agent().zPosition());
                                int squaredDistance = distance.x * distance.x + distance.y * distance.y + distance.z * distance.z;
                                double range = accessPoint.getRange() / (double)2;
                                if ((double)squaredDistance <= range * range) {
                                    throw new NonLocalReturnControl.mcZ.sp(this.nonLocalReturnKey1$1, true);
                                }
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                            }
                        });
                        bl = false;
                        break;
                    }
                    case 1: {
                        IGridBlock gridBlock = gridNode.getGridBlock();
                        if (gridBlock == null) {
                            return false;
                        }
                        DimensionalCoord loc = gridBlock.getLocation();
                        if (loc == null) {
                            return false;
                        }
                        JavaConversions$.MODULE$.iterableAsScalaIterable((Iterable)grid.getMachines((Class)AEApi.instance().definitions().blocks().wirelessAccessPoint().maybeEntity().get())).withFilter((Function1)new Serializable($this){

                            public final boolean apply(IGridNode check$ifrefutable$1) {
                                IGridNode iGridNode = check$ifrefutable$1;
                                boolean bl = iGridNode != null;
                                return bl;
                            }
                        }).foreach((Function1)new Serializable($this, object){
                            private final /* synthetic */ NetworkControl $outer;
                            private final Object nonLocalReturnKey1$1;

                            public final void apply(IGridNode node) {
                                IWirelessAccessPoint accessPoint = (IWirelessAccessPoint)node;
                                WorldCoord distance = accessPoint.getLocation().subtract((int)this.$outer.agent().xPosition(), (int)this.$outer.agent().yPosition(), (int)this.$outer.agent().zPosition());
                                int squaredDistance = distance.x * distance.x + distance.y * distance.y + distance.z * distance.z;
                                double range = accessPoint.getRange();
                                if ((double)squaredDistance <= range * range) {
                                    throw new NonLocalReturnControl.mcZ.sp(this.nonLocalReturnKey1$1, true);
                                }
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                            }
                        });
                        bl = false;
                        break;
                    }
                    case 0: {
                        bl = grid.getMachines((Class)AEApi.instance().definitions().blocks().wirelessAccessPoint().maybeEntity().get()).iterator().hasNext();
                        break;
                    }
                }
            }
            catch (NonLocalReturnControl nonLocalReturnControl2) {
                if (nonLocalReturnControl2.key() != object) break block13;
                bl = nonLocalReturnControl2.value$mcZ$sp();
            }
            return bl;
        }
        throw nonLocalReturnControl2;
    }

    public static IGrid getGrid(NetworkControl $this) {
        if ($this.host().world().field_72995_K) {
            return null;
        }
        IGridHost securityTerminal = $this.getSecurity();
        if (securityTerminal == null) {
            return null;
        }
        IGridNode gridNode = securityTerminal.getGridNode(AEPartLocation.INTERNAL);
        if (gridNode == null) {
            return null;
        }
        return gridNode.getGrid();
    }

    public static long getAEKey(NetworkControl $this, ItemStack stack) {
        try {
            return new StringOps(Predef$.MODULE$.augmentString(WirelessHandlerUpgradeAE$.MODULE$.getEncryptionKey(stack))).toLong();
        }
        catch (Throwable throwable) {
            return 0L;
        }
    }

    public static IMEMonitor getFluidInventory(NetworkControl $this) {
        IGrid grid = $this.getGrid();
        if (grid == null) {
            return null;
        }
        IStorageGrid storage = (IStorageGrid)grid.getCache(IStorageGrid.class);
        if (storage == null) {
            return null;
        }
        return storage.getInventory((IStorageChannel)StorageChannels$.MODULE$.FLUID());
    }

    public static IMEMonitor getItemInventory(NetworkControl $this) {
        IGrid grid = $this.getGrid();
        if (grid == null) {
            return null;
        }
        IStorageGrid storage = (IStorageGrid)grid.getCache(IStorageGrid.class);
        if (storage == null) {
            return null;
        }
        return storage.getInventory((IStorageChannel)StorageChannels$.MODULE$.ITEM());
    }

    @Callback(doc="function([number:amount]):number -- Transfer selected items to your ae system.")
    public static Object[] sendItems(NetworkControl $this, Context context, Arguments args) {
        int selected = $this.agent().selectedSlot();
        IInventory invRobot = $this.agent().mainInventory();
        if (invRobot.func_70302_i_() <= 0) {
            return new Object[]{new RichInt(Predef$.MODULE$.intWrapper(0)).underlying()};
        }
        ItemStack stack = invRobot.func_70301_a(selected);
        IMEMonitor<IAEItemStack> inv = $this.getItemInventory();
        if (stack == null || stack.func_190926_b() || inv == null) {
            return new Object[]{new RichInt(Predef$.MODULE$.intWrapper(0)).underlying()};
        }
        int amount = Math.min(args.optInteger(0, 64), stack.func_190916_E());
        ItemStack stack2 = stack.func_77946_l();
        stack2.func_190920_e(amount);
        IAEItemStack notInjectet = (IAEItemStack)inv.injectItems(StorageChannels$.MODULE$.ITEM().createStack((Object)stack2), Actionable.MODULATE, (IActionSource)new MachineSource((IActionHost)$this.tile()));
        if (notInjectet == null) {
            stack.func_190920_e(stack.func_190916_E() - amount);
            if (stack.func_190916_E() <= 0) {
                invRobot.func_70299_a(selected, ItemStack.field_190927_a);
            } else {
                invRobot.func_70299_a(selected, stack);
            }
            return new Object[]{new RichInt(Predef$.MODULE$.intWrapper(amount)).underlying()};
        }
        stack.func_190920_e(stack.func_190916_E() - amount + (int)notInjectet.getStackSize());
        if (stack.func_190916_E() <= 0) {
            invRobot.func_70299_a(selected, ItemStack.field_190927_a);
        } else {
            invRobot.func_70299_a(selected, stack);
        }
        return new Object[]{new RichLong(Predef$.MODULE$.longWrapper((long)stack2.func_190916_E() - notInjectet.getStackSize())).underlying()};
    }

    @Callback(doc="function(database:address, entry:number[, number:amount]):number -- Get items from your ae system.")
    public static Object[] requestItems(NetworkControl $this, Context context, Arguments args) {
        String address = args.checkString(0);
        int entry = args.checkInteger(1);
        int amount = args.optInteger(2, 64);
        int selected = $this.agent().selectedSlot();
        IInventory invRobot = $this.agent().mainInventory();
        if (invRobot.func_70302_i_() <= 0) {
            return new Object[]{new RichInt(Predef$.MODULE$.intWrapper(0)).underlying()};
        }
        IMEMonitor<IAEItemStack> inv = $this.getItemInventory();
        if (inv == null) {
            return new Object[]{new RichInt(Predef$.MODULE$.intWrapper(0)).underlying()};
        }
        Node n = ((AbstractManagedEnvironment)$this).node().network().node(address);
        if (n == null) {
            throw new IllegalArgumentException("no such component");
        }
        if (n instanceof Component) {
            Component component = (Component)n;
            Environment env = n.host();
            if (env instanceof Database) {
                ItemStack sel2;
                ItemStack itemStack;
                Database database = (Database)env;
                ItemStack sel = invRobot.func_70301_a(selected);
                int inSlot = sel == null ? 0 : sel.func_190916_E();
                int maxSize = sel == null ? 64 : sel.func_77976_d();
                ItemStack stack = database.getStackInSlot(entry - 1);
                if (stack == null) {
                    return new Object[]{new RichInt(Predef$.MODULE$.intWrapper(0)).underlying()};
                }
                stack.func_190920_e(Math.min(amount, maxSize - inSlot));
                ItemStack stack2 = stack.func_77946_l();
                stack2.func_190920_e(1);
                if (sel == null) {
                    itemStack = null;
                } else {
                    ItemStack sel3 = sel.func_77946_l();
                    sel3.func_190920_e(1);
                    itemStack = sel2 = sel3;
                }
                if (sel == null || ItemStack.func_77989_b((ItemStack)sel2, (ItemStack)stack2) || sel2.func_190926_b()) {
                    IAEItemStack extracted = (IAEItemStack)inv.extractItems(StorageChannels$.MODULE$.ITEM().createStack((Object)stack), Actionable.MODULATE, (IActionSource)new MachineSource((IActionHost)$this.tile()));
                    if (extracted == null) {
                        return new Object[]{new RichInt(Predef$.MODULE$.intWrapper(0)).underlying()};
                    }
                    int ext = (int)extracted.getStackSize();
                    stack.func_190920_e(inSlot + ext);
                    invRobot.func_70299_a(selected, stack);
                    return new Object[]{new RichInt(Predef$.MODULE$.intWrapper(ext)).underlying()};
                }
                return new Object[]{new RichInt(Predef$.MODULE$.intWrapper(0)).underlying()};
            }
            throw new IllegalArgumentException("not a database");
        }
        throw new IllegalArgumentException("no such component");
    }

    @Callback(doc="function([number:amount]):number -- Transfer selecte fluid to your ae system.")
    public static Object[] sendFluids(NetworkControl $this, Context context, Arguments args) {
        Object[] objectArray;
        int selected = $this.agent().selectedTank();
        MultiTank tanks = $this.agent().tank();
        if (tanks.tankCount() <= 0) {
            return new Object[]{new RichInt(Predef$.MODULE$.intWrapper(0)).underlying()};
        }
        IFluidTank tank = tanks.getFluidTank(selected);
        IMEMonitor<IAEFluidStack> inv = $this.getFluidInventory();
        if (tank == null || inv == null || tank.getFluid() == null) {
            return new Object[]{new RichInt(Predef$.MODULE$.intWrapper(0)).underlying()};
        }
        int amount = Math.min(args.optInteger(0, tank.getCapacity()), tank.getFluidAmount());
        FluidStack fluid = tank.getFluid();
        FluidStack fluid2 = fluid.copy();
        fluid2.amount = amount;
        IAEFluidStack notInjectet = (IAEFluidStack)inv.injectItems(StorageChannels$.MODULE$.FLUID().createStack((Object)fluid2), Actionable.MODULATE, (IActionSource)new MachineSource((IActionHost)$this.tile()));
        if (notInjectet == null) {
            tank.drain(amount, true);
            objectArray = new Object[]{new RichInt(Predef$.MODULE$.intWrapper(amount)).underlying()};
        } else {
            tank.drain(amount - (int)notInjectet.getStackSize(), true);
            objectArray = new Object[]{new RichLong(Predef$.MODULE$.longWrapper((long)amount - notInjectet.getStackSize())).underlying()};
        }
        return objectArray;
    }

    @Callback(doc="function(database:address, entry:number[, number:amount]):number -- Get fluid from your ae system.")
    public static Object[] requestFluids(NetworkControl $this, Context context, Arguments args) {
        String address = args.checkString(0);
        int entry = args.checkInteger(1);
        int amount = args.optInteger(2, 1000);
        MultiTank tanks = $this.agent().tank();
        int selected = $this.agent().selectedTank();
        if (tanks.tankCount() <= 0) {
            return new Object[]{new RichInt(Predef$.MODULE$.intWrapper(0)).underlying()};
        }
        IFluidTank tank = tanks.getFluidTank(selected);
        IMEMonitor<IAEFluidStack> inv = $this.getFluidInventory();
        if (tank == null || inv == null) {
            return new Object[]{new RichInt(Predef$.MODULE$.intWrapper(0)).underlying()};
        }
        Node n = ((AbstractManagedEnvironment)$this).node().network().node(address);
        if (n == null) {
            throw new IllegalArgumentException("no such component");
        }
        if (n instanceof Component) {
            Component component = (Component)n;
            Environment env = n.host();
            if (env instanceof Database) {
                IAEFluidStack extracted;
                Database database = (Database)env;
                FluidStack fluid = FluidHelper.getFluidFromContainer(database.getStackInSlot(entry - 1));
                fluid.amount = amount;
                FluidStack fluid2 = fluid.copy();
                fluid2.amount = tank.fill(fluid, false);
                if (fluid2.amount == 0) {
                    return new Object[]{new RichInt(Predef$.MODULE$.intWrapper(0)).underlying()};
                }
                IAEFluidStack iAEFluidStack = extracted = (IAEFluidStack)inv.extractItems(StorageChannels$.MODULE$.FLUID().createStack((Object)fluid2), Actionable.MODULATE, (IActionSource)new MachineSource((IActionHost)$this.tile()));
                Integer n2 = BoxesRunTime.boxToInteger((int)0);
                if (!(iAEFluidStack != null ? !iAEFluidStack.equals(n2) : n2 != null)) {
                    return new Object[]{new RichInt(Predef$.MODULE$.intWrapper(0)).underlying()};
                }
                return new Object[]{new RichInt(Predef$.MODULE$.intWrapper(tank.fill(extracted.getFluidStack(), true))).underlying()};
            }
            throw new IllegalArgumentException("not a database");
        }
        throw new IllegalArgumentException("no such component");
    }

    @Callback(doc="function():boolean -- Return true if the card is linket to your ae network.")
    public static Object[] isLinked(NetworkControl $this, Context context, Arguments args) {
        boolean isLinked = $this.getGrid() != null;
        return new Object[]{Predef$.MODULE$.boolean2Boolean(isLinked)};
    }

    public static void update(NetworkControl $this) {
        $this.extracells$integration$opencomputers$NetworkControl$$super$update();
        if ($this.host().world().func_82737_E() % 10L == 0L && $this.isActive() && !((Connector)((AbstractManagedEnvironment)$this).node()).tryChangeBuffer(-$this.getEnergy())) {
            $this.isActive_$eq(false);
        }
    }

    public static double getEnergy(NetworkControl $this) {
        double d;
        ItemStack c = $this.getComponent();
        if (c == null) {
            d = 0.0;
        } else {
            int n = c.func_77952_i();
            switch (n) {
                default: {
                    d = 0.05;
                    break;
                }
                case 1: {
                    d = 0.3;
                    break;
                }
                case 0: {
                    d = 0.6;
                }
            }
        }
        return d;
    }

    public static void onMessage(NetworkControl $this, Message message) {
        $this.extracells$integration$opencomputers$NetworkControl$$super$onMessage(message);
        String string = message.name();
        String string2 = "computer.stopped";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            $this.isActive_$eq(false);
        } else {
            String string3 = message.name();
            String string4 = "computer.started";
            if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                $this.isActive_$eq(true);
            }
        }
    }

    public static void $init$(NetworkControl $this) {
        $this.extracells$integration$opencomputers$NetworkControl$_setter_$robot_$eq($this.host() instanceof Robot ? (Robot)$this.host() : null);
        $this.extracells$integration$opencomputers$NetworkControl$_setter_$drone_$eq($this.host() instanceof Drone ? (Drone)$this.host() : null);
        $this.isActive_$eq(false);
        $this.extracells$integration$opencomputers$NetworkControl$_setter_$agent_$eq((Agent)$this.host());
    }
}

