/*
 * Decompiled with CFR 0.152.
 */
package extracells.inventory.cell;

import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.config.FuzzyMode;
import appeng.api.config.IncludeExclude;
import appeng.api.networking.security.IActionSource;
import appeng.api.storage.ICellInventory;
import appeng.api.storage.ICellInventoryHandler;
import appeng.api.storage.ICellWorkbenchItem;
import appeng.api.storage.ISaveProvider;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.data.IItemList;
import com.google.common.collect.Lists;
import extracells.api.IGasStorageCell;
import extracells.api.IHandlerGasStorage;
import extracells.api.gas.IAEGasStack;
import extracells.util.GasUtil;
import extracells.util.StorageChannels;
import java.util.ArrayList;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.IItemHandler;

public class HandlerItemStorageGas
implements ICellInventoryHandler<IAEGasStack>,
IHandlerGasStorage,
ICellInventory<IAEGasStack> {
    private ItemStack storageStack;
    private NBTTagCompound stackTag;
    protected ArrayList<GasStack> gasStacks = new ArrayList();
    private ArrayList<Gas> prioritizedGases = new ArrayList();
    private int totalTypes;
    private int totalBytes;
    private ISaveProvider saveProvider;

    public HandlerItemStorageGas(ItemStack _storageStack, ISaveProvider _saveProvider) {
        if (!_storageStack.func_77942_o()) {
            _storageStack.func_77982_d(new NBTTagCompound());
        }
        this.storageStack = _storageStack;
        this.stackTag = _storageStack.func_77978_p();
        this.totalTypes = ((IGasStorageCell)_storageStack.func_77973_b()).getMaxTypes(_storageStack);
        this.totalBytes = ((IGasStorageCell)_storageStack.func_77973_b()).getMaxBytes(_storageStack) * 250;
        for (int i = 0; i < this.totalTypes; ++i) {
            if (this.stackTag.func_74764_b("Gas#" + i)) {
                this.gasStacks.add(GasStack.readFromNBT((NBTTagCompound)this.stackTag.func_74775_l("Gas#" + i)));
                continue;
            }
            this.gasStacks.add(GasUtil.getGasStack(FluidStack.loadFluidStackFromNBT((NBTTagCompound)this.stackTag.func_74775_l("Fluid#" + i))));
        }
        this.saveProvider = _saveProvider;
    }

    public HandlerItemStorageGas(ItemStack _storageStack, ISaveProvider _saveProvider, ArrayList<Gas> _filter) {
        this(_storageStack, _saveProvider);
        if (_filter != null) {
            this.prioritizedGases = _filter;
        }
    }

    private boolean allowedByFormat(Gas gas) {
        return !this.isFormatted() || this.prioritizedGases.contains(gas);
    }

    public boolean canAccept(IAEGasStack input) {
        if (input == null) {
            return false;
        }
        for (GasStack gasStack : this.gasStacks) {
            if (gasStack != null && gasStack.getGas() != input.getGas()) continue;
            return this.allowedByFormat((Gas)input.getGas());
        }
        return false;
    }

    public IAEGasStack extractItems(IAEGasStack request, Actionable mode, IActionSource src) {
        if (request == null || !this.allowedByFormat((Gas)request.getGas())) {
            return null;
        }
        ArrayList currentGases = Lists.newArrayList(this.gasStacks);
        for (int i = 0; i < this.gasStacks.size(); ++i) {
            IAEGasStack removedStack;
            GasStack currentStack = this.gasStacks.get(i);
            if (currentStack == null || !currentStack.getGas().getName().equals(((Gas)request.getGas()).getName())) continue;
            long endAmount = (long)currentStack.amount - request.getStackSize();
            if (endAmount >= 0L) {
                removedStack = request.copy();
                GasStack toWrite = new GasStack(currentStack.getGas(), (int)endAmount);
                currentGases.set(i, toWrite);
                if (mode == Actionable.MODULATE) {
                    this.writeGasToSlot(i, toWrite);
                }
            } else {
                removedStack = (IAEGasStack)StorageChannels.GAS().createStack(currentStack.copy());
                if (mode == Actionable.MODULATE) {
                    this.writeGasToSlot(i, null);
                }
            }
            if (removedStack != null && removedStack.getStackSize() > 0L) {
                this.requestSave();
            }
            return removedStack;
        }
        return null;
    }

    public int freeBytes() {
        int i = 0;
        for (GasStack stack : this.gasStacks) {
            if (stack == null) continue;
            i += stack.amount;
        }
        return this.totalBytes - i;
    }

    public AccessRestriction getAccess() {
        return AccessRestriction.READ_WRITE;
    }

    public IItemList<IAEGasStack> getAvailableItems(IItemList<IAEGasStack> out) {
        for (GasStack gasStack : this.gasStacks) {
            if (gasStack == null) continue;
            out.add(StorageChannels.GAS().createStack(gasStack));
        }
        return out;
    }

    public IStorageChannel getChannel() {
        return StorageChannels.GAS();
    }

    public int getPriority() {
        return 0;
    }

    public int getSlot() {
        return 0;
    }

    public IAEGasStack injectItems(IAEGasStack input, Actionable mode, IActionSource src) {
        GasStack toWrite;
        GasStack currentStack;
        int i;
        if (input == null || !this.allowedByFormat((Gas)input.getGas())) {
            return input;
        }
        IAEGasStack notAdded = input.copy();
        ArrayList currentGases = Lists.newArrayList(this.gasStacks);
        for (i = 0; i < currentGases.size(); ++i) {
            currentStack = (GasStack)currentGases.get(i);
            if (notAdded == null || currentStack == null || input.getGas() != currentStack.getGas()) continue;
            if (notAdded.getStackSize() <= (long)this.freeBytes()) {
                toWrite = new GasStack(currentStack.getGas(), currentStack.amount + (int)notAdded.getStackSize());
                currentGases.set(i, toWrite);
                if (mode == Actionable.MODULATE) {
                    this.writeGasToSlot(i, toWrite);
                }
                notAdded = null;
                continue;
            }
            toWrite = new GasStack(currentStack.getGas(), currentStack.amount + this.freeBytes());
            currentGases.set(i, toWrite);
            if (mode == Actionable.MODULATE) {
                this.writeGasToSlot(i, toWrite);
            }
            notAdded.setStackSize(notAdded.getStackSize() - (long)this.freeBytes());
        }
        for (i = 0; i < currentGases.size(); ++i) {
            currentStack = (GasStack)currentGases.get(i);
            if (notAdded == null || currentStack != null) continue;
            if (input.getStackSize() <= (long)this.freeBytes()) {
                toWrite = (GasStack)notAdded.getGasStack();
                currentGases.set(i, toWrite);
                if (mode == Actionable.MODULATE) {
                    this.writeGasToSlot(i, toWrite);
                }
                notAdded = null;
                continue;
            }
            toWrite = new GasStack((Gas)notAdded.getGas(), this.freeBytes());
            currentGases.set(i, toWrite);
            if (mode == Actionable.MODULATE) {
                this.writeGasToSlot(i, toWrite);
            }
            notAdded.setStackSize(notAdded.getStackSize() - (long)this.freeBytes());
        }
        if (notAdded == null || !notAdded.equals(input)) {
            this.requestSave();
        }
        return notAdded;
    }

    @Override
    public boolean isFormatted() {
        if (this.prioritizedGases.isEmpty()) {
            return false;
        }
        for (Gas currentGas : this.prioritizedGases) {
            if (currentGas == null) continue;
            return true;
        }
        return false;
    }

    public boolean isPrioritized(IAEGasStack input) {
        return input != null && this.prioritizedGases.contains(input.getGas());
    }

    private void requestSave() {
        if (this.saveProvider != null) {
            this.saveProvider.saveChanges((ICellInventory)this);
        }
    }

    @Override
    public int totalBytes() {
        return this.totalBytes;
    }

    @Override
    public int totalTypes() {
        return this.totalTypes;
    }

    @Override
    public int usedBytes() {
        return this.totalBytes - this.freeBytes();
    }

    @Override
    public int usedTypes() {
        int i = 0;
        for (GasStack stack : this.gasStacks) {
            if (stack == null) continue;
            ++i;
        }
        return i;
    }

    public boolean validForPass(int i) {
        return true;
    }

    protected void writeGasToSlot(int i, GasStack gasStack) {
        NBTTagCompound gasTag = new NBTTagCompound();
        if (gasStack != null && gasStack.amount > 0) {
            gasTag = gasStack.write(gasTag);
            this.stackTag.func_74782_a("Gas#" + i, (NBTBase)gasTag);
        } else {
            this.stackTag.func_82580_o("Gas#" + i);
        }
        this.gasStacks.set(i, gasStack);
        this.stackTag.func_82580_o("Fluid#" + i);
    }

    public ICellInventory<IAEGasStack> getCellInv() {
        return this;
    }

    public boolean isPreformatted() {
        return this.isFormatted();
    }

    public boolean isFuzzy() {
        return this.getFuzzyMode() != FuzzyMode.IGNORE_ALL;
    }

    public IncludeExclude getIncludeExcludeMode() {
        return IncludeExclude.WHITELIST;
    }

    public ItemStack getItemStack() {
        return this.storageStack;
    }

    protected ICellWorkbenchItem getCellItem() {
        return (ICellWorkbenchItem)this.getItemStack().func_77973_b();
    }

    public double getIdleDrain() {
        return 1.0;
    }

    public FuzzyMode getFuzzyMode() {
        return this.getCellItem().getFuzzyMode(this.getItemStack());
    }

    public IItemHandler getConfigInventory() {
        return this.getCellItem().getConfigInventory(this.getItemStack());
    }

    public IItemHandler getUpgradesInventory() {
        return this.getCellItem().getUpgradesInventory(this.getItemStack());
    }

    public int getBytesPerType() {
        return 8;
    }

    public boolean canHoldNewItem() {
        long bytesFree = this.getFreeBytes();
        return (bytesFree > (long)this.getBytesPerType() || bytesFree == (long)this.getBytesPerType() && this.getUnusedItemCount() > 0) && this.getRemainingItemTypes() > 0L;
    }

    public long getTotalBytes() {
        return this.totalBytes();
    }

    public long getFreeBytes() {
        return this.freeBytes();
    }

    public long getUsedBytes() {
        return this.usedBytes();
    }

    public long getTotalItemTypes() {
        return this.totalTypes();
    }

    public long getStoredItemCount() {
        return 0L;
    }

    public long getStoredItemTypes() {
        return this.usedTypes();
    }

    public long getRemainingItemTypes() {
        return this.totalTypes() - this.usedTypes();
    }

    public long getRemainingItemCount() {
        return 0L;
    }

    public int getUnusedItemCount() {
        return 0;
    }

    public int getStatusForCell() {
        if (this.canHoldNewItem()) {
            return 1;
        }
        if (this.getRemainingItemCount() > 0L) {
            return 2;
        }
        return 3;
    }

    public void persist() {
        if (this.saveProvider != null) {
            this.saveProvider.saveChanges((ICellInventory)this);
        }
    }
}

